/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.inventory;

import com.legacy.aether.api.accessories.AccessoryType;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.api.player.util.IAccessoryInventory;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.accessories.ItemAccessory;
import com.legacy.aether.network.AetherNetwork;
import com.legacy.aether.network.packets.PacketAccessory;
import com.legacy.aether.util.FilledList;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ObjectIntIdentityMap;

public class InventoryAccessories
implements IAccessoryInventory {
    private final FilledList<ItemStack> stacks = new FilledList<Object>(8, null);
    private ObjectIntIdentityMap orderedList = AccessoryType.createCompleteList();
    private IPlayerAether playerAether;

    public InventoryAccessories(IPlayerAether playerAether) {
        this.playerAether = playerAether;
    }

    public float getCurrentPlayerStrVsBlock(float original) {
        float f = original;
        if (this.wearingAccessory(new ItemStack(ItemsAether.zanite_pendant))) {
            f *= 1.0f + (float)this.getStackInSlot(AccessoryType.PENDANT).func_77960_j() / ((float)this.getStackInSlot(AccessoryType.PENDANT).func_77958_k() * 3.0f);
        }
        if (this.getStackInSlot(AccessoryType.RING) != null && this.getStackInSlot(AccessoryType.RING).func_77973_b() == ItemsAether.zanite_ring) {
            f *= 1.0f + (float)this.getStackInSlot(AccessoryType.RING).func_77960_j() / ((float)this.getStackInSlot(AccessoryType.RING).func_77958_k() * 3.0f);
        }
        if (this.getStackInSlot(AccessoryType.EXTRA_RING) != null && this.getStackInSlot(AccessoryType.EXTRA_RING).func_77973_b() == ItemsAether.zanite_ring) {
            f *= 1.0f + (float)this.getStackInSlot(AccessoryType.EXTRA_RING).func_77960_j() / ((float)this.getStackInSlot(AccessoryType.EXTRA_RING).func_77958_k() * 3.0f);
        }
        return f == original ? original : f + original;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int slot) {
        return this.stacks.get(slot);
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack.field_77994_a <= size) {
            this.func_70299_a(slot, null);
            return stack;
        }
        if (stack.field_77994_a == 0) {
            this.func_70299_a(slot, null);
        }
        return this.stacks.get(slot).func_77979_a(size);
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (this.func_70301_a(slot) != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.stacks.set(slot, stack);
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "aether_legacy:accessories";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        if (!this.playerAether.getEntity().field_70170_p.field_72995_K && this.playerAether.getEntity() instanceof EntityPlayer) {
            AetherNetwork.sendToAll(new PacketAccessory(this.playerAether));
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !player.func_70055_a(Material.field_151567_E) || !player.field_70128_L;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemAccessory) {
            return (this.orderedList.func_148745_a(slot) == ((ItemAccessory)stack.func_77973_b()).getType() || this.orderedList.func_148745_a(slot) == ((ItemAccessory)stack.func_77973_b()).getExtraType()) && this.func_70301_a(slot) == null;
        }
        return false;
    }

    @Override
    public void dropAccessories() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            this.playerAether.getEntity().func_145779_a(stack.func_77973_b(), stack.field_77994_a);
        }
        this.func_70296_d();
    }

    @Override
    public void damageAccessory(int damage, AccessoryType type) {
        ItemStack stack = this.getStackInSlot(type);
        if (stack != null) {
            stack.func_77972_a(damage, this.playerAether.getEntity());
        }
    }

    @Override
    public void damageWornStack(int damage, ItemStack search) {
        int slot = -1;
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack index = this.stacks.get(i);
            if (slot != -1 || index == null || search.func_77973_b() != index.func_77973_b()) continue;
            slot = i;
        }
        if (slot != -1) {
            this.stacks.get(slot).func_77972_a(damage, this.playerAether.getEntity());
            ItemStack stack = this.stacks.get(slot);
            if (stack.field_77994_a == 0) {
                this.func_70299_a(slot, null);
                this.playerAether.getEntity().func_70669_a(stack);
            }
        }
    }

    @Override
    public void setAccessorySlot(AccessoryType type, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAccessory) {
            if (this.getStackInSlot(type) == null) {
                this.func_70299_a(this.orderedList.func_148747_b((Object)type), stack);
            } else if (this.getStackInSlot(((ItemAccessory)stack.func_77973_b()).getExtraType()) == null) {
                this.setAccessorySlot(((ItemAccessory)stack.func_77973_b()).getExtraType(), stack);
            }
        }
    }

    @Override
    public ItemStack getStackInSlot(AccessoryType type) {
        return this.func_70301_a(this.orderedList.func_148747_b((Object)type));
    }

    @Override
    public ItemStack removeStackFromAccessorySlot(AccessoryType type) {
        ItemStack stack = this.func_70301_a(this.orderedList.func_148747_b((Object)type));
        if (stack != null) {
            this.setAccessorySlot(type, null);
        }
        return stack;
    }

    @Override
    public int getAccessoryCount(ItemStack stack) {
        int count = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack accessoryStack = this.func_70301_a(i);
            if (accessoryStack == null || accessoryStack.func_77973_b() != stack.func_77973_b()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean setAccessorySlot(ItemStack stack) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_94041_b(i, stack)) continue;
            this.stacks.set(i, stack);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean wearingAccessory(ItemStack stack) {
        boolean flag = false;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack accessoryStack = this.func_70301_a(i);
            if (flag || accessoryStack == null || accessoryStack.func_77973_b() != stack.func_77973_b()) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean wearingArmor(ItemStack stack) {
        if (this.playerAether.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.playerAether.getEntity();
            boolean flag = false;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemStack armorStack = player.func_82169_q(i);
                if (flag || armorStack == null || armorStack.func_77973_b() != stack.func_77973_b()) continue;
                flag = true;
            }
            return flag;
        }
        EntityLivingBase entityLiving = this.playerAether.getEntity();
        boolean flag = false;
        for (int i = 1; i < 5; ++i) {
            ItemStack armorStack = entityLiving.func_71124_b(i);
            if (flag || armorStack == null || armorStack.func_77973_b() != stack.func_77973_b()) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public NBTTagList writeToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound stackCompound = new NBTTagCompound();
            stackCompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(stackCompound);
            nbttaglist.func_74742_a((NBTBase)stackCompound);
        }
        return nbttaglist;
    }

    @Override
    public void readFromNBT(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackCompound = list.func_150305_b(i);
            byte slot = stackCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.stacks.set(slot, ItemStack.func_77949_a((NBTTagCompound)stackCompound));
        }
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeInt(this.getAccessories().size());
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    @Override
    public void readData(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.stacks.set(i, ByteBufUtils.readItemStack((ByteBuf)buf));
        }
    }

    @Override
    public boolean isWearingZaniteSet() {
        return this.wearingArmor(new ItemStack(ItemsAether.zanite_helmet)) && this.wearingArmor(new ItemStack(ItemsAether.zanite_chestplate)) && this.wearingArmor(new ItemStack(ItemsAether.zanite_leggings)) && this.wearingArmor(new ItemStack(ItemsAether.zanite_boots)) && this.wearingAccessory(new ItemStack(ItemsAether.zanite_gloves));
    }

    @Override
    public boolean isWearingGravititeSet() {
        return this.wearingArmor(new ItemStack(ItemsAether.gravitite_helmet)) && this.wearingArmor(new ItemStack(ItemsAether.gravitite_chestplate)) && this.wearingArmor(new ItemStack(ItemsAether.gravitite_leggings)) && this.wearingArmor(new ItemStack(ItemsAether.gravitite_boots)) && this.wearingAccessory(new ItemStack(ItemsAether.gravitite_gloves));
    }

    @Override
    public boolean isWearingNeptuneSet() {
        return this.wearingArmor(new ItemStack(ItemsAether.neptune_helmet)) && this.wearingArmor(new ItemStack(ItemsAether.neptune_chestplate)) && this.wearingArmor(new ItemStack(ItemsAether.neptune_leggings)) && this.wearingArmor(new ItemStack(ItemsAether.neptune_boots)) && this.wearingAccessory(new ItemStack(ItemsAether.neptune_gloves));
    }

    @Override
    public boolean isWearingPhoenixSet() {
        return this.wearingArmor(new ItemStack(ItemsAether.phoenix_helmet)) && this.wearingArmor(new ItemStack(ItemsAether.phoenix_chestplate)) && this.wearingArmor(new ItemStack(ItemsAether.phoenix_leggings)) && this.wearingArmor(new ItemStack(ItemsAether.phoenix_boots)) && this.wearingAccessory(new ItemStack(ItemsAether.phoenix_gloves));
    }

    @Override
    public boolean isWearingValkyrieSet() {
        return this.wearingArmor(new ItemStack(ItemsAether.valkyrie_helmet)) && this.wearingArmor(new ItemStack(ItemsAether.valkyrie_chestplate)) && this.wearingArmor(new ItemStack(ItemsAether.valkyrie_leggings)) && this.wearingArmor(new ItemStack(ItemsAether.valkyrie_boots)) && this.wearingAccessory(new ItemStack(ItemsAether.valkyrie_gloves));
    }

    @Override
    public boolean isWearingObsidianSet() {
        return this.wearingArmor(new ItemStack(ItemsAether.obsidian_helmet)) && this.wearingArmor(new ItemStack(ItemsAether.obsidian_chestplate)) && this.wearingArmor(new ItemStack(ItemsAether.obsidian_leggings)) && this.wearingArmor(new ItemStack(ItemsAether.obsidian_boots)) && this.wearingAccessory(new ItemStack(ItemsAether.obsidian_gloves));
    }

    @Override
    public List<ItemStack> getAccessories() {
        return this.stacks;
    }
}

