/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.items.accessories;

import com.legacy.aether.Aether;
import com.legacy.aether.api.accessories.AccessoryType;
import com.legacy.aether.client.ClientProxy;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.registry.creative_tabs.AetherCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemAccessory
extends Item {
    public static final String ROOT = Aether.modAddress() + "textures/slots/slot_";
    protected final AccessoryType accessoryType;
    protected final AccessoryType extraType;
    public ResourceLocation texture;
    private int colorHex = 0xDDDDDD;
    private boolean isDungeonLoot = false;
    public static final IBehaviorDispenseItem DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            ItemStack itemstack = ItemAccessory.dispenseAccessory(source, stack);
            return itemstack != null ? itemstack : super.func_82487_b(source, stack);
        }
    };

    public ItemAccessory(AccessoryType type) {
        this.accessoryType = type;
        this.extraType = type == AccessoryType.RING ? AccessoryType.EXTRA_RING : (type == AccessoryType.MISC ? AccessoryType.EXTRA_MISC : null);
        this.texture = Aether.locate("textures/armor/accessory_base.png");
        this.func_77625_d(1);
        this.func_77637_a(AetherCreativeTabs.accessories);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DISPENSER_BEHAVIOR);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        super.func_94581_a(registry);
        ObjectIntIdentityMap orderedList = AccessoryType.createCompleteList();
        for (int i = 0; i < ClientProxy.ACCESSORY_ICONS.length; ++i) {
            ClientProxy.ACCESSORY_ICONS[i] = registry.func_94245_a(Aether.find("slots/" + ((AccessoryType)((Object)orderedList.func_148745_a(i))).getDisplayName()));
        }
    }

    public static ItemStack dispenseAccessory(IBlockSource blockSource, ItemStack stack) {
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)blockSource.func_82620_h());
        int i = blockSource.func_82623_d() + enumfacing.func_82601_c();
        int j = blockSource.func_82622_e() + enumfacing.func_96559_d();
        int k = blockSource.func_82621_f() + enumfacing.func_82599_e();
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
        List list = blockSource.func_82618_k().func_72872_a(EntityPlayer.class, axisalignedbb);
        if (list.isEmpty()) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)list.get(0);
        ItemStack itemstack = stack.func_77946_l();
        itemstack.field_77994_a = 1;
        PlayerAether playerAether = PlayerAether.get(player);
        if (!playerAether.getAccessoryInventory().setAccessorySlot(itemstack)) {
            return null;
        }
        --stack.field_77994_a;
        return stack;
    }

    public ItemStack func_77659_a(ItemStack stack, World worldIn, EntityPlayer player) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && PlayerAether.get(player).getAccessoryInventory().setAccessorySlot(heldItem.func_77946_l())) {
            --heldItem.field_77994_a;
            return heldItem;
        }
        return super.func_77659_a(stack, worldIn, player);
    }

    public AccessoryType getExtraType() {
        return this.extraType;
    }

    public AccessoryType getType() {
        return this.accessoryType;
    }

    public Item setColor(int color) {
        this.colorHex = color;
        return this;
    }

    public int getColor() {
        return this.colorHex;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isDungeonLoot ? ItemsAether.aether_loot : super.func_77613_e(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int meta) {
        return this.colorHex;
    }

    public ItemAccessory setDungeonLoot() {
        this.isDungeonLoot = true;
        return this;
    }

    public ItemAccessory setTexture(String location) {
        this.texture = Aether.locate("textures/armor/accessory_" + location + ".png");
        return this;
    }
}

