/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.items.tools;

import com.legacy.aether.Aether;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.util.EnumSkyrootBucketType;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.registry.creative_tabs.AetherCreativeTabs;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class ItemSkyrootBucket
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon waterBucket;
    @SideOnly(value=Side.CLIENT)
    private IIcon poisonBucket;
    @SideOnly(value=Side.CLIENT)
    private IIcon remedyBucket;
    @SideOnly(value=Side.CLIENT)
    private IIcon milkBucket;

    public ItemSkyrootBucket() {
        this.func_77627_a(true);
        this.func_77642_a(this);
        this.func_77637_a(AetherCreativeTabs.misc);
        this.func_111206_d(Aether.find("misc/buckets/skyroot_bucket"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        super.func_94581_a(registry);
        this.waterBucket = registry.func_94245_a(Aether.find("misc/buckets/skyroot_water_bucket"));
        this.poisonBucket = registry.func_94245_a(Aether.find("misc/buckets/skyroot_poison_bucket"));
        this.remedyBucket = registry.func_94245_a(Aether.find("misc/buckets/skyroot_remedy_bucket"));
        this.milkBucket = registry.func_94245_a(Aether.find("misc/buckets/skyroot_milk_bucket"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return meta == 1 ? this.waterBucket : (meta == 2 ? this.poisonBucket : (meta == 3 ? this.remedyBucket : (meta == 4 ? this.milkBucket : this.field_77791_bV)));
    }

    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        for (int meta = 0; meta < EnumSkyrootBucketType.values().length; ++meta) {
            subItems.add(new ItemStack((Item)this, 1, meta));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77960_j() == 3 ? EnumRarity.rare : super.func_77613_e(stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return EnumSkyrootBucketType.getType(stack.func_77960_j()) == EnumSkyrootBucketType.Empty ? 16 : 1;
    }

    public String func_77667_c(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        return this.func_77658_a() + "_" + EnumSkyrootBucketType.getType(meta).toString();
    }

    public ItemStack func_77659_a(ItemStack heldItem, World world, EntityPlayer player) {
        int meta = heldItem.func_77960_j();
        if (EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Water && EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Empty) {
            player.func_71008_a(heldItem, this.func_77626_a(heldItem));
            return heldItem;
        }
        boolean isEmpty = EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Empty;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        FillBucketEvent event = new FillBucketEvent(player, heldItem, world, movingobjectposition);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return heldItem;
        }
        if (movingobjectposition == null) {
            return heldItem;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.field_71075_bZ.field_75098_d) {
                return heldItem;
            }
            if (--heldItem.field_77994_a <= 0) {
                return event.result;
            }
            if (!player.field_71071_by.func_70441_a(event.result)) {
                player.func_71019_a(event.result, false);
            }
            return heldItem;
        }
        if (movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return heldItem;
        }
        int i = movingobjectposition.field_72311_b;
        int j = movingobjectposition.field_72312_c;
        int k = movingobjectposition.field_72309_d;
        if (!world.func_72962_a(player, i, j, k)) {
            return heldItem;
        }
        if (isEmpty) {
            if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, heldItem)) {
                return heldItem;
            }
            Block block = world.func_147439_a(i, j, k);
            Material material = block.func_149688_o();
            int l = world.func_72805_g(i, j, k);
            if (material == Material.field_151586_h && l == 0) {
                world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 11);
                player.func_71064_a(StatList.field_75929_E[Item.func_150891_b((Item)this)], 1);
                return this.fillBucket(heldItem, player, ItemsAether.skyroot_bucket);
            }
            return heldItem;
        }
        if (movingobjectposition.field_72310_e == 0) {
            --j;
        }
        if (movingobjectposition.field_72310_e == 1) {
            ++j;
        }
        if (movingobjectposition.field_72310_e == 2) {
            --k;
        }
        if (movingobjectposition.field_72310_e == 3) {
            ++k;
        }
        if (movingobjectposition.field_72310_e == 4) {
            --i;
        }
        if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, heldItem)) {
            return heldItem;
        }
        if (this.tryPlaceContainedLiquid(player, world, heldItem, i, j, k)) {
            player.func_71064_a(StatList.field_75929_E[Item.func_150891_b((Item)this)], 1);
            return !player.field_71075_bZ.field_75098_d ? new ItemStack(ItemsAether.skyroot_bucket) : heldItem;
        }
        return heldItem;
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        ItemStack result = new ItemStack(fullBucket, 1, 1);
        --emptyBuckets.field_77994_a;
        if (emptyBuckets.field_77994_a <= 0) {
            return result;
        }
        if (!player.field_71071_by.func_70441_a(result)) {
            player.func_71019_a(result, false);
        }
        return emptyBuckets;
    }

    public boolean tryPlaceContainedLiquid(EntityPlayer player, World world, ItemStack stack, int x, int y, int z) {
        boolean flag;
        if (EnumSkyrootBucketType.getType(stack.func_77960_j()) != EnumSkyrootBucketType.Water) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !flag) {
            return false;
        }
        if (world.field_73011_w.field_76575_d) {
            world.func_72908_a((double)x, (double)y, (double)z, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 0, 11);
        }
        return true;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityPlayer entityLiving) {
        return this.onBucketUsed(stack, worldIn, entityLiving);
    }

    public ItemStack onBucketUsed(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        PlayerAether player = PlayerAether.get(entityplayer);
        int meta = itemstack.func_77960_j();
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        if (EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Poison) {
            player.inflictPoison(200);
        } else if (EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Remedy) {
            player.inflictCure(200);
        } else if (EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Milk && !world.field_72995_K) {
            entityplayer.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
        return itemstack.field_77994_a <= 0 ? new ItemStack((Item)this, 1, 0) : itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        if (EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Water) {
            return 32;
        }
        return 0;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        if (EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Water) {
            return EnumAction.drink;
        }
        return EnumAction.none;
    }
}

