/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.player;

import com.legacy.aether.AetherConfig;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.api.player.util.IAccessoryInventory;
import com.legacy.aether.api.player.util.IAetherAbility;
import com.legacy.aether.api.player.util.IAetherBoss;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.entities.movement.AetherPoisonMovement;
import com.legacy.aether.inventory.InventoryAccessories;
import com.legacy.aether.items.tools.ItemValkyrieTool;
import com.legacy.aether.player.abilities.AbilityAccessories;
import com.legacy.aether.player.abilities.AbilityArmor;
import com.legacy.aether.player.abilities.AbilityFlight;
import com.legacy.aether.player.abilities.AbilityRepulsion;
import com.legacy.aether.player.perks.util.DonatorMoaSkin;
import com.legacy.aether.registry.achievements.AchievementsAether;
import com.legacy.aether.world.TeleporterAether;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class PlayerAether
implements IPlayerAether {
    private EntityPlayer player;
    public AetherPoisonMovement poisonMovement;
    private IAetherBoss focusedBoss;
    private IAccessoryInventory accessories = new InventoryAccessories(this);
    private final ArrayList<IAetherAbility> abilities = new ArrayList();
    public final ArrayList<Entity> clouds = new ArrayList(2);
    private int shardCount;
    public DonatorMoaSkin donatorMoaSkin = new DonatorMoaSkin();
    public boolean shouldRenderHalo;
    private boolean isJumping;
    private boolean isMountSneaking;
    private boolean inPortal;
    private int portalCounter;
    public int teleportDirection;
    private String hammerName = "Hammer of Notch";
    private int cooldown;
    private int cooldownMax;
    public float wingSinage;
    public float timeInPortal;
    public float prevTimeInPortal;

    public PlayerAether() {
        this.abilities.addAll(Arrays.asList(new AbilityAccessories(this), new AbilityArmor(this), new AbilityFlight(this), new AbilityRepulsion(this)));
    }

    public static PlayerAether get(EntityPlayer player) {
        return (PlayerAether)player.getExtendedProperties("aether_legacy:player_aether");
    }

    public void init(Entity entity, World world) {
        this.player = (EntityPlayer)entity;
        this.poisonMovement = new AetherPoisonMovement((EntityLivingBase)this.player);
    }

    @Override
    public void onUpdate() {
        int i;
        for (i = 0; i < this.getAbilities().size(); ++i) {
            IAetherAbility ability = this.getAbilities().get(i);
            if (!ability.shouldExecute()) continue;
            ability.onUpdate();
        }
        for (i = 0; i < this.clouds.size(); ++i) {
            Entity entity = this.clouds.get(i);
            if (!entity.field_70128_L) continue;
            this.clouds.remove(i);
        }
        if (this.cooldown > 0) {
            this.cooldown -= 2;
        }
        if (this.isInsideBlock(BlocksAether.aercloud)) {
            this.getEntity().field_70143_R = 0.0f;
        }
        this.wingSinage = !this.getEntity().field_70122_E ? (this.wingSinage += 0.75f) : (this.wingSinage += 0.15f);
        this.wingSinage = this.wingSinage > 6.283186f ? (this.wingSinage -= 6.283186f) : (this.wingSinage += 0.1f);
        this.poisonMovement.onUpdate();
        boolean hasJumped = (Boolean)ReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)this.getEntity(), (String[])new String[]{"isJumping", "field_70703_bu"});
        this.setJumping(hasJumped);
        this.getEntity().field_70170_p.field_72984_F.func_76320_a("portal");
        int i2 = this.getEntity().func_82145_z();
        if (this.getEntity().field_71093_bK == AetherConfig.getAetherDimensionID() && this.getEntity().field_70163_u < -2.0) {
            this.teleportPlayer(false);
        }
        if (this.inPortal) {
            if (this.getEntity().field_70154_o == null && this.portalCounter++ >= i2) {
                this.portalCounter = i2;
                this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
                if (!this.getEntity().field_70170_p.field_72995_K) {
                    this.teleportPlayer(true);
                    this.getEntity().func_71029_a((StatBase)AchievementsAether.enter_aether);
                }
            }
            this.inPortal = false;
        } else {
            if (this.portalCounter > 0) {
                this.portalCounter -= 4;
            }
            if (this.portalCounter < 0) {
                this.portalCounter = 0;
            }
        }
        if (this.getEntity().field_71088_bW > 0) {
            --this.getEntity().field_71088_bW;
        }
        this.getEntity().field_70170_p.field_72984_F.func_76319_b();
        if (!this.getEntity().field_70170_p.field_72995_K) {
            double distance;
            ItemStack stack = this.getEntity().func_71045_bC();
            double d = distance = this.getEntity().field_71075_bZ.field_75098_d ? 5.0 : 4.5;
            if (stack != null && stack.func_77973_b() instanceof ItemValkyrieTool) {
                distance = 10.0;
            }
            ((EntityPlayerMP)this.getEntity()).field_71134_c.setBlockReachDistance(distance);
        } else {
            this.prevTimeInPortal = this.timeInPortal;
            if (this.isInsideBlock(BlocksAether.aether_portal)) {
                this.timeInPortal += 0.0125f;
                if (this.timeInPortal >= 1.0f) {
                    this.timeInPortal = 1.0f;
                }
            } else if (this.getEntity().func_70644_a(Potion.field_76431_k) && this.getEntity().func_70660_b(Potion.field_76431_k).func_76459_b() > 60) {
                this.timeInPortal += 0.006666667f;
                if (this.timeInPortal > 1.0f) {
                    this.timeInPortal = 1.0f;
                }
            } else {
                if (this.timeInPortal > 0.0f) {
                    this.timeInPortal -= 0.05f;
                }
                if (this.timeInPortal < 0.0f) {
                    this.timeInPortal = 0.0f;
                }
            }
        }
    }

    @Override
    public void setInPortal() {
        if (this.getEntity().field_71088_bW > 0) {
            this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
        } else {
            double d0 = this.getEntity().field_70169_q - this.getEntity().field_70165_t;
            double d1 = this.getEntity().field_70166_s - this.getEntity().field_70161_v;
            if (!this.getEntity().field_70170_p.field_72995_K && !this.inPortal) {
                this.teleportDirection = Direction.func_82372_a((double)d0, (double)d1);
            }
            this.inPortal = true;
        }
    }

    public boolean isInsideBlock(Block block) {
        AxisAlignedBB boundingBox = this.getEntity().field_70121_D;
        int i = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int j = MathHelper.func_76128_c((double)(boundingBox.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)boundingBox.field_72338_b);
        int l = MathHelper.func_76128_c((double)(boundingBox.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(boundingBox.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    if (this.getEntity().field_70170_p.func_147439_a(k1, l1, i2) != block) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void teleportPlayer(boolean shouldSpawnPortal) {
        if (this.getEntity() instanceof EntityPlayerMP) {
            int previousDimension = this.getEntity().field_71093_bK;
            int transferDimension = previousDimension == AetherConfig.getAetherDimensionID() ? AetherConfig.getTravelDimensionID() : AetherConfig.getAetherDimensionID();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            TeleporterAether teleporter = new TeleporterAether(shouldSpawnPortal, server.func_71218_a(transferDimension));
            if (this.getEntity().field_70154_o != null) {
                this.getEntity().field_70154_o.func_70078_a(null);
            }
            if (this.getEntity().field_70153_n != null) {
                this.getEntity().field_70153_n.func_70078_a(null);
            }
            server.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)this.getEntity(), transferDimension, (Teleporter)teleporter);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound aetherTag = new NBTTagCompound();
        aetherTag.func_74768_a("shardCount", this.shardCount);
        aetherTag.func_74782_a("accessories", (NBTBase)this.getAccessoryInventory().writeToNBT(aetherTag));
        compound.func_74782_a("aetherI", (NBTBase)aetherTag);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound aetherTag = compound.func_74775_l("aetherI");
        this.updateShardCount(aetherTag.func_74762_e("shardCount"));
        this.getAccessoryInventory().readFromNBT(aetherTag.func_150295_c("accessories", 10));
    }

    @Override
    public void setFocusedBoss(IAetherBoss boss) {
        this.focusedBoss = boss;
    }

    @Override
    public IAetherBoss getFocusedBoss() {
        return this.focusedBoss;
    }

    @Override
    public void setAccessoryInventory(IAccessoryInventory inventory) {
        this.accessories = inventory;
    }

    @Override
    public IAccessoryInventory getAccessoryInventory() {
        return this.accessories;
    }

    @Override
    public ArrayList<IAetherAbility> getAbilities() {
        return this.abilities;
    }

    public EntityPlayer getEntity() {
        return this.player;
    }

    @Override
    public void inflictPoison(int ticks) {
        this.poisonMovement.inflictPoison(ticks);
    }

    @Override
    public boolean isPoisoned() {
        return this.poisonMovement.ticks > 0;
    }

    @Override
    public void inflictCure(int ticks) {
        this.poisonMovement.inflictCure(ticks);
    }

    @Override
    public boolean isCured() {
        return this.poisonMovement.ticks < 0;
    }

    @Override
    public void updateShardCount(int amount) {
        UUID uuid = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370706");
        AttributeModifier healthModifier = new AttributeModifier(uuid, "Aether Health Modifier", (double)amount * 2.0, 0);
        this.shardCount = amount;
        if (this.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(uuid) != null) {
            this.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(healthModifier);
        }
        this.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(healthModifier);
    }

    @Override
    public int getShardsUsed() {
        return this.shardCount;
    }

    @Override
    public int getMaxShardCount() {
        return AetherConfig.getMaxLifeShards();
    }

    @Override
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public void setMountSneaking(boolean isSneaking) {
        this.isMountSneaking = isSneaking;
    }

    @Override
    public boolean isMountSneaking() {
        return this.isMountSneaking;
    }

    @Override
    public boolean isDonator() {
        return true;
    }

    @Override
    public boolean setHammerCooldown(int cooldown, String hammerName) {
        if (this.cooldown <= 0) {
            this.cooldown = cooldown;
            this.cooldownMax = cooldown;
            this.hammerName = hammerName;
            return true;
        }
        return false;
    }

    @Override
    public String getHammerName() {
        return this.hammerName;
    }

    @Override
    public int getHammerCooldown() {
        return this.cooldown;
    }

    @Override
    public int getHammerMaxCooldown() {
        return this.cooldownMax;
    }
}

