/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.player;

import com.legacy.aether.entities.util.EntityHook;
import com.legacy.aether.inventory.InventoryAccessories;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.network.AetherNetwork;
import com.legacy.aether.network.packets.PacketAccessory;
import com.legacy.aether.network.packets.PacketAchievement;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.player.abilities.AbilityRepulsion;
import com.legacy.aether.registry.achievements.AchievementsAether;
import com.legacy.aether.registry.achievements.AetherAchievement;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerAetherEvents {
    @SubscribeEvent
    public void onPlayerAetherConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            event.entity.registerExtendedProperties("aether_legacy:player_aether", (IExtendedEntityProperties)new PlayerAether());
        } else if (event.entity instanceof EntityLivingBase) {
            event.entity.registerExtendedProperties("aether_legacy:entity_hook", (IExtendedEntityProperties)new EntityHook());
        }
    }

    @SubscribeEvent
    public void onPlayerAetherLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            PlayerAether playerAether = PlayerAether.get(event.player);
            AetherNetwork.sendTo(new PacketAccessory(playerAether), (EntityPlayerMP)event.player);
            playerAether.updateShardCount(playerAether.getShardsUsed());
        }
    }

    @SubscribeEvent
    public void onPlayerAetherClone(PlayerEvent.Clone event) {
        PlayerAether original = PlayerAether.get(event.original);
        PlayerAether playerAether = PlayerAether.get(event.entityPlayer);
        playerAether.updateShardCount(original.getShardsUsed());
        if (!event.wasDeath || event.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            playerAether.setAccessoryInventory(original.getAccessoryInventory());
        }
    }

    @SubscribeEvent
    public void onPlayerAetherRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            PlayerAether playerAether = PlayerAether.get(event.player);
            AetherNetwork.sendTo(new PacketAccessory(playerAether), (EntityPlayerMP)event.player);
            playerAether.updateShardCount(playerAether.getShardsUsed());
        }
    }

    @SubscribeEvent
    public void onPlayerAetherChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            PlayerAether playerAether = PlayerAether.get(event.player);
            AetherNetwork.sendTo(new PacketAccessory(playerAether), (EntityPlayerMP)event.player);
            playerAether.updateShardCount(playerAether.getShardsUsed());
        }
    }

    @SubscribeEvent
    public void onPlayerAetherDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer && !event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            PlayerAether.get((EntityPlayer)event.entityLiving).getAccessoryInventory().dropAccessories();
        }
    }

    @SubscribeEvent
    public void onPlayerAetherUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            PlayerAether.get((EntityPlayer)event.entityLiving).onUpdate();
        } else if (event.entityLiving instanceof EntityLivingBase) {
            ((EntityHook)event.entityLiving.getExtendedProperties("aether_legacy:entity_hook")).onUpdate();
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        PlayerAether playerAether;
        if (event.entityLiving instanceof EntityPlayer && (playerAether = PlayerAether.get((EntityPlayer)event.entityLiving)).getAccessoryInventory().isWearingObsidianSet()) {
            float original = event.ammount;
            event.ammount = original / 2.0f;
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            PlayerAether playerAether = PlayerAether.get((EntityPlayer)event.entityLiving);
            if (playerAether.getAccessoryInventory().isWearingPhoenixSet() && event.source.func_76347_k()) {
                event.setCanceled(true);
            } else if (playerAether.getAbilities().get(3).shouldExecute()) {
                event.setCanceled(((AbilityRepulsion)playerAether.getAbilities().get(3)).onPlayerAttacked(event.source));
            }
        }
    }

    @SubscribeEvent
    public void onUpdateBreakSpeed(PlayerEvent.BreakSpeed event) {
        ((InventoryAccessories)PlayerAether.get(event.entityPlayer).getAccessoryInventory()).getCurrentPlayerStrVsBlock(event.newSpeed);
    }

    @SubscribeEvent
    public void onAchievementGet(AchievementEvent event) {
        int achievementType;
        Achievement achievement = event.achievement;
        EntityPlayer player = event.entityPlayer;
        if (!(achievement instanceof AetherAchievement)) {
            return;
        }
        int n = achievement == AchievementsAether.defeat_bronze ? 1 : (achievementType = achievement == AchievementsAether.defeat_silver ? 2 : 0);
        if (!player.field_70170_p.field_72995_K && ((EntityPlayerMP)player).func_147099_x().func_77442_b(achievement) && !((EntityPlayerMP)player).func_147099_x().func_77443_a(achievement)) {
            if (event.achievement == AchievementsAether.enter_aether) {
                if (!player.field_71071_by.func_70441_a(new ItemStack(ItemsAether.lore_book))) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(ItemsAether.lore_book)));
                }
                if (!player.field_71071_by.func_70441_a(new ItemStack(ItemsAether.golden_parachute))) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(ItemsAether.golden_parachute)));
                }
            }
            AetherNetwork.sendTo(new PacketAchievement(achievementType), (EntityPlayerMP)player);
        }
    }
}

