/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.player.abilities;

import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.api.player.util.IAetherAbility;
import com.legacy.aether.entities.projectile.EntityProjectileBase;
import com.legacy.aether.items.ItemsAether;
import cpw.mods.fml.common.registry.IThrowableEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;

public class AbilityRepulsion
implements IAetherAbility {
    private Random rand = new Random();
    private final IPlayerAether player;

    public AbilityRepulsion(IPlayerAether player) {
        this.player = player;
    }

    @Override
    public boolean shouldExecute() {
        return this.player.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.repulsion_shield));
    }

    @Override
    public void onUpdate() {
        if (this.player.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        List entities = this.player.getEntity().field_70170_p.func_72839_b((Entity)this.player.getEntity(), this.player.getEntity().field_70121_D.func_72314_b(3.0, 3.0, 3.0));
        for (int size = 0; size < entities.size(); ++size) {
            Entity projectile = (Entity)entities.get(size);
            if (!AbilityRepulsion.isProjectile(projectile) || this.getShooter(projectile) == this.player.getEntity()) continue;
            Entity shooter = this.getShooter(projectile);
            double x = this.player.getEntity().field_70165_t - shooter.field_70165_t;
            double y = this.player.getEntity().field_70121_D.field_72338_b - shooter.field_70121_D.field_72338_b;
            double z = this.player.getEntity().field_70161_v - shooter.field_70161_v;
            double difference = -Math.sqrt(x * x + y * y + z * z);
            x /= difference;
            y /= difference;
            z /= difference;
            projectile.func_70106_y();
            double packX = -projectile.field_70159_w * (double)0.15f + (double)((this.rand.nextFloat() - 0.5f) * 0.05f);
            double packY = -projectile.field_70181_x * (double)0.15f + (double)((this.rand.nextFloat() - 0.5f) * 0.05f);
            double packZ = -projectile.field_70179_y * (double)0.15f + (double)((this.rand.nextFloat() - 0.5f) * 0.05f);
            ((WorldServer)this.player.getEntity().field_70170_p).func_147487_a("flame", projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v, 12, packX, packY, packZ, 0.625);
            this.player.getEntity().field_70170_p.func_72956_a((Entity)this.player.getEntity(), "note.snare", 1.0f, 1.0f);
            this.player.getAccessoryInventory().damageWornStack(1, new ItemStack(ItemsAether.repulsion_shield));
        }
    }

    public boolean onPlayerAttacked(DamageSource source) {
        return AbilityRepulsion.isProjectile(source.func_76346_g());
    }

    private Entity getShooter(Entity ent) {
        return ent instanceof EntityArrow ? ((EntityArrow)ent).field_70250_c : (ent instanceof EntityThrowable ? ((EntityThrowable)ent).func_85052_h() : (ent instanceof EntityProjectileBase ? ((EntityProjectileBase)ent).getThrower() : (ent instanceof EntityFireball ? ((EntityFireball)ent).field_70235_a : null)));
    }

    public static boolean isProjectile(Entity entity) {
        return entity instanceof IProjectile || entity instanceof IThrowableEntity;
    }
}

