/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.tileentity;

import com.legacy.aether.api.events.AetherHooks;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.container.BlockAetherContainer;
import com.legacy.aether.entities.passive.mountable.EntityMoa;
import com.legacy.aether.items.ItemMoaEgg;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.registry.achievements.AchievementsAether;
import com.legacy.aether.tileentity.util.AetherTileEntity;
import com.legacy.aether.util.FilledList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;

public class TileEntityIncubator
extends AetherTileEntity {
    public EntityPlayer owner;
    public int progress;
    public int powerRemaining;
    public int ticksRequired = 5700;
    private final FilledList<ItemStack> incubatorItemStacks = new FilledList<Object>(3, null);

    public TileEntityIncubator() {
        super("Incubator");
    }

    @Override
    public List<ItemStack> getTileInventory() {
        return this.incubatorItemStacks;
    }

    @Override
    public void onSlotChanged(int index) {
        if (index == 1) {
            this.progress = 0;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.progress = compound.func_74762_e("progress");
        this.powerRemaining = compound.func_74762_e("powerRemaining");
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("powerRemaining", this.powerRemaining);
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.ticksRequired;
    }

    public int getPowerTimeRemainingScaled(int i) {
        return this.powerRemaining * i / 500;
    }

    public boolean isIncubating() {
        return this.powerRemaining > 0;
    }

    public void func_145845_h() {
        boolean flag = this.isIncubating();
        if (this.powerRemaining > 0) {
            --this.powerRemaining;
            if (this.func_70301_a(1) != null) {
                ++this.progress;
            }
        }
        if (this.progress >= this.ticksRequired) {
            if (this.func_70301_a(1).func_77973_b() instanceof ItemMoaEgg) {
                ItemMoaEgg moaEgg = (ItemMoaEgg)this.func_70301_a(1).func_77973_b();
                if (this.owner != null) {
                    this.owner.func_71029_a((StatBase)AchievementsAether.incubator);
                }
                if (!this.field_145850_b.field_72995_K) {
                    EntityMoa moa = new EntityMoa(this.field_145850_b);
                    moa.setPlayerGrown(true);
                    moa.func_70873_a(-24000);
                    moa.setMoaType(moaEgg.getMoaTypeFromItemStack(this.func_70301_a(1)));
                    int safeY = 0;
                    while (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + safeY, this.field_145849_e)) {
                        moa.func_70634_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + safeY) + 1.5, (double)this.field_145849_e + 0.5);
                        ++safeY;
                    }
                    this.field_145850_b.func_72838_d((Entity)moa);
                }
                AetherHooks.onMoaHatched(moaEgg.getMoaTypeFromItemStack(this.func_70301_a(1)), this);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_70298_a(1, 1);
            }
            this.progress = 0;
        }
        if (this.powerRemaining <= 0) {
            if (this.func_70301_a(0) != null && this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() == ItemsAether.moa_egg && this.func_70301_a(0).func_77973_b() == Item.func_150898_a((Block)BlocksAether.ambrosium_torch)) {
                this.powerRemaining += 1000;
                if (!this.field_145850_b.field_72995_K) {
                    this.func_70298_a(0, 1);
                }
            } else {
                this.powerRemaining = 0;
                this.progress = 0;
            }
        }
        if (flag != this.isIncubating()) {
            this.func_70296_d();
            BlockAetherContainer.setState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isIncubating());
        }
    }

    @Override
    public boolean isValidSlotItem(int index, ItemStack itemstack) {
        return index == 0 && itemstack.func_77973_b() == Item.func_150898_a((Block)BlocksAether.ambrosium_torch) ? true : index == 1 && itemstack.func_77973_b() == ItemsAether.moa_egg;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        }
        return nArray;
    }
}

