/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.world;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.world.dungeon.BronzeDungeon;
import com.legacy.aether.world.dungeon.util.AetherDungeon;
import com.legacy.aether.world.gen.MapGenGoldenDungeon;
import com.legacy.aether.world.gen.MapGenLargeColdAercloud;
import com.legacy.aether.world.gen.MapGenQuicksoil;
import com.legacy.aether.world.gen.MapGenSilverDungeon;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class ChunkProviderAether
implements IChunkProvider {
    private Random rand;
    private World worldObj;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves perlinNoise1;
    private double[] buffer;
    double[] pnr;
    double[] ar;
    double[] br;
    protected AetherDungeon dungeon_bronze = new BronzeDungeon();
    private MapGenQuicksoil quicksoilGen = new MapGenQuicksoil();
    private MapGenSilverDungeon silverDungeonStructure = new MapGenSilverDungeon();
    private MapGenGoldenDungeon goldenDungeonStructure = new MapGenGoldenDungeon();
    private MapGenLargeColdAercloud largeColdAercloudStructure = new MapGenLargeColdAercloud();

    public ChunkProviderAether(World world, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void setBlocksInChunk(int x, int z, Block[] blocks) {
        this.buffer = this.setupNoiseGenerators(this.buffer, x * 2, z * 2);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d1 = this.buffer[(i1 * 3 + j1) * 33 + k1];
                    double d2 = this.buffer[(i1 * 3 + (j1 + 1)) * 33 + k1];
                    double d3 = this.buffer[((i1 + 1) * 3 + j1) * 33 + k1];
                    double d4 = this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + k1];
                    double d5 = (this.buffer[(i1 * 3 + j1) * 33 + (k1 + 1)] - d1) * 0.25;
                    double d6 = (this.buffer[(i1 * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d2) * 0.25;
                    double d7 = (this.buffer[((i1 + 1) * 3 + j1) * 33 + (k1 + 1)] - d3) * 0.25;
                    double d8 = (this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            int j2 = i2 + i1 * 8 << 11 | 0 + j1 * 8 << 7 | k1 * 4 + l1;
                            int c = 128;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                Block filler = Blocks.field_150350_a;
                                if (d15 > 0.0) {
                                    filler = BlocksAether.holystone;
                                }
                                blocks[j2] = filler;
                                j2 += c;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int i, int j, Block[] blocks) {
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int j1 = -1;
                int i1 = (int)(3.0 + this.rand.nextDouble() * 0.25);
                Block top = BlocksAether.aether_grass;
                Block filler = BlocksAether.aether_dirt;
                for (int k1 = 127; k1 >= 0; --k1) {
                    int l1 = (l * 16 + k) * 128 + k1;
                    Block block = blocks[l1];
                    if (block == Blocks.field_150350_a) {
                        j1 = -1;
                        continue;
                    }
                    if (block != BlocksAether.holystone) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            top = Blocks.field_150350_a;
                            filler = BlocksAether.holystone;
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            blocks[l1] = top;
                            continue;
                        }
                        blocks[l1] = filler;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    blocks[l1] = filler;
                }
            }
        }
    }

    private double[] setupNoiseGenerators(double[] buffer, int x, int z) {
        if (buffer == null) {
            buffer = new double[3366];
        }
        double d = 1368.824;
        double d1 = 684.412;
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, x, 0, z, 3, 33, 3, d / 80.0, d1 / 160.0, d / 80.0);
        this.ar = this.noiseGen1.func_76304_a(this.ar, x, 0, z, 3, 33, 3, d, d1, d);
        this.br = this.noiseGen1.func_76304_a(this.br, x, 0, z, 3, 33, 3, d, d1, d);
        int id = 0;
        for (int j2 = 0; j2 < 3; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                for (int j3 = 0; j3 < 33; ++j3) {
                    double d10 = this.ar[id] / 512.0;
                    double d11 = this.br[id] / 512.0;
                    double d12 = (this.pnr[id] / 10.0 + 1.0) / 2.0;
                    double d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    if (j3 > 1) {
                        double d13 = (float)(j3 - 1) / 31.0f;
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < 8) {
                        double d14 = (float)(8 - j3) / 7.0f;
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    buffer[id] = d8;
                    ++id;
                }
            }
        }
        return buffer;
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] ablock = new Block[32768];
        this.setBlocksInChunk(x, z, ablock);
        this.buildSurfaces(x, z, ablock);
        this.quicksoilGen.func_151539_a(this, this.worldObj, x, z, ablock);
        this.largeColdAercloudStructure.func_151539_a(this, this.worldObj, x, z, ablock);
        this.silverDungeonStructure.func_151539_a(this, this.worldObj, x, z, ablock);
        this.goldenDungeonStructure.func_151539_a(this, this.worldObj, x, z, ablock);
        Chunk chunk = new Chunk(this.worldObj, ablock, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    public List func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        return this.worldObj.func_72807_a(x, z).func_76747_a(creatureType);
    }

    public void func_82695_e(int x, int z) {
        this.largeColdAercloudStructure.func_151539_a(this, this.worldObj, x, z, null);
        this.silverDungeonStructure.func_151539_a(this, this.worldObj, x, z, null);
        this.goldenDungeonStructure.func_151539_a(this, this.worldObj, x, z, null);
    }

    public ChunkPosition func_147416_a(World worldIn, String structureName, int x, int y, int z) {
        return null;
    }

    public void func_73153_a(IChunkProvider provider, int chunkX, int chunkZ) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BiomeGenBase biome = this.worldObj.func_72807_a(x + 16, z + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.worldObj.func_72905_C());
        this.largeColdAercloudStructure.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        this.silverDungeonStructure.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        this.goldenDungeonStructure.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        biome.func_76728_a(this.worldObj, this.rand, x, z);
        if (this.rand.nextInt(10) == 0) {
            this.dungeon_bronze.func_76484_a(this.worldObj, this.rand, x + this.rand.nextInt(16), this.rand.nextInt(64) + 32, z + this.rand.nextInt(16));
        }
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
    }

    public Chunk func_73158_c(int chunkX, int chunkZ) {
        return this.func_73154_d(chunkX, chunkZ);
    }

    public boolean func_73149_a(int chunkX, int chunkZ) {
        return true;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public boolean func_73156_b() {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "AetherRandomLevelSource";
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }
}

