/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeIngameGui;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ExtraHeartRenderHandler {
    private static final ResourceLocation ICON_HEARTS = new ResourceLocation("mantle", "textures/gui/hearts.png");
    private static final ResourceLocation ICON_ABSORB = new ResourceLocation("mantle", "textures/gui/absorb.png");
    private static final ResourceLocation ICON_VANILLA = AbstractGui.GUI_ICONS_LOCATION;
    private final Minecraft mc = Minecraft.func_71410_x();
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private long healthUpdateCounter = 0L;
    private long lastSystemTime = 0L;
    private Random rand = new Random();
    private int height;
    private int width;
    private int regen;
    private static int left_height = 39;

    public void blit(int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.blit(x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderHealthbar(RenderGameOverlayEvent.Pre event) {
        boolean highlight;
        Entity renderViewEnity = this.mc.func_175606_aa();
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || event.isCanceled() || !(renderViewEnity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)this.mc.func_175606_aa();
        left_height = ForgeIngameGui.left_height;
        this.width = this.mc.field_195558_d.func_198107_o();
        this.height = this.mc.field_195558_d.func_198087_p();
        event.setCanceled(true);
        int updateCounter = this.mc.field_71456_v.func_73834_c();
        this.mc.func_213239_aq().func_76320_a("health");
        GlStateManager.enableBlend();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Util.func_211177_b();
            this.healthUpdateCounter = updateCounter + 20;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Util.func_211177_b();
            this.healthUpdateCounter = updateCounter + 10;
        }
        if (Util.func_211177_b() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Util.func_211177_b();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        healthMax = Math.min(healthMax, 20.0f);
        health = Math.min(health, 20);
        absorb = Math.min(absorb, 20.0f);
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(updateCounter * 312871);
        int left = this.width / 2 - 91;
        int top = this.height - left_height;
        left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            left_height += 10 - rowHeight;
        }
        this.regen = -1;
        if (player.func_70644_a(Effects.field_76428_l)) {
            this.regen = updateCounter % 25;
        }
        int TOP = 9 * (this.mc.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.func_70644_a(Effects.field_76436_u)) {
            MARGIN += 36;
        } else if (player.func_70644_a(Effects.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == this.regen) {
                y -= 2;
            }
            this.blit(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.blit(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.blit(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.blit(x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.blit(x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.blit(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.blit(x, y, MARGIN + 45, TOP, 9, 9);
        }
        this.renderExtraHearts(left, top, player);
        this.renderExtraAbsorption(left, top - rowHeight, player);
        this.mc.func_110434_K().func_110577_a(ICON_VANILLA);
        ForgeIngameGui.left_height += 10;
        if (absorb > 0.0f) {
            ForgeIngameGui.left_height += 10;
        }
        event.setCanceled(true);
        GlStateManager.disableBlend();
        this.mc.func_213239_aq().func_76319_b();
    }

    private void renderExtraHearts(int xBasePos, int yBasePos, PlayerEntity player) {
        int potionOffset = this.getPotionOffset(player);
        this.mc.func_110434_K().func_110577_a(ICON_HEARTS);
        int hp = MathHelper.func_76123_f((float)player.func_110143_aJ());
        this.renderCustomHearts(xBasePos, yBasePos, potionOffset, hp, false);
    }

    private void renderCustomHearts(int xBasePos, int yBasePos, int potionOffset, int count, boolean absorb) {
        int regenOffset = absorb ? 10 : 0;
        for (int iter = 0; iter < count / 20; ++iter) {
            int renderHearts = (count - 20 * (iter + 1)) / 2;
            int heartIndex = iter % 11;
            if (renderHearts > 10) {
                renderHearts = 10;
            }
            for (int i = 0; i < renderHearts; ++i) {
                int y = this.getYRegenOffset(i, regenOffset);
                if (absorb) {
                    this.blit(xBasePos + 8 * i, yBasePos + y, 0, 54, 9, 9);
                }
                this.blit(xBasePos + 8 * i, yBasePos + y, 18 * heartIndex, potionOffset, 9, 9);
            }
            if (count % 2 != 1 || renderHearts >= 10) continue;
            int y = this.getYRegenOffset(renderHearts, regenOffset);
            if (absorb) {
                this.blit(xBasePos + 8 * renderHearts, yBasePos + y, 0, 54, 9, 9);
            }
            this.blit(xBasePos + 8 * renderHearts, yBasePos + y, 9 + 18 * heartIndex, potionOffset, 9, 9);
        }
    }

    private int getYRegenOffset(int i, int offset) {
        return i + offset == this.regen ? -2 : 0;
    }

    private int getPotionOffset(PlayerEntity player) {
        int potionOffset = 0;
        EffectInstance potion = player.func_70660_b(Effects.field_82731_v);
        if (potion != null) {
            potionOffset = 18;
        }
        if ((potion = player.func_70660_b(Effects.field_76436_u)) != null) {
            potionOffset = 9;
        }
        if (this.mc.field_71441_e.func_72912_H().func_76093_s()) {
            potionOffset += 27;
        }
        return potionOffset;
    }

    private void renderExtraAbsorption(int xBasePos, int yBasePos, PlayerEntity player) {
        int potionOffset = this.getPotionOffset(player);
        this.mc.func_110434_K().func_110577_a(ICON_ABSORB);
        int absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        this.renderCustomHearts(xBasePos, yBasePos, potionOffset, absorb, true);
    }
}

