/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.screen.book.element.ElementItem;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

@OnlyIn(value=Dist.CLIENT)
public class ElementImage
extends SizedBookElement {
    public ImageData image;
    public int colorMultiplier;
    private ElementItem itemElement;

    public ElementImage(ImageData image) {
        this(image, 0xFFFFFF);
    }

    public ElementImage(ImageData image, int colorMultiplier) {
        this(image.x, image.y, image.width, image.height, image, colorMultiplier);
    }

    public ElementImage(int x, int y, int width, int height, ImageData image) {
        this(x, y, width, height, image, image.colorMultiplier);
    }

    public ElementImage(int x, int y, int width, int height, ImageData image, int colorMultiplier) {
        super(x, y, width, height);
        this.image = image;
        if (image.x != -1) {
            x = image.x;
        }
        if (image.y != -1) {
            y = image.y;
        }
        if (image.width != -1) {
            width = image.width;
        }
        if (image.height != -1) {
            height = image.height;
        }
        if (image.colorMultiplier != 0xFFFFFF) {
            colorMultiplier = image.colorMultiplier;
        }
        this.x = x == -1 ? 0 : x;
        this.y = y == -1 ? 0 : y;
        this.width = width;
        this.height = height;
        this.colorMultiplier = colorMultiplier;
        if (image.item != null) {
            this.itemElement = new ElementItem(0, 0, 1.0f, (Collection<ItemStack>)image.item.getItems());
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        float r = (float)(this.colorMultiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.colorMultiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.colorMultiplier & 0xFF) / 255.0f;
        GlStateManager.color3f((float)r, (float)g, (float)b);
        if (this.image.item == null) {
            this.renderEngine.func_110577_a(this.image.location);
            ElementImage.blitRaw(this.x, this.y, this.width, this.height, this.image.u, this.image.u + this.image.uw, this.image.v, this.image.v + this.image.vh, this.image.texWidth, this.image.texHeight);
        } else {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)this.x, (float)this.y, (float)0.0f);
            GlStateManager.scalef((float)((float)this.width / 16.0f), (float)((float)this.height / 16.0f), (float)1.0f);
            this.itemElement.draw(mouseX, mouseY, partialTicks, fontRenderer);
            RenderHelper.func_74518_a();
            GlStateManager.popMatrix();
        }
    }

    public static void blitRaw(int x, int y, int w, int h, int minU, int maxU, int minV, int maxV, float tw, float th) {
        ElementImage.innerBlit((int)x, (int)(x + w), (int)y, (int)(y + h), (int)0, (float)((float)minU / tw), (float)((float)maxU / tw), (float)((float)minV / th), (float)((float)maxV / th));
    }
}

