/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.common.IGeneratedJson;

public class BlockStateJsonGenerator
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String modId;

    public BlockStateJsonGenerator(DataGenerator generatorIn, String modId) {
        this.generator = generatorIn;
        this.modId = modId;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        JsonObject blockState = new JsonObject();
        int generatedEntries = 0;
        JsonObject blockstateCache = new JsonObject();
        Path cacheP = this.generator.func_200391_b().resolve("cache/" + this.modId + "/blockstates/blockstates.json");
        if (Files.exists(cacheP, new LinkOption[0])) {
            String jsonTxt = IOUtils.toString((URI)cacheP.toUri(), (String)"UTF-8");
            blockstateCache = new JsonParser().parse(jsonTxt).getAsJsonObject();
        }
        for (Block block : Registry.field_212618_g) {
            blockState = new JsonObject();
            ResourceLocation resourcelocation = Registry.field_212618_g.func_177774_c((Object)block);
            if (!resourcelocation.func_110624_b().equals(this.modId) || !(block instanceof IGeneratedJson) || blockstateCache.has(resourcelocation.toString())) continue;
            IGeneratedJson block1 = (IGeneratedJson)block;
            blockState.add("variants", (JsonElement)block1.getVariants());
            blockstateCache.addProperty(resourcelocation.toString(), "UNUSED");
            ++generatedEntries;
            Path path = this.generator.func_200391_b().resolve("assets/" + this.modId + "/blockstates/" + resourcelocation.func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)blockState, (Path)path);
        }
        if (generatedEntries != 0) {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)blockstateCache, (Path)cacheP);
        }
        cache.func_218456_c(cacheP);
    }

    public String func_200397_b() {
        return "Blockstate Generator";
    }
}

