/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.common.IGeneratedJson;

public class ModelJsonGenerator
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String modId;

    public ModelJsonGenerator(DataGenerator generatorIn, String modId) {
        this.generator = generatorIn;
        this.modId = modId;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path;
        JsonObject blockObject = new JsonObject();
        JsonObject itemObject = new JsonObject();
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        int generatedBlockEntries = 0;
        int generatedItemEntries = 0;
        JsonObject blockModelCache = new JsonObject();
        JsonObject itemModelCache = new JsonObject();
        Path blockCachePath = this.generator.func_200391_b().resolve("cache/" + this.modId + "/models/block/models.json");
        if (Files.exists(blockCachePath, new LinkOption[0])) {
            String jsonTxt = IOUtils.toString((URI)blockCachePath.toUri(), (String)"UTF-8");
            blockModelCache = new JsonParser().parse(jsonTxt).getAsJsonObject();
        }
        for (Block block : Registry.field_212618_g) {
            blockObject = new JsonObject();
            ResourceLocation resourcelocation = Registry.field_212618_g.func_177774_c((Object)block);
            if (!resourcelocation.func_110624_b().equals(this.modId) || !(block instanceof IGeneratedJson) || blockModelCache.has(resourcelocation.toString())) continue;
            IGeneratedJson block1 = (IGeneratedJson)block;
            resourceLocations.add(resourcelocation);
            blockObject.addProperty("parent", block1.getParentToUse());
            blockObject.add("textures", (JsonElement)block1.getTexturesToUse());
            blockModelCache.addProperty(resourcelocation.toString(), "UNUSED");
            ++generatedBlockEntries;
            path = this.generator.func_200391_b().resolve("assets/" + this.modId + "/models/block/" + resourcelocation.func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)blockObject, (Path)path);
        }
        Path itemCachePath = this.generator.func_200391_b().resolve("cache/" + this.modId + "/models/item/models.json");
        if (Files.exists(itemCachePath, new LinkOption[0])) {
            String jsonTxt = IOUtils.toString((URI)itemCachePath.toUri(), (String)"UTF-8");
            itemModelCache = new JsonParser().parse(jsonTxt).getAsJsonObject();
        }
        for (Item item : Registry.field_212630_s) {
            itemObject = new JsonObject();
            ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)item);
            if (!resourcelocation.func_110624_b().equals(this.modId) || itemModelCache.has(resourcelocation.toString())) continue;
            if (resourceLocations.contains(resourcelocation)) {
                itemObject.addProperty("parent", resourcelocation.func_110624_b() + ":block/" + resourcelocation.func_110623_a());
                itemModelCache.addProperty(resourcelocation.toString(), "UNUSED");
                ++generatedItemEntries;
                path = this.generator.func_200391_b().resolve("assets/" + this.modId + "/models/item/" + resourcelocation.func_110623_a() + ".json");
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)itemObject, (Path)path);
                continue;
            }
            if (!(item instanceof IGeneratedJson)) continue;
            IGeneratedJson item1 = (IGeneratedJson)item;
            itemObject.addProperty("parent", item1.getParentToUse());
            itemObject.add("textures", (JsonElement)item1.getTexturesToUse());
            itemModelCache.addProperty(resourcelocation.toString(), "UNUSED");
            ++generatedItemEntries;
            Path path2 = this.generator.func_200391_b().resolve("assets/" + this.modId + "/models/item/" + resourcelocation.func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)itemObject, (Path)path2);
        }
        if (generatedBlockEntries != 0) {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)blockModelCache, (Path)blockCachePath);
        }
        if (generatedItemEntries != 0) {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)itemModelCache, (Path)itemCachePath);
        }
        cache.func_218456_c(blockCachePath);
        cache.func_218456_c(itemCachePath);
    }

    public String func_200397_b() {
        return "Model Generator";
    }
}

