/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.pulsar.control;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import slimeknights.mantle.pulsar.config.IConfiguration;
import slimeknights.mantle.pulsar.flightpath.Flightpath;
import slimeknights.mantle.pulsar.flightpath.IExceptionHandler;
import slimeknights.mantle.pulsar.flightpath.lib.AnnotationLocator;
import slimeknights.mantle.pulsar.internal.BusExceptionHandler;
import slimeknights.mantle.pulsar.internal.Configuration;
import slimeknights.mantle.pulsar.internal.CrashHandler;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.pulsar.pulse.PulseMeta;

@ParametersAreNonnullByDefault
public class PulseManager {
    private Logger log;
    private final boolean useConfig;
    private static final Map<String, Map<Object, PulseMeta>> ALL_PULSES = new HashMap<String, Map<Object, PulseMeta>>();
    private final Map<Object, PulseMeta> pulses = new LinkedHashMap<Object, PulseMeta>();
    private final Map<Object, PulseMeta> allPulses = new LinkedHashMap<Object, PulseMeta>();
    private final Flightpath flightpath = new Flightpath(new AnnotationLocator(SubscribeEvent.class));
    private boolean blockNewRegistrations = false;
    private boolean configLoaded = false;
    private IConfiguration conf;
    private String id;
    public static final Marker PULSAR = MarkerManager.getMarker((String)"PULSAR");

    public PulseManager(String configName) {
        this.init();
        this.useConfig = true;
        this.conf = new Configuration(configName, this.log);
    }

    public PulseManager(IConfiguration config) {
        this.init();
        this.useConfig = true;
        this.conf = config;
    }

    private void init() {
        String modId;
        this.id = modId = ModLoadingContext.get().getActiveContainer().getNamespace();
        this.log = LogManager.getLogger((String)("Pulsar-" + modId));
        this.flightpath.setExceptionHandler(new BusExceptionHandler(modId));
        CrashReportExtender.registerCrashCallable((ICrashCallable)new CrashHandler(modId, this));
        ALL_PULSES.put(modId, this.pulses);
        this.attachToContainerEventBus(this);
    }

    public void setPulseExceptionHandler(IExceptionHandler handler) {
        this.flightpath.setExceptionHandler(handler);
    }

    public void registerPulse(Object pulse) {
        boolean defaultEnabled;
        boolean enabled;
        boolean forced;
        String pulseDeps;
        String deps;
        String description;
        String id;
        if (this.blockNewRegistrations) {
            throw new RuntimeException("A mod tried to register a plugin after preinit! Pulse: " + pulse);
        }
        if (!this.configLoaded) {
            this.conf.load();
            this.configLoaded = true;
        }
        boolean missingDeps = false;
        try {
            Pulse p = pulse.getClass().getAnnotation(Pulse.class);
            id = p.id();
            description = p.description();
            deps = p.modsRequired();
            pulseDeps = p.pulsesRequired();
            forced = p.forced();
            enabled = p.defaultEnable();
            defaultEnabled = p.defaultEnable();
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("Could not parse @Pulse annotation for Pulse: " + pulse);
        }
        if (description.equals("")) {
            description = null;
        }
        if (!deps.equals("")) {
            String[] parsedDeps;
            for (String s : parsedDeps = deps.split(";")) {
                if (ModList.get().isLoaded(s)) continue;
                this.log.info(PULSAR, "Skipping Pulse " + id + "; missing dependency: " + s);
                missingDeps = true;
                enabled = false;
                break;
            }
        }
        PulseMeta meta = new PulseMeta(id, description, forced, enabled, defaultEnabled);
        meta.setMissingDeps(missingDeps || !this.hasRequiredPulses(meta, pulseDeps));
        if (meta.isForced() || !this.useConfig) {
            this.allPulses.put(pulse, meta);
        } else {
            this.conf.addPulse(meta);
            this.allPulses.put(pulse, meta);
        }
    }

    private void attachToContainerEventBus(Object obj) {
        ModContainer cnt = ModLoadingContext.get().getActiveContainer();
        this.log.debug(PULSAR, "Attaching [" + obj + "] to event bus for container [" + cnt + "]");
        try {
            FMLModContainer mc = (FMLModContainer)cnt;
            Field ebf = mc.getClass().getDeclaredField("eventBus");
            boolean access = ebf.isAccessible();
            ebf.setAccessible(true);
            EventBus eb = (EventBus)ebf.get(mc);
            ebf.setAccessible(access);
            eb.register(obj);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException("Pulsar >> Incompatible FML mod container (missing eventBus field) - wrong Forge version?");
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Pulsar >> Security Manager blocked access to eventBus on mod container. Cannot continue.");
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Pulsar >> Something in the mod container had the wrong type? " + cce.getMessage());
        }
    }

    @SubscribeEvent
    public void propagateEvent(Event evt) {
        if (evt instanceof FMLCommonSetupEvent) {
            this.preInit((FMLCommonSetupEvent)evt);
        }
        this.flightpath.post(evt);
    }

    private boolean getEnabledFromConfig(PulseMeta meta) {
        if (meta.isForced() || !this.useConfig) {
            return true;
        }
        return this.conf.isModuleEnabled(meta);
    }

    private void preInit(FMLCommonSetupEvent evt) {
        if (!this.blockNewRegistrations) {
            this.conf.flush();
        }
        this.blockNewRegistrations = true;
    }

    private boolean hasRequiredPulses(PulseMeta meta, String deps) {
        if (!deps.equals("")) {
            String[] parsedDeps;
            for (String s : parsedDeps = deps.split(";")) {
                if (this.isPulseLoaded(s)) continue;
                this.log.info(PULSAR, "Skipping Pulse " + meta.getId() + "; missing pulse: " + s);
                return false;
            }
        }
        return true;
    }

    public boolean isPulseLoaded(String pulseId) {
        if (pulseId.contains(":")) {
            return PulseManager.isPulseLoadedGlobal(pulseId);
        }
        return PulseManager.isPulseLoaded(this.pulses, pulseId);
    }

    public static boolean isPulseLoadedGlobal(String pulseId) {
        ResourceLocation loc = new ResourceLocation(pulseId);
        Map<Object, PulseMeta> pulses = ALL_PULSES.get(loc.func_110624_b());
        if (pulses != null) {
            return PulseManager.isPulseLoaded(pulses, loc.func_110623_a());
        }
        return false;
    }

    private static boolean isPulseLoaded(Map<Object, PulseMeta> pulses, String pulseId) {
        for (Map.Entry<Object, PulseMeta> entry : pulses.entrySet()) {
            if (!entry.getValue().getId().equalsIgnoreCase(pulseId)) continue;
            return true;
        }
        return false;
    }

    public Collection<PulseMeta> getAllPulseMetadata() {
        return this.pulses.values();
    }

    public String toString() {
        return "PulseManager[" + this.id + "]";
    }

    public void enablePulses() {
        if (this.blockNewRegistrations) {
            throw new RuntimeException("A mod tried to enable their plugins after preinit!");
        }
        if (this.configLoaded) {
            this.conf.postLoad();
        }
        for (Map.Entry<Object, PulseMeta> entry : this.allPulses.entrySet()) {
            PulseMeta meta = entry.getValue();
            Object pulse = entry.getKey();
            meta.setEnabled(this.getEnabledFromConfig(meta));
            if (!meta.isEnabled()) continue;
            this.pulses.put(pulse, meta);
            this.flightpath.register(pulse);
        }
    }
}

