/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class SelectionElement
extends SizedBookElement {
    public static final int IMG_SIZE = 32;
    public static final int WIDTH = 42;
    public static final int HEIGHT = 42;
    private SectionData section;
    private ImageElement iconRenderer;
    private final int iconX;
    private final int iconY;

    public SelectionElement(int x, int y, SectionData section) {
        super(x, y, 42, 42);
        this.section = section;
        this.iconX = this.x + 21 - 16;
        this.iconY = this.y + 21 - 16;
        this.iconRenderer = new ImageElement(this.iconX, this.iconY, 32, 32, section.icon);
    }

    @Override
    public void draw(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        boolean unlocked = this.section.isUnlocked(this.parent.advancementCache);
        boolean hover = this.isHovered(mouseX, mouseY);
        if (hover) {
            SelectionElement.func_238467_a_((MatrixStack)matrixStack, (int)this.iconX, (int)this.iconY, (int)(this.iconX + 32), (int)(this.iconY + 32), (int)this.parent.book.appearance.hoverColor);
        }
        if (unlocked) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(hover ? 1.0f : 0.5f));
        } else {
            float r = (float)(this.parent.book.appearance.lockedSectionColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.parent.book.appearance.lockedSectionColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.parent.book.appearance.lockedSectionColor & 0xFF) / 255.0f;
            RenderSystem.color4f((float)r, (float)g, (float)b, (float)0.75f);
        }
        this.iconRenderer.draw(matrixStack, mouseX, mouseY, partialTicks, fontRenderer);
        if (this.section.parent.appearance.drawSectionListText) {
            int textW = fontRenderer.func_78256_a(this.section.getTitle());
            int textX = this.x + 21 - textW / 2;
            fontRenderer.getClass();
            int textY = this.y + 42 - 9 / 2;
            fontRenderer.func_238421_b_(matrixStack, this.section.getTitle(), (float)textX, (float)textY, hover ? -16777216 : 0x7F000000);
        }
    }

    @Override
    public void drawOverlay(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        if (this.section != null && this.isHovered(mouseX, mouseY)) {
            ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
            text.add((ITextComponent)new StringTextComponent(this.section.getTitle()));
            if (!this.section.isUnlocked(this.parent.advancementCache)) {
                text.add((ITextComponent)new StringTextComponent("Locked").func_240699_a_(TextFormatting.RED));
                text.add((ITextComponent)new StringTextComponent("Requirements:"));
                for (String requirement : this.section.requirements) {
                    text.add((ITextComponent)new StringTextComponent(requirement));
                }
            }
            this.drawHoveringText(matrixStack, text, mouseX, mouseY, fontRenderer);
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.section != null && this.section.isUnlocked(this.parent.advancementCache) && this.isHovered(mouseX, mouseY)) {
            this.parent.openPage(this.parent.book.getFirstPageNumber(this.section, this.parent.advancementCache));
        }
    }
}

