/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.util.RetexturedHelper;

public class RetexturedBlockItem
extends BlockTooltipItem {
    protected final ITag<Item> textureTag;

    public RetexturedBlockItem(Block block, ITag<Item> textureTag, Item.Properties builder) {
        super(block, builder);
        this.textureTag = textureTag;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        RetexturedBlockItem.addTagVariants((IItemProvider)this.func_179223_d(), this.textureTag, items, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        RetexturedBlockItem.addTooltip(stack, tooltip);
    }

    public static String getTextureName(ItemStack stack) {
        return RetexturedHelper.getTextureName(stack.func_77978_p());
    }

    public static Block getTexture(ItemStack stack) {
        return RetexturedHelper.getBlock(RetexturedBlockItem.getTextureName(stack));
    }

    public static void addTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        Block block = RetexturedBlockItem.getTexture(stack);
        if (block != Blocks.field_150350_a) {
            tooltip.add((ITextComponent)block.func_235333_g_());
        }
    }

    public static ItemStack setTexture(ItemStack stack, String name) {
        if (!name.isEmpty()) {
            RetexturedHelper.setTexture(stack.func_196082_o(), name);
        } else if (stack.func_77942_o()) {
            RetexturedHelper.setTexture(stack.func_77978_p(), name);
        }
        return stack;
    }

    public static ItemStack setTexture(ItemStack stack, @Nullable Block block) {
        if (block == null || block == Blocks.field_150350_a) {
            return RetexturedBlockItem.setTexture(stack, "");
        }
        return RetexturedBlockItem.setTexture(stack, Objects.requireNonNull(block.getRegistryName()).toString());
    }

    public static void addTagVariants(IItemProvider block, ITag<Item> tag, NonNullList<ItemStack> list, boolean showAllVariants) {
        boolean added = false;
        Class<?> clazz = block.getClass();
        if (!ItemTags.func_199903_a().func_199908_a().isEmpty()) {
            for (Item candidate : tag.func_230236_b_()) {
                Block textureBlock;
                if (!(candidate instanceof BlockItem) || clazz.isInstance(textureBlock = ((BlockItem)candidate).func_179223_d())) continue;
                added = true;
                list.add((Object)RetexturedBlockItem.setTexture(new ItemStack(block), textureBlock));
                if (showAllVariants) continue;
                return;
            }
        }
        if (!added) {
            list.add((Object)new ItemStack(block));
        }
    }
}

