/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.IMultiRecipe;

public class RecipeHelper {
    public static <C extends IRecipe<?>> Optional<C> getRecipe(RecipeManager manager, ResourceLocation name, Class<C> clazz) {
        return manager.func_215367_a(name).filter(clazz::isInstance).map(clazz::cast);
    }

    public static <I extends IInventory, T extends IRecipe<I>, C extends T> List<C> getRecipes(RecipeManager manager, IRecipeType<T> type, Class<C> clazz) {
        return manager.func_215366_a(type).values().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <I extends IInventory, T extends IRecipe<I>, C extends T> List<C> getUIRecipes(RecipeManager manager, IRecipeType<T> type, Class<C> clazz, Predicate<? super C> filter) {
        return manager.func_215366_a(type).values().stream().filter(clazz::isInstance).map(clazz::cast).filter(filter).sorted(Comparator.comparing(IRecipe::func_199560_c)).collect(Collectors.toList());
    }

    public static <I extends IInventory, T extends IRecipe<I>, C extends T> List<C> getJEIRecipes(RecipeManager manager, IRecipeType<T> type, Class<C> clazz) {
        return manager.func_215366_a(type).values().stream().sorted((r1, r2) -> {
            boolean m1 = r1 instanceof IMultiRecipe;
            boolean m2 = r2 instanceof IMultiRecipe;
            if (m1 && !m2) {
                return 1;
            }
            if (!m1 && m2) {
                return -1;
            }
            return r1.func_199560_c().compareTo(r2.func_199560_c());
        }).flatMap(recipe -> {
            if (recipe instanceof IMultiRecipe) {
                return ((IMultiRecipe)recipe).getRecipes().stream();
            }
            return Stream.of(recipe);
        }).filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static JsonObject serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", Objects.requireNonNull(stack.getFluid().getRegistryName()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        return json;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        String fluidName = JSONUtils.func_151200_h((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null || fluid == Fluids.field_204541_a) {
            throw new JsonSyntaxException("Unknown fluid " + fluidName);
        }
        int amount = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
        return new FluidStack(fluid, amount);
    }

    public static <C> C deserializeItem(String name, String key, Class<C> clazz) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            throw new JsonSyntaxException("Invalid " + key + ": Unknown item " + name + "'");
        }
        if (!clazz.isInstance(item)) {
            throw new JsonSyntaxException("Invalid " + key + ": must be " + clazz.getSimpleName());
        }
        return clazz.cast(item);
    }

    public static Item readItem(PacketBuffer buffer) {
        return Item.func_150899_d((int)buffer.func_150792_a());
    }

    public static <T> T readItem(PacketBuffer buffer, Class<T> clazz) {
        Item item = RecipeHelper.readItem(buffer);
        if (!clazz.isInstance(item)) {
            throw new DecoderException("Invalid item '" + item.getRegistryName() + "', must be " + clazz.getSimpleName());
        }
        return clazz.cast(item);
    }

    public static void writeItem(PacketBuffer buffer, IItemProvider item) {
        buffer.func_150787_b(Item.func_150891_b((Item)item.func_199767_j()));
    }

    private RecipeHelper() {
    }
}

