/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;

public interface IRecipeBuilderUtils {
    public String getModId();

    public Consumer<IFinishedRecipe> getConsumer();

    @Nullable
    default public ICondition baseCondition() {
        return null;
    }

    default public ResourceLocation resource(String name) {
        return new ResourceLocation(this.getModId(), name);
    }

    default public String resourceName(String name) {
        return String.format("%s:%s", this.getModId(), name);
    }

    default public ResourceLocation prefix(IItemProvider item, String prefix) {
        return this.resource(prefix + Objects.requireNonNull(item.func_199767_j().getRegistryName()).func_110623_a());
    }

    default public ResourceLocation wrap(IItemProvider item, String prefix, String suffix) {
        return this.resource(prefix + Objects.requireNonNull(item.func_199767_j().getRegistryName()).func_110623_a() + suffix);
    }

    default public Consumer<IFinishedRecipe> withCondition(ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        ICondition base = this.baseCondition();
        if (base != null) {
            builder.addCondition(base);
        }
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(Objects.requireNonNull(this.getConsumer()));
    }
}

