/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import java.util.HashSet;
import java.util.Set;
import mod.chiselsandbits.api.KeyBindingContext;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.interfaces.IVoxelBlobItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;

public enum ModConflictContext implements IKeyConflictContext
{
    HOLDING_ROTATEABLE{

        @Override
        public boolean isActive() {
            if (super.isActive()) {
                return true;
            }
            ItemStack held = ClientSide.instance.getPlayer().func_184614_ca();
            return held != null && held.func_77973_b() instanceof IVoxelBlobItem;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME || other == HOLDING_MENUITEM;
        }
    }
    ,
    HOLDING_MENUITEM{

        @Override
        public boolean isActive() {
            if (super.isActive()) {
                return true;
            }
            ChiselToolType tool = ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND);
            return tool != null && tool.hasMenu();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME || other == HOLDING_POSTIVEPATTERN || other == HOLDING_CHISEL || other == HOLDING_TAPEMEASURE;
        }
    }
    ,
    HOLDING_TAPEMEASURE{

        @Override
        public boolean isActive() {
            return super.isActive() || ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND) == ChiselToolType.TAPEMEASURE;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME;
        }
    }
    ,
    HOLDING_POSTIVEPATTERN{

        @Override
        public boolean isActive() {
            return super.isActive() || ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND) == ChiselToolType.POSITIVEPATTERN;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME;
        }
    }
    ,
    HOLDING_CHISEL{

        @Override
        public boolean isActive() {
            if (super.isActive()) {
                return true;
            }
            ChiselToolType tool = ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND);
            return tool != null && tool.isBitOrChisel();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other || other == KeyConflictContext.IN_GAME;
        }
    };

    private final Set<Class<? extends Item>> activeItemClasses = new HashSet<Class<? extends Item>>();

    public void setItemActive(Item item) {
        this.activeItemClasses.add(item.getClass());
    }

    public boolean isActive() {
        KeyBindingContext annotation;
        EntityPlayer player = ClientSide.instance.getPlayer();
        if (player == null) {
            return false;
        }
        ItemStack held = player.func_184614_ca();
        if (held == null) {
            return false;
        }
        for (Class<? extends Item> itemClass : this.activeItemClasses) {
            if (!itemClass.isInstance(held.func_77973_b())) continue;
            return true;
        }
        if (held.func_77973_b().getClass().isAnnotationPresent(KeyBindingContext.class) && (annotation = held.func_77973_b().getClass().getAnnotation(KeyBindingContext.class)) instanceof KeyBindingContext) {
            for (String name : annotation.value()) {
                if (!name.equals(this.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.toString().toLowerCase().replace("holding_", "");
    }
}

