/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mod.chiselsandbits.bitbag.BagStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class BagInventory
implements IInventory {
    BagStorage inv;
    ItemStack[] stackSlots;

    public BagInventory(ItemStack is) {
        this.inv = (BagStorage)is.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.stackSlots = new ItemStack[63];
    }

    public ItemStack getItemStack() {
        return this.inv.stack;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.stackSlots.length;
    }

    public ItemStack func_70301_a(int index) {
        int qty = this.inv.contents[2 * index + 1];
        int id = this.inv.contents[2 * index + 0];
        if (this.stackSlots[index] != null) {
            this.stackSlots[index].field_77994_a = qty;
            return this.stackSlots[index];
        }
        if (qty == 0 || id == 0) {
            return null;
        }
        this.stackSlots[index] = ItemChiseledBit.createStack(id, qty, false);
        return this.stackSlots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        int qty = this.inv.contents[2 * index + 1];
        int id = this.inv.contents[2 * index + 0];
        if (qty == 0 || id == 0) {
            return null;
        }
        if (count > qty) {
            count = qty;
        }
        int n = 2 * index + 1;
        this.inv.contents[n] = this.inv.contents[n] - count;
        this.inv.onChange();
        if (this.stackSlots[index] != null) {
            this.stackSlots[index].field_77994_a -= count;
        }
        return ItemChiseledBit.createStack(id, count, false);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stackSlots[index] = null;
        if (stack != null && stack.func_77973_b() instanceof ItemChiseledBit) {
            this.inv.contents[2 * index + 1] = stack.field_77994_a;
            this.inv.contents[2 * index + 0] = ItemChiseledBit.getStackState(stack);
        } else {
            this.inv.contents[2 * index + 1] = 0;
            this.inv.contents[2 * index + 0] = 0;
        }
        this.inv.onChange();
    }

    public int func_70297_j_() {
        return ChiselsAndBits.getConfig().bagStackSize;
    }

    public void func_70296_d() {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            if (this.stackSlots[x] == null) continue;
            this.inv.contents[2 * x + 1] = this.stackSlots[x].field_77994_a;
            this.stackSlots[x] = null;
            this.inv.onChange();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemChiseledBit;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        int x;
        for (x = 0; x < this.inv.contents.length; ++x) {
            this.inv.contents[x] = 0;
        }
        for (x = 0; x < this.stackSlots.length; ++x) {
            this.stackSlots[x] = null;
        }
        this.inv.onChange();
    }

    public void restockItem(ItemStack target) {
        for (int x = this.func_70302_i_() - 1; x >= 0; --x) {
            ItemStack is = this.func_70301_a(x);
            if (is == null || is.func_77973_b() != target.func_77973_b() || !ItemChiseledBit.sameBit(target, ItemChiseledBit.getStackState(is))) continue;
            target.field_77994_a += is.field_77994_a;
            int total = target.field_77994_a;
            target.field_77994_a = Math.min(is.func_77976_d(), target.field_77994_a);
            int overage = total - target.field_77994_a;
            if (overage > 0) {
                is.field_77994_a = overage;
            } else {
                this.func_70299_a(x, null);
            }
            this.func_70296_d();
        }
    }

    public ItemStack insertItem(ItemStack which) {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            ItemStack is = this.func_70301_a(x);
            if (is != null && ItemChiseledBit.getStackState(which) == ItemChiseledBit.getStackState(is)) {
                is.field_77994_a += which.field_77994_a;
                int total = is.field_77994_a;
                is.field_77994_a = Math.min(this.func_70297_j_(), is.field_77994_a);
                int overage = total - is.field_77994_a;
                if (overage > 0) {
                    which.field_77994_a = overage;
                    this.func_70296_d();
                    continue;
                }
                this.func_70296_d();
                return null;
            }
            if (is != null) continue;
            this.func_70299_a(x, which);
            this.func_70296_d();
            return null;
        }
        return which;
    }

    public int extractBit(int bitMeta, int total) {
        int used = 0;
        for (int index = this.stackSlots.length - 1; index >= 0; --index) {
            int qty_idx = 2 * index + 1;
            int qty = this.inv.contents[qty_idx];
            int id = this.inv.contents[2 * index + 0];
            if (id != bitMeta || qty <= 0) continue;
            int n = qty_idx;
            this.inv.contents[n] = this.inv.contents[n] - total;
            if (this.inv.contents[qty_idx] < 0) {
                this.inv.contents[qty_idx] = 0;
            }
            this.inv.onChange();
            int diff = qty - this.inv.contents[qty_idx];
            used += diff;
            if (0 != (total -= diff)) continue;
            return used;
        }
        return used;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> listContents(List<String> details) {
        TreeMap<String, Integer> contents = new TreeMap<String, Integer>();
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            Item what;
            Block blk;
            IBlockState iBlockState;
            ItemStack is = this.func_70301_a(x);
            if (is == null || (iBlockState = Block.func_176220_d((int)ItemChiseledBit.getStackState(is))) == null || (blk = iBlockState.func_177230_c()) == null || (what = Item.func_150898_a((Block)blk)) == null) continue;
            ItemChiseledBit bit = ChiselsAndBits.getItems().itemBlockBit;
            String name = bit.getBitTypeName(is);
            Integer count = (Integer)contents.get(name);
            count = count == null ? Integer.valueOf(is.field_77994_a) : Integer.valueOf(count + is.field_77994_a);
            contents.put(name, count);
        }
        if (contents.isEmpty()) {
            details.add(LocalStrings.Empty.getLocal());
        }
        ArrayList list = new ArrayList();
        list.addAll(contents.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                int y = o1.getValue();
                int x = o2.getValue();
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        });
        for (Map.Entry entry : list) {
            details.add(entry.getValue() + ' ' + (String)entry.getKey());
        }
        return details;
    }
}

