/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bittank;

import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBitTank
extends TileEntity
implements IItemHandler {
    public static final int MAX_CONTENTS = 4096;
    public static final int MB_PER_BIT_CONVERSION = 125;
    public static final int BITS_PER_MB_CONVERSION = 512;
    private Fluid myFluid = null;
    private int bits = 0;
    private int oldLV = -1;

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.deserializeFromNBT(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound t = new NBTTagCompound();
        this.serializeToNBT(t);
        return new S35PacketUpdateTileEntity(this.func_174877_v(), 0, t);
    }

    public void deserializeFromNBT(NBTTagCompound compound) {
        String fluid = compound.func_74779_i("fluid");
        this.myFluid = fluid == null || fluid.equals("") ? null : FluidRegistry.getFluid((String)fluid);
        this.bits = compound.func_74762_e("bits");
    }

    public void serializeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("fluid", this.myFluid == null ? "" : this.myFluid.getName());
        compound.func_74768_a("bits", this.bits);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.deserializeFromNBT(compound);
        super.func_145839_a(compound);
    }

    public void func_145841_b(NBTTagCompound compound) {
        this.serializeToNBT(compound);
        super.func_145841_b(compound);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.bits > 0 && slot == 0) {
            return this.getFluidBitStack(this.myFluid, this.bits);
        }
        return null;
    }

    public ItemStack getFluidBitStack(Fluid liquid, int amount) {
        if (liquid == null || liquid.getBlock() == null) {
            return null;
        }
        return ItemChiseledBit.createStack(Block.func_176210_f((IBlockState)liquid.getBlock().func_176223_P()), amount, false);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack != null && stack.func_77973_b() instanceof ItemChiseledBit) {
            boolean canInsert;
            int state = ItemChiseledBit.getStackState(stack);
            IBlockState blk = Block.func_176220_d((int)state);
            Fluid f = null;
            for (Fluid fl : FluidRegistry.getRegisteredFluids().values()) {
                if (fl.getBlock() != blk.func_177230_c()) continue;
                f = fl;
                break;
            }
            if (f == null) {
                return stack;
            }
            ItemStack bitItem = this.getFluidBitStack(this.myFluid, this.bits);
            boolean bl = canInsert = bitItem == null || ItemStack.func_77970_a((ItemStack)bitItem, (ItemStack)stack) && bitItem.func_77973_b() == stack.func_77973_b();
            if (canInsert) {
                int merged = this.bits + stack.field_77994_a;
                int amount = Math.min(merged, 4096);
                if (!simulate) {
                    Fluid oldFluid = this.myFluid;
                    int oldBits = this.bits;
                    this.myFluid = f;
                    this.bits = amount;
                    if (this.bits != oldBits || this.myFluid != oldFluid) {
                        this.saveAndUpdate();
                    }
                }
                if (amount < merged) {
                    ItemStack out = stack.func_77946_l();
                    out.field_77994_a = merged - amount;
                    return out;
                }
                return null;
            }
        }
        return stack;
    }

    private void saveAndUpdate() {
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.func_174877_v());
        int lv = this.getLightValue();
        if (this.oldLV != lv) {
            this.func_145831_w().func_175664_x(this.func_174877_v());
            this.oldLV = lv;
        }
    }

    public ItemStack extractBits(int slot, int amount, boolean simulate) {
        ItemStack contents = this.getStackInSlot(slot);
        if (contents != null && amount > 0) {
            contents.field_77994_a = Math.min(amount, contents.field_77994_a);
            if (!simulate) {
                int oldBits = this.bits;
                this.bits -= contents.field_77994_a;
                if (this.bits == 0) {
                    this.myFluid = null;
                }
                if (this.bits != oldBits) {
                    this.saveAndUpdate();
                }
            }
            return contents;
        }
        return null;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractBits(slot, Math.min(amount, ChiselsAndBits.getItems().itemBlockBit.func_77639_j()), simulate);
    }

    public FluidStack getAccessableFluid() {
        int mb = (this.bits - this.bits % 512) / 512;
        if ((mb *= 125) > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, mb);
        }
        return null;
    }

    public boolean hasFastRenderer() {
        return false;
    }

    FluidStack getBitsAsFluidStack() {
        if (this.bits > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, this.bits);
        }
        return null;
    }

    public int getLightValue() {
        if (this.myFluid == null || this.myFluid.getBlock() == null) {
            return 0;
        }
        int lv = this.myFluid.getBlock().func_149750_m();
        return lv;
    }

    boolean extractBits(EntityPlayer playerIn, float hitX, float hitY, float hitZ, BlockPos pos) {
        if (!playerIn.func_70093_af()) {
            ItemStack is = this.extractItem(0, 64, false);
            if (is != null) {
                ChiselsAndBits.getApi().giveBitToPlayer(playerIn, is, new Vec3((double)hitX + (double)pos.func_177958_n(), (double)hitY + (double)pos.func_177956_o(), (double)hitZ + (double)pos.func_177952_p()));
            }
            return true;
        }
        return false;
    }

    boolean addAllPossibleBits(EntityPlayer playerIn) {
        if (playerIn.func_70093_af()) {
            boolean change = false;
            for (int x = 0; x < playerIn.field_71071_by.func_70302_i_(); ++x) {
                ItemStack stackInSlot = playerIn.field_71071_by.func_70301_a(x);
                if (ChiselsAndBits.getApi().getItemType(stackInSlot) != ItemType.CHISLED_BIT) continue;
                playerIn.field_71071_by.func_70299_a(x, this.insertItem(0, stackInSlot, false));
                change = true;
            }
            if (change) {
                playerIn.field_71071_by.func_70296_d();
            }
            return change;
        }
        return false;
    }

    boolean addHeldBits(ItemStack current, EntityPlayer playerIn) {
        if (playerIn.func_70093_af() && ChiselsAndBits.getApi().getItemType(current) == ItemType.CHISLED_BIT) {
            playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, this.insertItem(0, current, false));
            playerIn.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    public IFluidHandler getWrappedTank() {
        return new IFluidHandler(){

            public int fill(EnumFacing from, FluidStack liquid, boolean doFill) {
                int possibleAmount = liquid.amount - liquid.amount % 125;
                if (possibleAmount > 0) {
                    int bitCount = possibleAmount * 512 / 125;
                    ItemStack bitItems = TileEntityBitTank.this.getFluidBitStack(liquid.getFluid(), bitCount);
                    ItemStack leftOver = TileEntityBitTank.this.insertItem(0, bitItems, true);
                    if (leftOver == null) {
                        if (doFill) {
                            TileEntityBitTank.this.insertItem(0, bitItems, false);
                        }
                        return possibleAmount;
                    }
                    int mbUsedUp = leftOver.field_77994_a;
                    mbUsedUp += 511;
                    return mbUsedUp *= 0;
                }
                return 0;
            }

            public FluidStack drainFluid(FluidStack type, int maxDrain, boolean doDrain) {
                int aboutHowMuch;
                int mbThatCanBeRemoved;
                boolean rightType;
                FluidStack a = TileEntityBitTank.this.getAccessableFluid();
                boolean bl = rightType = a != null && type == null || a != null && type.containsFluid(a);
                if (rightType && (mbThatCanBeRemoved = Math.min(a.amount, (aboutHowMuch = Math.max(maxDrain, type == null ? 0 : type.amount)) - aboutHowMuch % 125)) > 0) {
                    a.amount = mbThatCanBeRemoved;
                    if (doDrain) {
                        int bitCount = mbThatCanBeRemoved * 512 / 125;
                        TileEntityBitTank.this.extractBits(0, bitCount, false);
                    }
                    return a;
                }
                return null;
            }

            public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
                return this.drainFluid(resource, 1000, doDrain);
            }

            public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
                return this.drainFluid(null, maxDrain, doDrain);
            }

            public boolean canFill(EnumFacing from, Fluid fluid) {
                FluidStack a = TileEntityBitTank.this.getAccessableFluid();
                return a == null || a.getFluid() == fluid && a.amount < 875;
            }

            public boolean canDrain(EnumFacing from, Fluid fluid) {
                FluidStack a = TileEntityBitTank.this.getAccessableFluid();
                return a != null && (fluid == null || a.getFluid() == fluid) && a.amount >= 125;
            }

            public FluidTankInfo[] getTankInfo(EnumFacing from) {
                return new FluidTankInfo[]{new FluidTankInfo(TileEntityBitTank.this.getAccessableFluid(), 1000)};
            }
        };
    }
}

