/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import mod.chiselsandbits.chiseledblock.BoxType;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateInstance;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class VoxelBlobStateReference
implements Comparable<VoxelBlobStateReference> {
    private static Map<VoxelBlobStateInstance, WeakReference<VoxelBlobStateInstance>> serverRefs = Collections.synchronizedMap(new WeakHashMap());
    private static Map<VoxelBlobStateInstance, WeakReference<VoxelBlobStateInstance>> clientRefs = Collections.synchronizedMap(new WeakHashMap());
    private static byte[] airBlob;
    private final VoxelBlobStateInstance data;
    public final long weight;

    private static Map<VoxelBlobStateInstance, WeakReference<VoxelBlobStateInstance>> getRefs() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return clientRefs;
        }
        return serverRefs;
    }

    private static VoxelBlobStateInstance lookupRef(VoxelBlobStateInstance inst) {
        WeakReference<VoxelBlobStateInstance> ref = VoxelBlobStateReference.getRefs().get(inst);
        if (ref != null) {
            return (VoxelBlobStateInstance)ref.get();
        }
        return null;
    }

    private static byte[] findBytesFor(int stateId) {
        if (stateId == 0) {
            if (airBlob == null) {
                VoxelBlob vb = new VoxelBlob();
                airBlob = vb.blobToBytes(VoxelBlob.VERSION_COMPACT);
            }
            return airBlob;
        }
        VoxelBlob vb = new VoxelBlob();
        vb.fill(stateId);
        return vb.blobToBytes(VoxelBlob.VERSION_COMPACT);
    }

    private static void addRef(VoxelBlobStateInstance inst) {
        VoxelBlobStateReference.getRefs().put(inst, new WeakReference<VoxelBlobStateInstance>(inst));
    }

    private static VoxelBlobStateInstance FindRef(byte[] v) {
        VoxelBlobStateInstance t = new VoxelBlobStateInstance(v);
        VoxelBlobStateInstance ref = null;
        ref = VoxelBlobStateReference.lookupRef(t);
        if (ref == null) {
            ref = t;
            VoxelBlobStateReference.addRef(t);
        }
        return ref;
    }

    public VoxelBlobStateInstance getInstance() {
        return this.data;
    }

    public byte[] getByteArray() {
        return this.data.voxelBytes;
    }

    public VoxelBlob getVoxelBlob() {
        return this.data.getBlob();
    }

    public VoxelBlobStateReference(VoxelBlob blob, long weight) {
        this(blob.blobToBytes(VoxelBlob.VERSION_COMPACT), weight);
        this.data.blob = new SoftReference<VoxelBlob>(new VoxelBlob(blob));
    }

    public VoxelBlobStateReference(int stateId, long weight) {
        this(VoxelBlobStateReference.findBytesFor(stateId), weight);
    }

    public VoxelBlobStateReference(byte[] v, long weight) {
        this.data = VoxelBlobStateReference.FindRef(v);
        this.weight = weight;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VoxelBlobStateReference)) {
            return false;
        }
        VoxelBlobStateReference second = (VoxelBlobStateReference)obj;
        return this.data.equals(second.data) && second.weight == this.weight;
    }

    public int hashCode() {
        return this.data.hash ^ (int)(this.weight ^ this.weight >>> 32);
    }

    @Override
    public int compareTo(VoxelBlobStateReference o) {
        int comp = this.data.compareTo(o.data);
        if (comp == 0) {
            if (this.weight == o.weight) {
                return 0;
            }
            return this.weight < o.weight ? -1 : 1;
        }
        return comp;
    }

    public Collection<AxisAlignedBB> getBoxes(BoxType type) {
        return this.data.getBoxes(type);
    }
}

