/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.core.ChiselsAndBits;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class SetBit
extends CommandBase {
    public String func_71517_b() {
        return "setbit";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.setbit.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 7) {
            throw new WrongUsageException("commands.setbit.usage", new Object[0]);
        }
        BlockPos blockpos = SetBit.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
        BlockPos bitpos = SetBit.func_175757_a((ICommandSender)sender, (String[])args, (int)3, (boolean)false);
        Block block = CommandBase.func_147180_g((ICommandSender)sender, (String)args[6]);
        int meta = 0;
        if (args.length >= 8) {
            meta = SetBit.func_175764_a((String)args[7], (int)0, (int)15);
        }
        IBlockState state = block.func_176203_a(meta);
        World world = sender.func_130014_f_();
        if (!world.func_175667_e(blockpos)) {
            throw new CommandException("commands.setbit.outOfWorld", new Object[0]);
        }
        try {
            IChiselAndBitsAPI api = ChiselsAndBits.getApi();
            IBitAccess ba = api.getBitAccess(world, blockpos);
            IBitBrush bit = ba.getBitAt(bitpos.func_177958_n(), bitpos.func_177956_o(), bitpos.func_177952_p());
            IBitBrush brush = api.createBrushFromState(state);
            if (bit == brush) {
                throw new CommandException("commands.setbit.noChange", new Object[0]);
            }
            ba.setBitAt(bitpos.func_177958_n(), bitpos.func_177956_o(), bitpos.func_177952_p(), brush);
            ba.commitChanges(true);
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
            SetBit.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.setbit.success", (Object[])new Object[0]);
        }
        catch (APIExceptions.CannotBeChiseled e) {
            throw new CommandException("commands.setbit.cannotChiselBlock", new Object[0]);
        }
        catch (APIExceptions.InvalidBitItem e) {
            throw new CommandException("commands.setbit.invalidState", new Object[0]);
        }
        catch (APIExceptions.SpaceOccupied e) {
            throw new CommandException("commands.setbit.spaceOccupied", new Object[0]);
        }
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        return args.length > 0 && args.length <= 3 ? SetBit.func_175771_a((String[])args, (int)0, (BlockPos)pos) : (args.length == 7 ? SetBit.func_175762_a((String[])args, (Collection)Block.field_149771_c.func_148742_b()) : Collections.emptyList());
    }
}

