/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.config.Configured;
import mod.chiselsandbits.core.ChiselMode;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.LocalStrings;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig
extends Configuration {
    public boolean allowBlockAlternatives = false;
    public boolean lowMemoryMode = false;
    private final File myPath;
    @Configured(category="Integration Settings")
    public boolean ShowBitsInJEI;
    @Configured(category="Troubleshooting")
    public boolean enableAPITestingItem;
    @Configured(category="Troubleshooting")
    public boolean logTileErrors;
    @Configured(category="Client Settings")
    public boolean enableRightClickModeChange;
    @Configured(category="Client Settings")
    private boolean showUsage;
    @Configured(category="Client Settings")
    public boolean invertBitBagFullness;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Plane;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_ConnectedPlane;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Line;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_SmallCube;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_MediumCube;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_LargeCube;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_DrawnRegion;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Snap2;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Snap4;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Snap8;
    @Configured(category="Client Settings")
    public boolean enableToolbarIcons;
    @Configured(category="Client Settings")
    public boolean perChiselMode;
    @Configured(category="Client Settings")
    public boolean chatModeNotification;
    @Configured(category="Client Settings")
    public boolean itemNameModeDisplay;
    @Configured(category="Client Settings")
    public int creativeClipboardSize;
    @Configured(category="Client Settings")
    public boolean addBrokenBlocksToCreativeClipboard;
    @Configured(category="Client Settings")
    public boolean fluidBitsAreClickThough;
    @Configured(category="Client Settings")
    public boolean persistCreativeClipboard;
    @Configured(category="Client Settings")
    public int maxUndoLevel;
    @Configured(category="Client Preformance Settings")
    public int dynamicModelFaceCount;
    @Configured(category="Client Preformance Settings")
    public int dynamicModelRange;
    @Configured(category="Client Preformance Settings")
    public boolean dynamicModelMinimizeLatancy;
    @Configured(category="Client Preformance Settings")
    public int dynamicMaxConcurrentTessalators;
    @Configured(category="Balance Settings")
    public boolean damageTools;
    @Configured(category="Crafting")
    public boolean enablePositivePrintCrafting;
    @Configured(category="Crafting")
    public boolean enableStackableCrafting;
    @Configured(category="Crafting")
    public boolean enableNegativePrintInversionCrafting;
    @Configured(category="Items")
    public boolean enableBitTank;
    @Configured(category="Items")
    public boolean enableBitBag;
    @Configured(category="Items")
    public boolean enableNegativePrint;
    @Configured(category="Items")
    public boolean enableMirrorPrint;
    @Configured(category="Items")
    public boolean enablePositivePrint;
    @Configured(category="Items")
    public boolean enableChisledBits;
    @Configured(category="Items")
    public boolean enableStoneChisel;
    @Configured(category="Items")
    public boolean enableIronChisel;
    @Configured(category="Items")
    public boolean enableGoldChisel;
    @Configured(category="Items")
    public boolean enableDiamondChisel;
    @Configured(category="Items")
    public boolean enableWoodenWrench;
    @Configured(category="Items")
    public boolean enableBitSaw;
    @Configured(category="Balance Settings")
    public boolean enableChiselToolHarvestCheck;
    @Configured(category="Balance Settings")
    public String enableChiselToolHarvestCheckTools;
    @Configured(category="Balance Settings")
    public boolean enableToolHarvestLevels;
    @Configured(category="Balance Settings")
    public boolean enableBitLightSource;
    @Configured(category="Balance Settings")
    public float bitLightPercentage;
    @Configured(category="Balance Settings")
    public boolean compatabilityMode;
    @Configured(category="Balance Settings")
    public double maxDrawnRegionSize;
    @Configured(category="Balance Settings")
    public int bagStackSize;
    @Configured(category="Balance Settings")
    public int stoneChiselUses;
    @Configured(category="Balance Settings")
    public int ironChiselUses;
    @Configured(category="Balance Settings")
    public int diamondChiselUses;
    @Configured(category="Balance Settings")
    public int goldChiselUses;
    @Configured(category="Balance Settings")
    public int wrenchUses;
    @Configured(category="Balance Settings")
    public int diamondSawUses;
    @Configured(category="Balance Settings")
    public boolean enableSetBitCommand;

    public boolean deobfuscatedEnvironment() {
        Object deObf = Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return Boolean.valueOf(String.valueOf(deObf));
    }

    public boolean isEnabled(String className) {
        Property p = this.get("Enabled Blocks", className, true);
        boolean out = p.getBoolean(true);
        if (this.hasChanged()) {
            this.save();
        }
        return out;
    }

    private void setDefaults() {
        long mem = Runtime.getRuntime().maxMemory() / 0x100000L;
        this.logTileErrors = false;
        this.enableAPITestingItem = this.deobfuscatedEnvironment();
        this.lowMemoryMode = mem < 1200L;
        this.enableChiselMode_ConnectedPlane = !ChiselMode.CONNECTED_PLANE.isDisabled;
        this.enableChiselMode_LargeCube = !ChiselMode.CUBE_LARGE.isDisabled;
        this.enableChiselMode_MediumCube = !ChiselMode.CUBE_MEDIUM.isDisabled;
        this.enableChiselMode_SmallCube = !ChiselMode.CUBE_SMALL.isDisabled;
        this.enableChiselMode_Line = !ChiselMode.LINE.isDisabled;
        this.enableChiselMode_Plane = !ChiselMode.PLANE.isDisabled;
        this.enableChiselMode_DrawnRegion = !ChiselMode.DRAWN_REGION.isDisabled;
        this.enableChiselMode_Snap2 = !ChiselMode.SNAP2.isDisabled;
        this.enableChiselMode_Snap4 = !ChiselMode.SNAP4.isDisabled;
        this.enableChiselMode_Snap8 = !ChiselMode.SNAP8.isDisabled;
        this.perChiselMode = true;
        this.chatModeNotification = false;
        this.itemNameModeDisplay = true;
        this.enableToolbarIcons = true;
        this.compatabilityMode = true;
        this.maxDrawnRegionSize = 4.0;
        this.bagStackSize = 512;
        this.maxUndoLevel = 32;
        this.dynamicModelFaceCount = 40;
        this.dynamicModelRange = 128;
        this.dynamicModelMinimizeLatancy = true;
        this.dynamicMaxConcurrentTessalators = 32;
        this.showUsage = true;
        this.invertBitBagFullness = false;
        this.enableSetBitCommand = false;
        this.damageTools = true;
        this.stoneChiselUses = 8384;
        this.ironChiselUses = 293440;
        this.diamondChiselUses = 796480;
        this.goldChiselUses = 1024;
        this.wrenchUses = 1888;
        this.diamondSawUses = 7980;
        this.enablePositivePrintCrafting = true;
        this.enableStackableCrafting = true;
        this.enableNegativePrintInversionCrafting = true;
        this.enableChiselToolHarvestCheck = true;
        this.enableToolHarvestLevels = true;
        this.enableChiselToolHarvestCheckTools = "pickaxe,axe,shovel";
        this.creativeClipboardSize = 32;
        this.addBrokenBlocksToCreativeClipboard = true;
        this.fluidBitsAreClickThough = true;
        this.persistCreativeClipboard = true;
        this.enableRightClickModeChange = false;
        this.enableBitTank = true;
        this.enableBitLightSource = true;
        this.bitLightPercentage = 6.25f;
        this.enableBitBag = true;
        this.enableNegativePrint = true;
        this.enablePositivePrint = true;
        this.enableMirrorPrint = true;
        this.enableChisledBits = true;
        this.enableStoneChisel = true;
        this.enableIronChisel = true;
        this.enableGoldChisel = true;
        this.enableDiamondChisel = true;
        this.enableWoodenWrench = true;
        this.enableBitSaw = true;
        this.ShowBitsInJEI = false;
    }

    public ModConfig(File path) {
        super(path);
        this.myPath = path;
        ChiselsAndBits.registerWithBus((Object)this);
        this.setDefaults();
        this.populateSettings();
        this.save();
    }

    void populateSettings() {
        Class<ModConfig> me = ModConfig.class;
        HashSet<Property> fields = new HashSet<Property>();
        for (Field f : me.getDeclaredFields()) {
            Configured c = f.getAnnotation(Configured.class);
            if (c == null) continue;
            try {
                Property p = null;
                if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    long defaultValue = f.getLong((Object)this);
                    p = this.get(c.category(), f.getName(), (int)defaultValue);
                    long value = p.getInt();
                    f.set((Object)this, value);
                } else if (f.getType() == String.class) {
                    String defaultValue = (String)f.get((Object)this);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    String value = p.getString();
                    f.set((Object)this, value);
                } else if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    int defaultValue = f.getInt((Object)this);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    int value = p.getInt();
                    f.set((Object)this, value);
                } else if (f.getType() == Float.TYPE || f.getType() == Float.class) {
                    float defaultValue = f.getFloat((Object)this);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    float value = (float)p.getDouble();
                    f.set((Object)this, Float.valueOf(value));
                } else if (f.getType() == Double.TYPE || f.getType() == Double.class) {
                    double defaultValue = f.getDouble((Object)this);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    double value = p.getDouble();
                    f.set((Object)this, value);
                } else if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
                    boolean defaultValue = f.getBoolean((Object)this);
                    p = this.get(c.category(), f.getName(), defaultValue);
                    boolean value = p.getBoolean();
                    f.set((Object)this, value);
                }
                if (p == null) continue;
                p.setLanguageKey("mod.chiselsandbits.config." + f.getName());
                fields.add(p);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (String s : this.getCategoryNames()) {
            if (s.equals("enabled blocks")) continue;
            ConfigCategory cc = this.getCategory(s);
            ArrayList removeThis = new ArrayList();
            for (Map.Entry e : cc.entrySet()) {
                if (fields.contains(e.getValue())) continue;
                removeThis.add(e.getKey());
            }
            for (String g : removeThis) {
                cc.remove((Object)g);
            }
        }
        this.sync();
    }

    private void sync() {
        if (this.bagStackSize < 64) {
            this.bagStackSize = 64;
        } else if (this.bagStackSize > 999999) {
            this.bagStackSize = 999999;
        }
        ChiselMode.CONNECTED_PLANE.isDisabled = !this.enableChiselMode_ConnectedPlane;
        ChiselMode.CUBE_LARGE.isDisabled = !this.enableChiselMode_LargeCube;
        ChiselMode.CUBE_MEDIUM.isDisabled = !this.enableChiselMode_MediumCube;
        ChiselMode.CUBE_SMALL.isDisabled = !this.enableChiselMode_SmallCube;
        ChiselMode.LINE.isDisabled = !this.enableChiselMode_Line;
        ChiselMode.PLANE.isDisabled = !this.enableChiselMode_Plane;
        ChiselMode.DRAWN_REGION.isDisabled = !this.enableChiselMode_DrawnRegion;
        ChiselMode.SNAP2.isDisabled = !this.enableChiselMode_Snap2;
        ChiselMode.SNAP4.isDisabled = !this.enableChiselMode_Snap4;
        ChiselMode.SNAP8.isDisabled = !this.enableChiselMode_Snap8;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("chiselsandbits")) {
            this.populateSettings();
            this.save();
        }
    }

    public void save() {
        if (this.hasChanged()) {
            super.save();
        }
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        Property prop = super.get(category, key, defaultValue, comment, type);
        if (prop != null && !category.equals("Client Settings") && category.equals("Client Preformance")) {
            prop.setRequiresMcRestart(true);
        }
        return prop;
    }

    public void helpText(LocalStrings string, List<String> tooltip, String ... variables) {
        if (this.showUsage) {
            String[] lines;
            int varOffset = 0;
            for (String a : lines = string.getLocal().split(";")) {
                while (a.contains("{}") && variables.length > varOffset) {
                    int offset = a.indexOf("{}");
                    if (offset < 0) continue;
                    String pre = a.substring(0, offset);
                    String post = a.substring(offset + 2);
                    a = pre + variables[varOffset++] + post;
                }
                tooltip.add(a);
            }
        }
    }

    public String getFilePath() {
        return this.myPath.getAbsolutePath();
    }
}

