/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import com.google.common.base.Stopwatch;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.bittank.BlockBitTank;
import mod.chiselsandbits.bittank.TileEntityBitTank;
import mod.chiselsandbits.bittank.TileEntitySpecialRenderBitTank;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ChiselTypeIterator;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.client.gui.ChiselsAndBitsMenu;
import mod.chiselsandbits.client.gui.SpriteIconPositioning;
import mod.chiselsandbits.commands.JsonModelExport;
import mod.chiselsandbits.core.ChiselMode;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ChiselModeManager;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.helpers.VoxelRegionSrc;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketChisel;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.render.SmartModelManager;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockRenderChunkTESR;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ClientSide {
    private static final Random RANDOM = new Random();
    public static final ClientSide instance = new ClientSide();
    private final HashMap<ChiselMode, SpriteIconPositioning> chiselModeIcons = new HashMap();
    private KeyBinding rotateCCW;
    private KeyBinding rotateCW;
    private KeyBinding undo;
    private KeyBinding redo;
    private KeyBinding modeMenu;
    private KeyBinding addToClipboard;
    private KeyBinding pickBit;
    private Stopwatch rotateTimer;
    public static TextureAtlasSprite undoIcon;
    public static TextureAtlasSprite redoIcon;
    public static TextureAtlasSprite trashIcon;
    private ItemStack previousItem;
    private int previousRotations;
    private Object previousModel;
    private Object previousCacheRef;
    private IntegerBox modelBounds;
    private boolean isVisible = true;
    private BlockPos lastPartial;
    private BlockPos lastPos;
    private BitLocation drawStart;
    private boolean loopDeath = false;
    private int lastRenderedFrame = Integer.MIN_VALUE;
    ChiselToolType lastTool = ChiselToolType.CHISEL;

    public void preinit(ChiselsAndBits mod) {
        ChiselsAndBits.registerWithBus(new SmartModelManager());
        this.registerModels();
    }

    public void init(ChiselsAndBits chiselsandbits) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockChiseledTESR.class, (TileEntitySpecialRenderer)new ChisledBlockRenderChunkTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBitTank.class, (TileEntitySpecialRenderer)new TileEntitySpecialRenderBitTank());
        for (ChiselMode mode : ChiselMode.values()) {
            KeyBinding binding = new KeyBinding(mode.string.toString(), 0, "itemGroup.chiselsandbits");
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
            mode.binding = binding;
        }
        this.modeMenu = new KeyBinding("mod.chiselsandbits.other.mode", 56, "itemGroup.chiselsandbits");
        ClientRegistry.registerKeyBinding((KeyBinding)this.modeMenu);
        this.rotateCCW = new KeyBinding("mod.chiselsandbits.other.rotate.ccw", 0, "itemGroup.chiselsandbits");
        ClientRegistry.registerKeyBinding((KeyBinding)this.rotateCCW);
        this.rotateCW = new KeyBinding("mod.chiselsandbits.other.rotate.cw", 0, "itemGroup.chiselsandbits");
        ClientRegistry.registerKeyBinding((KeyBinding)this.rotateCW);
        this.pickBit = new KeyBinding("mod.chiselsandbits.other.pickbit", 0, "itemGroup.chiselsandbits");
        ClientRegistry.registerKeyBinding((KeyBinding)this.pickBit);
        this.undo = new KeyBinding("mod.chiselsandbits.other.undo", 0, "itemGroup.chiselsandbits");
        ClientRegistry.registerKeyBinding((KeyBinding)this.undo);
        this.redo = new KeyBinding("mod.chiselsandbits.other.redo", 0, "itemGroup.chiselsandbits");
        ClientRegistry.registerKeyBinding((KeyBinding)this.redo);
        this.addToClipboard = new KeyBinding("mod.chiselsandbits.other.add_to_clipboard", 0, "itemGroup.chiselsandbits");
        ClientRegistry.registerKeyBinding((KeyBinding)this.addToClipboard);
        ChiselsAndBits.registerWithBus(instance);
        ClientCommandHandler.instance.func_71560_a((ICommand)new JsonModelExport());
    }

    public void postinit(ChiselsAndBits mod) {
    }

    public void registerModels() {
        String modId = "chiselsandbits";
        ModItems modItems = ChiselsAndBits.getItems();
        this.registerMesh((Item)modItems.itemChiselStone, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_stone"), "inventory"));
        this.registerMesh((Item)modItems.itemChiselIron, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_iron"), "inventory"));
        this.registerMesh((Item)modItems.itemChiselGold, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_gold"), "inventory"));
        this.registerMesh((Item)modItems.itemChiselDiamond, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_diamond"), "inventory"));
        this.registerMesh(modItems.itemBitBag, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "bit_bag"), "inventory"));
        this.registerMesh(modItems.itemWrench, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "wrench_wood"), "inventory"));
        this.registerMesh(modItems.itemBitSawDiamond, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "bitsaw_diamond"), "inventory"));
        if (modItems.itemPositiveprint != null) {
            ModelBakery.registerItemVariants((Item)modItems.itemPositiveprint, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("chiselsandbits", "positiveprint"), new ResourceLocation("chiselsandbits", "positiveprint_written")});
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemPositiveprint, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", stack.func_77942_o() ? "positiveprint_written_preview" : "positiveprint"), "inventory");
                }
            });
        }
        if (modItems.itemNegativeprint != null) {
            ModelBakery.registerItemVariants((Item)modItems.itemNegativeprint, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("chiselsandbits", "negativeprint"), new ResourceLocation("chiselsandbits", "negativeprint_written")});
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemNegativeprint, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", stack.func_77942_o() ? "negativeprint_written_preview" : "negativeprint"), "inventory");
                }
            });
        }
        if (modItems.itemMirrorprint != null) {
            ModelBakery.registerItemVariants((Item)modItems.itemMirrorprint, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("chiselsandbits", "mirrorprint"), new ResourceLocation("chiselsandbits", "mirrorprint_written")});
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemMirrorprint, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", stack.func_77942_o() ? "mirrorprint_written_preview" : "mirrorprint"), "inventory");
                }
            });
        }
        if (modItems.itemBlockBit != null) {
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemBlockBit, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", "block_bit"), "inventory");
                }
            });
        }
        for (BlockChiseled blk : ChiselsAndBits.getBlocks().getConversions().values()) {
            Item item = Item.func_150898_a((Block)blk);
            this.registerMesh(item, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "block_chiseled"), "inventory"));
        }
        BlockBitTank bitTank = ChiselsAndBits.getBlocks().blockBitTank;
        Item bitTankItem = Item.func_150898_a((Block)bitTank);
        ModelResourceLocation bittank_item = new ModelResourceLocation(new ResourceLocation("chiselsandbits", "bittank"), "inventory");
        this.registerMesh(bitTankItem, 0, bittank_item);
        ChiselsAndBits.getConfig().allowBlockAlternatives = Minecraft.func_71410_x().field_71474_y.field_178880_u;
    }

    private void registerMesh(Item item, int meta, ModelResourceLocation loctaion) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)loctaion);
        }
    }

    @SubscribeEvent
    void registerIconTextures(TextureStitchEvent.Pre ev) {
        undoIcon = ev.map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/undo"));
        redoIcon = ev.map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/redo"));
        trashIcon = ev.map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/trash"));
        for (ChiselMode mode : ChiselMode.values()) {
            SpriteIconPositioning sip = new SpriteIconPositioning();
            ResourceLocation sprite = new ResourceLocation("chiselsandbits", "icons/" + mode.name().toLowerCase());
            ResourceLocation png = new ResourceLocation("chiselsandbits", "textures/icons/" + mode.name().toLowerCase() + ".png");
            sip.sprite = ev.map.func_174942_a(sprite);
            try {
                IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(png);
                BufferedImage bi = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
                int bottom = 0;
                int right = 0;
                sip.left = bi.getWidth();
                sip.top = bi.getHeight();
                for (int x = 0; x < bi.getWidth(); ++x) {
                    for (int y = 0; y < bi.getHeight(); ++y) {
                        int color = bi.getRGB(x, y);
                        int a = color >> 24 & 0xFF;
                        if (a <= 0) continue;
                        sip.left = Math.min(sip.left, (double)x);
                        right = Math.max(right, x);
                        sip.top = Math.min(sip.top, (double)y);
                        bottom = Math.max(bottom, y);
                    }
                }
                sip.height = (double)bottom - sip.top + 1.0;
                sip.width = (double)right - sip.left + 1.0;
                sip.left /= (double)bi.getWidth();
                sip.width /= (double)bi.getWidth();
                sip.top /= (double)bi.getHeight();
                sip.height /= (double)bi.getHeight();
            }
            catch (IOException e) {
                sip.height = 1.0;
                sip.width = 1.0;
                sip.left = 0.0;
                sip.top = 0.0;
            }
            this.chiselModeIcons.put(mode, sip);
        }
    }

    public SpriteIconPositioning getIconForMode(ChiselMode mode) {
        return this.chiselModeIcons.get((Object)mode);
    }

    @SubscribeEvent
    public void onRenderGUI(RenderGameOverlayEvent.Post event) {
        ChiselToolType tool = this.getHeldToolType();
        if (event.type == RenderGameOverlayEvent.ElementType.ALL && tool != null) {
            boolean wasVisible = ChiselsAndBitsMenu.instance.isVisible();
            if (this.modeMenu.func_151470_d()) {
                ChiselsAndBitsMenu.instance.actionUsed = false;
                ChiselsAndBitsMenu.instance.raiseVisibility();
            } else {
                if (!ChiselsAndBitsMenu.instance.actionUsed) {
                    if (ChiselsAndBitsMenu.instance.switchTo != null) {
                        ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool), ChiselsAndBitsMenu.instance.switchTo);
                    }
                    if (ChiselsAndBitsMenu.instance.doAction != null) {
                        switch (ChiselsAndBitsMenu.instance.doAction) {
                            case UNDO: {
                                UndoTracker.getInstance().undo();
                                break;
                            }
                            case REDO: {
                                UndoTracker.getInstance().redo();
                            }
                        }
                    }
                }
                ChiselsAndBitsMenu.instance.actionUsed = true;
                ChiselsAndBitsMenu.instance.decreaseVisibility();
            }
            if (ChiselsAndBitsMenu.instance.isVisible()) {
                ChiselsAndBitsMenu.instance.configure(event.resolution.func_78326_a(), event.resolution.func_78328_b());
                if (!wasVisible) {
                    ChiselsAndBitsMenu.instance.field_146297_k.field_71415_G = false;
                    ChiselsAndBitsMenu.instance.field_146297_k.field_71417_B.func_74373_b();
                }
                if (ChiselsAndBitsMenu.instance.field_146297_k.field_71415_G) {
                    KeyBinding.func_74506_a();
                }
                int k1 = Mouse.getX() * event.resolution.func_78326_a() / ChiselsAndBitsMenu.instance.field_146297_k.field_71443_c;
                int l1 = event.resolution.func_78328_b() - Mouse.getY() * event.resolution.func_78328_b() / ChiselsAndBitsMenu.instance.field_146297_k.field_71440_d - 1;
                ForgeHooksClient.drawScreen((GuiScreen)ChiselsAndBitsMenu.instance, (int)k1, (int)l1, (float)event.partialTicks);
            } else if (wasVisible) {
                ChiselsAndBitsMenu.instance.field_146297_k.func_71381_h();
            }
        }
        if (this.undo.func_151468_f()) {
            UndoTracker.getInstance().undo();
        }
        if (this.redo.func_151468_f()) {
            UndoTracker.getInstance().redo();
        }
        if (this.addToClipboard.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                try {
                    IBitAccess access = ChiselsAndBits.getApi().getBitAccess((World)mc.field_71441_e, mc.field_71476_x.func_178782_a());
                    ItemStack is = access.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
                    CreativeClipboardTab.addItem(is);
                }
                catch (APIExceptions.CannotBeChiseled access) {
                    // empty catch block
                }
            }
        }
        if (this.pickBit.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                try {
                    BitLocation bl = new BitLocation(mc.field_71476_x, true, ChiselToolType.CHISEL);
                    IBitAccess access = ChiselsAndBits.getApi().getBitAccess((World)mc.field_71441_e, bl.getBlockPos());
                    IBitBrush brush = access.getBitAt(bl.getBitX(), bl.getBitY(), bl.getBitZ());
                    if (brush != null) {
                        ItemStack is = brush.getItemStack(1);
                        this.doPick(is);
                    }
                }
                catch (APIExceptions.CannotBeChiseled bl) {
                    // empty catch block
                }
            }
        }
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR && ChiselsAndBits.getConfig().enableToolbarIcons) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!mc.field_71439_g.func_175149_v()) {
                GuiIngame sc = mc.field_71456_v;
                for (int slot = 0; slot < 9; ++slot) {
                    ItemStack stack = mc.field_71439_g.field_71071_by.field_70462_a[slot];
                    if (stack == null || !(stack.func_77973_b() instanceof ItemChisel)) continue;
                    ChiselMode mode = ChiselMode.getMode(stack);
                    if (!ChiselsAndBits.getConfig().perChiselMode) {
                        mode = ChiselModeManager.getChiselMode((EntityPlayer)mc.field_71439_g, ChiselToolType.CHISEL);
                    }
                    int x = event.resolution.func_78326_a() / 2 - 90 + slot * 20 + 2;
                    int y = event.resolution.func_78328_b() - 16 - 3;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    TextureAtlasSprite sprite = this.chiselModeIcons.get((Object)((Object)mode)).sprite;
                    GlStateManager.func_179147_l();
                    sc.func_175175_a(x + 1, y + 1, sprite, 8, 8);
                    GlStateManager.func_179084_k();
                }
            }
        }
    }

    private boolean doPick(ItemStack result) {
        EntityPlayer player = this.getPlayer();
        for (int x = 0; x < 9; ++x) {
            ItemStack stack = player.field_71071_by.func_70301_a(x);
            if (stack == null || !stack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)result)) continue;
            player.field_71071_by.field_70461_c = x;
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            return false;
        }
        int slot = player.field_71071_by.func_70447_i();
        if (slot < 0 || slot >= 9) {
            slot = player.field_71071_by.field_70461_c;
        }
        player.field_71071_by.func_70299_a(slot, result);
        player.field_71071_by.field_70461_c = slot;
        int j = player.field_71069_bz.field_75151_b.size() - 9 + player.field_71071_by.field_70461_c;
        Minecraft.func_71410_x().field_71442_b.func_78761_a(player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c), j);
        return true;
    }

    public ChiselToolType getHeldToolType() {
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return null;
        }
        ItemStack is = player.func_71045_bC();
        if (is != null && is.func_77973_b() instanceof ItemChisel) {
            return ChiselToolType.CHISEL;
        }
        if (is != null && is.func_77973_b() instanceof ItemChiseledBit) {
            return ChiselToolType.BIT;
        }
        return null;
    }

    @SubscribeEvent
    public void interaction(TickEvent.ClientTickEvent event) {
        PacketRotateVoxelBlob p;
        if (event.side == Side.CLIENT && event.type == TickEvent.Type.CLIENT && event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
            ItemChisel.resetDelay();
        }
        if (!this.getToolKey().func_151470_d()) {
            if (this.loopDeath) {
                this.drawStart = null;
                this.lastTool = ChiselToolType.CHISEL;
            } else {
                this.loopDeath = true;
            }
        } else {
            this.loopDeath = false;
        }
        if (this.rotateCCW.func_151470_d() && (this.rotateTimer == null || this.rotateTimer.elapsed(TimeUnit.MILLISECONDS) > 200L)) {
            this.rotateTimer = Stopwatch.createStarted();
            p = new PacketRotateVoxelBlob();
            p.rotationDirection = 1;
            NetworkRouter.instance.sendToServer(p);
        }
        if (this.rotateCW.func_151470_d() && (this.rotateTimer == null || this.rotateTimer.elapsed(TimeUnit.MILLISECONDS) > 200L)) {
            this.rotateTimer = Stopwatch.createStarted();
            p = new PacketRotateVoxelBlob();
            p.rotationDirection = -1;
            NetworkRouter.instance.sendToServer(p);
        }
        for (ChiselMode mode : ChiselMode.values()) {
            KeyBinding kb = (KeyBinding)mode.binding;
            if (!kb.func_151470_d()) continue;
            ChiselToolType tool = this.getHeldToolType();
            ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool), mode);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void updateConfig(GuiScreenEvent.ActionPerformedEvent.Pre ev) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ChiselsAndBits.getConfig().allowBlockAlternatives = Minecraft.func_71410_x().field_71474_y.field_178880_u;
            }
        });
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        ChiselToolType tool = this.getHeldToolType();
        ChiselMode chMode = ChiselModeManager.getChiselMode(this.getPlayer(), tool);
        if (chMode == ChiselMode.DRAWN_REGION) {
            tool = this.lastTool;
        }
        if (tool != null && chMode != null) {
            EntityPlayer player = event.player;
            float partialTicks = event.partialTicks;
            MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
            World theWorld = player.field_70170_p;
            if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            boolean showBox = false;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                BitLocation location = new BitLocation(mop, true, this.getDrawnTool());
                if (theWorld.func_175723_af().func_177746_a(location.blockPos)) {
                    VoxelBlob vb;
                    IBlockState state = theWorld.func_180495_p(location.blockPos);
                    boolean isChisel = this.getDrawnTool() == ChiselToolType.CHISEL;
                    boolean isBit = this.getHeldToolType() == ChiselToolType.BIT;
                    TileEntityBlockChiseled data = ModUtil.getChiseledTileEntity(theWorld, location.blockPos, false);
                    VoxelRegionSrc region = new VoxelRegionSrc(theWorld, location.blockPos, 1);
                    VoxelBlob voxelBlob = vb = data != null ? data.getBlob() : new VoxelBlob();
                    if (isChisel && data == null) {
                        showBox = true;
                        vb.fill(1);
                    }
                    BitLocation other = this.getStartPos();
                    if (chMode == ChiselMode.DRAWN_REGION && other != null) {
                        ChiselTypeIterator oneEnd = new ChiselTypeIterator(16, location.bitX, location.bitY, location.bitZ, VoxelBlob.NULL_BLOB, ChiselMode.SINGLE, EnumFacing.UP);
                        ChiselTypeIterator otherEnd = new ChiselTypeIterator(16, other.bitX, other.bitY, other.bitZ, VoxelBlob.NULL_BLOB, ChiselMode.SINGLE, EnumFacing.UP);
                        AxisAlignedBB a = oneEnd.getBoundingBox(VoxelBlob.NULL_BLOB, false).func_72317_d((double)location.blockPos.func_177958_n(), (double)location.blockPos.func_177956_o(), (double)location.blockPos.func_177952_p());
                        AxisAlignedBB b = otherEnd.getBoundingBox(VoxelBlob.NULL_BLOB, false).func_72317_d((double)other.blockPos.func_177958_n(), (double)other.blockPos.func_177956_o(), (double)other.blockPos.func_177952_p());
                        AxisAlignedBB bb = a.func_111270_a(b);
                        double maxChiseSize = ChiselsAndBits.getConfig().maxDrawnRegionSize + 0.001;
                        if (bb.field_72336_d - bb.field_72340_a <= maxChiseSize && bb.field_72337_e - bb.field_72338_b <= maxChiseSize && bb.field_72334_f - bb.field_72339_c <= maxChiseSize) {
                            this.drawSelectionBoundingBoxIfExists(bb, BlockPos.field_177992_a, player, partialTicks, false);
                            if (!this.getToolKey().func_151470_d()) {
                                PacketChisel pc = new PacketChisel(this.lastTool == ChiselToolType.BIT, location, other, EnumFacing.UP, chMode);
                                if (pc.doAction(this.getPlayer()) > 0) {
                                    NetworkRouter.instance.sendToServer(pc);
                                    ClientSide.placeSound(theWorld, location.blockPos, 0);
                                }
                                this.drawStart = null;
                                this.lastTool = ChiselToolType.CHISEL;
                            }
                        }
                    } else {
                        VoxelBlob vx;
                        TileEntityBlockChiseled tebc;
                        TileEntity te = theWorld.func_175625_s(location.blockPos);
                        boolean isBitBlock = te instanceof TileEntityBlockChiseled;
                        boolean isBlockSupported = BlockBitInfo.supportsBlock(state);
                        if (!isBitBlock && !isBlockSupported && (tebc = ModUtil.getChiseledTileEntity(theWorld, location.blockPos, false)) != null && (vx = tebc.getBlob()).get(location.bitX, location.bitY, location.bitZ) != 0) {
                            isBitBlock = true;
                        }
                        if (theWorld.func_175623_d(location.blockPos) || isBitBlock || isBlockSupported) {
                            ChiselTypeIterator i = new ChiselTypeIterator(16, location.bitX, location.bitY, location.bitZ, region, chMode, mop.field_178784_b);
                            AxisAlignedBB bb = i.getBoundingBox(vb, isChisel);
                            this.drawSelectionBoundingBoxIfExists(bb, location.blockPos, player, partialTicks, false);
                            showBox = false;
                        } else if (isBit) {
                            VoxelBlob j = new VoxelBlob();
                            j.fill(1);
                            ChiselTypeIterator i = new ChiselTypeIterator(16, location.bitX, location.bitY, location.bitZ, j, chMode, mop.field_178784_b);
                            AxisAlignedBB bb = this.snapToSide(i.getBoundingBox(j, isChisel), mop.field_178784_b);
                            this.drawSelectionBoundingBoxIfExists(bb, location.blockPos, player, partialTicks, false);
                        }
                    }
                }
                if (!showBox) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private AxisAlignedBB snapToSide(AxisAlignedBB boundingBox, EnumFacing sideHit) {
        if (boundingBox != null) {
            switch (sideHit) {
                case DOWN: {
                    return AxisAlignedBB.func_178781_a((double)boundingBox.field_72340_a, (double)boundingBox.field_72338_b, (double)boundingBox.field_72339_c, (double)boundingBox.field_72336_d, (double)boundingBox.field_72338_b, (double)boundingBox.field_72334_f);
                }
                case EAST: {
                    return AxisAlignedBB.func_178781_a((double)boundingBox.field_72336_d, (double)boundingBox.field_72338_b, (double)boundingBox.field_72339_c, (double)boundingBox.field_72336_d, (double)boundingBox.field_72337_e, (double)boundingBox.field_72334_f);
                }
                case NORTH: {
                    return AxisAlignedBB.func_178781_a((double)boundingBox.field_72340_a, (double)boundingBox.field_72338_b, (double)boundingBox.field_72339_c, (double)boundingBox.field_72336_d, (double)boundingBox.field_72337_e, (double)boundingBox.field_72339_c);
                }
                case SOUTH: {
                    return AxisAlignedBB.func_178781_a((double)boundingBox.field_72340_a, (double)boundingBox.field_72338_b, (double)boundingBox.field_72334_f, (double)boundingBox.field_72336_d, (double)boundingBox.field_72337_e, (double)boundingBox.field_72334_f);
                }
                case UP: {
                    return AxisAlignedBB.func_178781_a((double)boundingBox.field_72340_a, (double)boundingBox.field_72337_e, (double)boundingBox.field_72339_c, (double)boundingBox.field_72336_d, (double)boundingBox.field_72337_e, (double)boundingBox.field_72334_f);
                }
                case WEST: {
                    return AxisAlignedBB.func_178781_a((double)boundingBox.field_72340_a, (double)boundingBox.field_72338_b, (double)boundingBox.field_72339_c, (double)boundingBox.field_72340_a, (double)boundingBox.field_72337_e, (double)boundingBox.field_72334_f);
                }
            }
        }
        return boundingBox;
    }

    private void drawSelectionBoundingBoxIfExists(AxisAlignedBB bb, BlockPos blockPos, EntityPlayer player, float partialTicks, boolean NormalBoundingBox) {
        if (bb != null) {
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            if (!NormalBoundingBox) {
                RenderGlobal.func_181561_a((AxisAlignedBB)bb.func_72314_b((double)0.002f, (double)0.002f, (double)0.002f).func_72317_d(-x + (double)blockPos.func_177958_n(), -y + (double)blockPos.func_177956_o(), -z + (double)blockPos.func_177952_p()));
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1f);
            RenderGlobal.func_181561_a((AxisAlignedBB)bb.func_72314_b((double)0.002f, (double)0.002f, (double)0.002f).func_72317_d(-x + (double)blockPos.func_177958_n(), -y + (double)blockPos.func_177956_o(), -z + (double)blockPos.func_177952_p()));
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawLast(RenderWorldLastEvent event) {
        ++this.lastRenderedFrame;
        if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = event.partialTicks;
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        World theWorld = player.field_70170_p;
        ItemStack currentItem = player.func_71045_bC();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (mop == null) {
            return;
        }
        if (ModUtil.isHoldingPattern((EntityPlayer)player)) {
            if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            IBlockState s = theWorld.func_180495_p(mop.func_178782_a());
            if (!(s.func_177230_c() instanceof BlockChiseled || BlockBitInfo.supportsBlock(s) || MCMultipartProxy.proxyMCMultiPart.isMultiPartTileEntity(theWorld, mop.func_178782_a()))) {
                return;
            }
            if (!currentItem.func_77942_o()) {
                return;
            }
            ItemStack item = ChiselsAndBits.getItems().itemNegativeprint.getPatternedItem(currentItem);
            if (!item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((EntityLivingBase)player, ModUtil.getItemRotation(currentItem));
            if (item != null) {
                Object cacheRef;
                TileEntityBlockChiseled tebc = ModUtil.getChiseledTileEntity(theWorld, mop.func_178782_a(), false);
                Object object = cacheRef = tebc != null ? tebc : s;
                if (cacheRef instanceof TileEntityBlockChiseled) {
                    cacheRef = ((TileEntityBlockChiseled)cacheRef).getBlobStateReference();
                }
                GlStateManager.func_179143_c((int)519);
                this.showGhost(currentItem, item, mop.func_178782_a(), (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, null, cacheRef);
                GlStateManager.func_179143_c((int)515);
            }
        } else if (ModUtil.isHoldingChiseledBlock((EntityPlayer)player)) {
            if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            ItemStack item = currentItem;
            if (!item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((EntityLivingBase)player, ModUtil.getItemRotation(item));
            BlockPos offset = mop.func_178782_a();
            if (player.func_70093_af()) {
                BitLocation bl = new BitLocation(mop, true, ChiselToolType.BIT);
                this.showGhost(currentItem, item, bl.blockPos, (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, new BlockPos(bl.bitX, bl.bitY, bl.bitZ), null);
            } else {
                TileEntityBlockChiseled tebc;
                boolean canMerge = false;
                if (currentItem.func_77942_o() && (tebc = ModUtil.getChiseledTileEntity(theWorld, offset, true)) != null) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(currentItem, (EntityLivingBase)player);
                    canMerge = tebc.canMerge(blob);
                }
                BlockPos newOffset = offset;
                Block block = theWorld.func_180495_p(newOffset).func_177230_c();
                if (!(canMerge || player.func_70093_af() || block.func_176200_f(theWorld, newOffset))) {
                    newOffset = offset.func_177972_a(mop.field_178784_b);
                }
                TileEntity newTarget = theWorld.func_175625_s(newOffset);
                if (theWorld.func_175623_d(newOffset) || theWorld.func_180495_p(newOffset).func_177230_c().func_176200_f(theWorld, newOffset) || newTarget instanceof TileEntityBlockChiseled || MCMultipartProxy.proxyMCMultiPart.isMultiPartTileEntity(theWorld, newOffset)) {
                    TileEntityBlockChiseled test = ModUtil.getChiseledTileEntity(theWorld, newOffset, false);
                    this.showGhost(currentItem, item, newOffset, (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, null, test == null ? null : test.getBlobStateReference());
                }
            }
        }
    }

    private void showGhost(ItemStack refItem, ItemStack item, BlockPos blockPos, EntityPlayer player, int rotationCount, double x, double y, double z, EnumFacing side, BlockPos partial, Object cacheRef) {
        IBakedModel baked;
        block10: {
            VoxelBlob blob;
            NBTBlobConverter c;
            block11: {
                VoxelBlob pattern;
                block13: {
                    block12: {
                        block9: {
                            baked = null;
                            if (this.previousCacheRef != cacheRef || !this.samePos(this.lastPos, blockPos) || this.previousItem != refItem || this.previousRotations != rotationCount || this.previousModel == null || !this.samePos(this.lastPartial, partial)) break block9;
                            baked = (IBakedModel)this.previousModel;
                            break block10;
                        }
                        int rotations = rotationCount;
                        this.previousItem = refItem;
                        this.previousRotations = rotations;
                        this.previousCacheRef = cacheRef;
                        this.lastPos = blockPos;
                        this.lastPartial = partial;
                        c = new NBTBlobConverter();
                        c.readChisleData(item.func_179543_a("BlockEntityTag", false));
                        blob = c.getBlob();
                        while (rotations-- > 0) {
                            blob = blob.spin(EnumFacing.Axis.Y);
                        }
                        this.modelBounds = blob.getBounds();
                        if (refItem.func_77973_b() != ChiselsAndBits.getItems().itemNegativeprint) break block11;
                        pattern = blob;
                        if (!(cacheRef instanceof VoxelBlobStateReference)) break block12;
                        blob = ((VoxelBlobStateReference)cacheRef).getVoxelBlob();
                        break block13;
                    }
                    if (!(cacheRef instanceof IBlockState)) break block11;
                    blob = new VoxelBlob();
                    blob.fill(Block.func_176210_f((IBlockState)((IBlockState)cacheRef)));
                }
                BitIterator it = new BitIterator();
                while (it.hasNext()) {
                    if (it.getNext(pattern) != 0) continue;
                    it.setNext(blob, 0);
                }
            }
            c.setBlob(blob);
            Block blk = Block.func_149634_a((Item)item.func_77973_b());
            ItemStack is = c.getItemStack(false);
            if (is == null || is.func_77973_b() == null) {
                this.isVisible = false;
            } else {
                baked = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(is);
                this.previousModel = baked;
                this.isVisible = refItem.func_77973_b() instanceof IPatternItem ? true : ItemBlockChiseled.tryPlaceBlockAt(blk, item, (EntityLivingBase)player, player.func_130014_f_(), blockPos, side, partial, false);
            }
        }
        if (!this.isVisible) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)blockPos.func_177958_n() - x), (double)((double)blockPos.func_177956_o() - y), (double)((double)blockPos.func_177952_p() - z));
        if (partial != null) {
            BlockPos t = ModUtil.getPartialOffset(side, partial, this.modelBounds);
            double fullScale = 0.0625;
            GlStateManager.func_179137_b((double)((double)t.func_177958_n() * 0.0625), (double)((double)t.func_177956_o() * 0.0625), (double)((double)t.func_177952_p() * 0.0625));
        }
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.renderModel(baked, player.field_70170_p, blockPos);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        this.renderModel(baked, player.field_70170_p, blockPos);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void renderQuads(WorldRenderer renderer, List<BakedQuad> quads, World worldObj, BlockPos blockPos) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int color = bakedquad.func_178211_c() == -1 ? -1426063361 : this.getTint(bakedquad.func_178211_c(), worldObj, blockPos);
            LightUtil.renderQuadColor((WorldRenderer)renderer, (BakedQuad)bakedquad, (int)color);
        }
    }

    private int getTint(int tintIndex, World worldObj, BlockPos blockPos) {
        return 0xAA000000 | ChiselsAndBits.getBlocks().getChiseledDefaultState().func_177230_c().func_180662_a((IBlockAccess)worldObj, blockPos, tintIndex);
    }

    private void renderModel(IBakedModel model, World worldObj, BlockPos blockPos) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(worldrenderer, model.func_177551_a(enumfacing), worldObj, blockPos);
        }
        this.renderQuads(worldrenderer, model.func_177550_a(), worldObj, blockPos);
        tessellator.func_78381_a();
    }

    private boolean samePos(BlockPos lastPartial2, BlockPos partial) {
        if (lastPartial2 == partial) {
            return true;
        }
        if (lastPartial2 == null || partial == null) {
            return false;
        }
        return partial.equals((Object)lastPartial2);
    }

    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public boolean addHitEffects(World world, MovingObjectPosition target, IBlockState state, EffectRenderer effectRenderer) {
        ItemStack hitWith = this.getPlayer().func_71045_bC();
        if (hitWith != null && (hitWith.func_77973_b() instanceof ItemChisel || hitWith.func_77973_b() instanceof ItemChiseledBit)) {
            return true;
        }
        BlockPos pos = target.func_178782_a();
        float boxOffset = 0.1f;
        AxisAlignedBB bb = world.func_180495_p(pos).func_177230_c().func_180646_a(world, pos);
        if (bb == null) {
            bb = AxisAlignedBB.func_178781_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
        }
        double x = RANDOM.nextDouble() * (bb.field_72336_d - bb.field_72340_a - (double)0.2f) + (double)0.1f + bb.field_72340_a;
        double y = RANDOM.nextDouble() * (bb.field_72337_e - bb.field_72338_b - (double)0.2f) + (double)0.1f + bb.field_72338_b;
        double z = RANDOM.nextDouble() * (bb.field_72334_f - bb.field_72339_c - (double)0.2f) + (double)0.1f + bb.field_72339_c;
        switch (target.field_178784_b) {
            case DOWN: {
                y = bb.field_72338_b - (double)0.1f;
                break;
            }
            case EAST: {
                x = bb.field_72336_d + (double)0.1f;
                break;
            }
            case NORTH: {
                z = bb.field_72339_c - (double)0.1f;
                break;
            }
            case SOUTH: {
                z = bb.field_72334_f + (double)0.1f;
                break;
            }
            case UP: {
                y = bb.field_72337_e + (double)0.1f;
                break;
            }
            case WEST: {
                x = bb.field_72340_a - (double)0.1f;
                break;
            }
        }
        EntityFX fx = effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        if (fx != null) {
            fx.func_70543_e(0.2f).func_70541_f(0.6f);
        }
        return true;
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent me) {
        if (me.isCanceled() || me.dwheel == 0) {
            return;
        }
        EntityPlayer player = instance.getPlayer();
        ItemStack is = player.func_70694_bm();
        if (me.dwheel != 0 && is != null && is.func_77973_b() instanceof IItemScrollWheel && player.func_70093_af()) {
            ((IItemScrollWheel)is.func_77973_b()).scroll(player, is, me.dwheel);
            me.setCanceled(true);
        }
    }

    public static void placeSound(World world, BlockPos pos, int stateID) {
        IBlockState state = Block.func_176220_d((int)stateID);
        Block block = state.func_177230_c();
        world.func_72980_b((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 16.0f, block.field_149762_H.func_150494_d() * 0.9f, false);
    }

    public static void breakSound(World world, BlockPos pos, int extractedState) {
        IBlockState state = Block.func_176220_d((int)extractedState);
        Block block = state.func_177230_c();
        world.func_72980_b((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 16.0f, block.field_149762_H.func_150494_d() * 0.9f, false);
    }

    public int getLastRenderedFrame() {
        return this.lastRenderedFrame;
    }

    public BitLocation getStartPos() {
        return this.drawStart;
    }

    public void pointAt(ChiselToolType type, BitLocation pos) {
        if (this.drawStart == null) {
            this.drawStart = pos;
            this.lastTool = type;
        }
    }

    KeyBinding getToolKey() {
        if (this.lastTool == ChiselToolType.CHISEL) {
            return Minecraft.func_71410_x().field_71474_y.field_74312_F;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74313_G;
    }

    public boolean addBlockDestroyEffects(World world, BlockPos pos, IBlockState state, EffectRenderer effectRenderer) {
        if (!state.func_177230_c().isAir((IBlockAccess)world, pos)) {
            state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
            int StateID = Block.func_176210_f((IBlockState)state);
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{StateID});
                    }
                }
            }
        }
        return true;
    }

    public TextureAtlasSprite getMissingIcon() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public String getModeKey() {
        return GameSettings.func_74298_c((int)this.modeMenu.func_151463_i()).replace("LMENU", LocalStrings.leftAlt.getLocal()).replace("RMENU", LocalStrings.rightAlt.getLocal());
    }

    public ChiselToolType getDrawnTool() {
        return this.lastTool;
    }

    public boolean holdingShift() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }
}

