/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import mod.chiselsandbits.helpers.PlayerCopiedInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ActingPlayer {
    private final IInventory storage;
    private final EntityPlayer innerPlayer;
    private final boolean realPlayer;

    private ActingPlayer(EntityPlayer player, boolean realPlayer) {
        this.innerPlayer = player;
        this.realPlayer = realPlayer;
        this.storage = realPlayer ? player.field_71071_by : new PlayerCopiedInventory(player.field_71071_by);
    }

    public IInventory getInventory() {
        return this.storage;
    }

    public int getCurrentItem() {
        return this.innerPlayer.field_71071_by.field_70461_c;
    }

    public boolean isCreative() {
        return this.innerPlayer.field_71075_bZ.field_75098_d;
    }

    public ItemStack getCurrentEquippedItem() {
        return this.storage.func_70301_a(this.getCurrentItem());
    }

    public boolean canPlayerManipulate(BlockPos pos, EnumFacing side, ItemStack is) {
        return this.innerPlayer.func_175151_a(pos, side, is) && this.innerPlayer.field_70170_p.func_175660_a(this.innerPlayer, pos);
    }

    public void damageItem(ItemStack stack, int amount) {
        if (this.realPlayer) {
            stack.func_77972_a(amount, (EntityLivingBase)this.innerPlayer);
        } else {
            stack.func_77964_b(stack.func_77952_i() + amount);
        }
    }

    public void playerDestroyItem(ItemStack stack) {
        if (this.realPlayer) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.innerPlayer, (ItemStack)stack);
        }
    }

    public static ActingPlayer actingAs(EntityPlayer player) {
        return new ActingPlayer(player, true);
    }

    public static ActingPlayer testingAs(EntityPlayer player) {
        return new ActingPlayer(player, false);
    }

    public World getWorld() {
        return this.innerPlayer.field_70170_p;
    }

    public EntityPlayer getPlayer() {
        return this.innerPlayer;
    }

    public boolean isReal() {
        return this.realPlayer;
    }
}

