/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemNegativePrint;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemPositivePrint
extends ItemNegativePrint {
    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        this.defaultAddInfo(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpPositivePrint, tooltip, new String[0]);
        if (stack.func_77942_o()) {
            if (ClientSide.instance.holdingShift()) {
                if (this.toolTipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.toolTipCache.updateCachedValue(blob.listContents(new ArrayList<String>()));
                }
                tooltip.addAll((Collection)this.toolTipCache.getCached());
            } else {
                tooltip.add(LocalStrings.ShiftDetails.getLocal());
            }
        }
    }

    @Override
    protected NBTTagCompound getCompoundFromBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        Block blkObj = state.func_177230_c();
        if (!(blkObj instanceof BlockChiseled) && BlockBitInfo.supportsBlock(state)) {
            NBTBlobConverter tmp = new NBTBlobConverter();
            tmp.fillWith(state);
            NBTTagCompound comp = new NBTTagCompound();
            tmp.writeChisleData(comp, false);
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((EntityLivingBase)player).ordinal());
            return comp;
        }
        return super.getCompoundFromBlock(world, pos, player);
    }

    @Override
    protected boolean convertToStone() {
        return false;
    }

    @Override
    protected void applyPrint(World world, BlockPos pos, EnumFacing side, VoxelBlob vb, VoxelBlob pattern, EntityPlayer who) {
        ActingPlayer player = ActingPlayer.actingAs(who);
        ContinousChisels selected = new ContinousChisels(player, pos, side);
        ItemStack spawnedItem = null;
        VoxelBlob filled = new VoxelBlob();
        MCMultipartProxy.proxyMCMultiPart.addFiller(world, pos, filled);
        List<BagInventory> bags = ModUtil.getBags(player);
        ArrayList<EntityItem> spawnlist = new ArrayList<EntityItem>();
        for (int y = 0; y < vb.detail; ++y) {
            for (int z = 0; z < vb.detail; ++z) {
                for (int x = 0; x < vb.detail; ++x) {
                    int inPattern;
                    int inPlace = vb.get(x, y, z);
                    if (inPlace == (inPattern = pattern.get(x, y, z))) continue;
                    if (inPlace != 0 && selected.isValid() && (spawnedItem = ItemChisel.chiselBlock(selected, player, vb, world, pos, side, x, y, z, spawnedItem, spawnlist)) != null) {
                        inPlace = 0;
                    }
                    if (inPlace != 0 || inPattern == 0 || filled.get(x, y, z) != 0) continue;
                    ModUtil.ItemStackSlot bit = ModUtil.findBit(player, pos, inPattern);
                    if (ModUtil.consumeBagBit(bags, inPattern)) {
                        vb.set(x, y, z, inPattern);
                        continue;
                    }
                    if (!bit.isValid()) continue;
                    vb.set(x, y, z, inPattern);
                    if (player.isCreative()) continue;
                    bit.consume();
                }
            }
        }
        for (EntityItem ei : spawnlist) {
            ModUtil.feedPlayer(world, who, ei);
            ItemBitBag.cleanupInventory(who, ei.func_92059_d());
        }
    }
}

