/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.bit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.render.BaseBakedBlockModel;
import mod.chiselsandbits.render.helpers.ModelQuadLayer;
import mod.chiselsandbits.render.helpers.ModelUtil;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import org.lwjgl.util.vector.Vector3f;

public class BitItemBaked
extends BaseBakedBlockModel {
    public static final float PIXELS_PER_BLOCK = 16.0f;
    private static final float BIT_BEGIN = 6.0f;
    private static final float BIT_END = 10.0f;
    final ArrayList<BakedQuad> generic = new ArrayList(6);

    public BitItemBaked(int BlockRef) {
        FaceBakery faceBakery = new FaceBakery();
        Vector3f to = new Vector3f(6.0f, 6.0f, 6.0f);
        Vector3f from = new Vector3f(10.0f, 10.0f, 10.0f);
        BlockPartRotation bpr = null;
        ModelRotation mr = ModelRotation.X0_Y0;
        for (EnumFacing myFace : EnumFacing.field_82609_l) {
            for (EnumWorldBlockLayer layer : EnumWorldBlockLayer.values()) {
                ModelQuadLayer[] layers = ModelUtil.getCachedFace(BlockRef, 0L, myFace, layer);
                if (layers == null || layers.length == 0) continue;
                for (ModelQuadLayer clayer : layers) {
                    Vector3f fromB;
                    Vector3f toB;
                    BlockFaceUV uv = new BlockFaceUV(this.getFaceUvs(myFace), 0);
                    BlockPartFace bpf = new BlockPartFace(myFace, 0, "", uv);
                    switch (myFace) {
                        case UP: {
                            toB = new Vector3f(to.x, from.y, to.z);
                            fromB = new Vector3f(from.x, from.y, from.z);
                            break;
                        }
                        case EAST: {
                            toB = new Vector3f(from.x, to.y, to.z);
                            fromB = new Vector3f(from.x, from.y, from.z);
                            break;
                        }
                        case NORTH: {
                            toB = new Vector3f(to.x, to.y, to.z);
                            fromB = new Vector3f(from.x, from.y, to.z);
                            break;
                        }
                        case SOUTH: {
                            toB = new Vector3f(to.x, to.y, from.z);
                            fromB = new Vector3f(from.x, from.y, from.z);
                            break;
                        }
                        case DOWN: {
                            toB = new Vector3f(to.x, to.y, to.z);
                            fromB = new Vector3f(from.x, to.y, from.z);
                            break;
                        }
                        case WEST: {
                            toB = new Vector3f(to.x, to.y, to.z);
                            fromB = new Vector3f(to.x, from.y, from.z);
                            break;
                        }
                        default: {
                            throw new NullPointerException();
                        }
                    }
                    this.generic.add(faceBakery.func_178414_a(toB, fromB, bpf, clayer.sprite, myFace, mr, bpr, false, true));
                }
            }
        }
        this.generic.trimToSize();
    }

    private float[] getFaceUvs(EnumFacing face) {
        float[] afloat;
        int from_x = 7;
        int from_y = 7;
        int from_z = 7;
        int to_x = 8;
        int to_y = 8;
        int to_z = 8;
        switch (face) {
            case UP: 
            case DOWN: {
                afloat = new float[]{7.0f, 7.0f, 8.0f, 8.0f};
                break;
            }
            case NORTH: 
            case SOUTH: {
                afloat = new float[]{7.0f, 8.0f, 8.0f, 9.0f};
                break;
            }
            case EAST: 
            case WEST: {
                afloat = new float[]{7.0f, 8.0f, 8.0f, 9.0f};
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        return afloat;
    }

    public List<BakedQuad> func_177551_a(EnumFacing side) {
        return Collections.emptyList();
    }

    public List<BakedQuad> func_177550_a() {
        return this.generic;
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientSide.instance.getMissingIcon();
    }
}

