/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import java.security.InvalidParameterException;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelType;
import net.minecraft.util.EnumWorldBlockLayer;

public enum ChiselLayer {
    SOLID(EnumWorldBlockLayer.SOLID, VoxelType.SOLID),
    SOLID_FLUID(EnumWorldBlockLayer.SOLID, VoxelType.FLUID),
    CUTOUT(EnumWorldBlockLayer.CUTOUT, null),
    CUTOUT_MIPPED(EnumWorldBlockLayer.CUTOUT_MIPPED, null),
    TRANSLUCENT(EnumWorldBlockLayer.TRANSLUCENT, null);

    public final EnumWorldBlockLayer layer;
    public final VoxelType type;

    private ChiselLayer(EnumWorldBlockLayer layer, VoxelType type) {
        this.layer = layer;
        this.type = type;
    }

    public boolean filter(VoxelBlob vb) {
        if (vb == null) {
            return false;
        }
        if (vb.filter(this.layer)) {
            if (this.type != null) {
                return vb.filterFluids(this.type == VoxelType.FLUID);
            }
            return true;
        }
        return false;
    }

    public static ChiselLayer fromLayer(EnumWorldBlockLayer layerInfo, boolean isFluid) {
        switch (layerInfo) {
            case CUTOUT: {
                return CUTOUT;
            }
            case CUTOUT_MIPPED: {
                return CUTOUT_MIPPED;
            }
            case SOLID: {
                return isFluid ? SOLID_FLUID : SOLID;
            }
            case TRANSLUCENT: {
                return TRANSLUCENT;
            }
        }
        throw new InvalidParameterException();
    }
}

