/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import mod.chiselsandbits.render.cache.InMemoryQuadCompressor;
import mod.chiselsandbits.render.chiseledblock.IFaceBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class ChiselsAndBitsBakedQuad
extends BakedQuad {
    private static InMemoryQuadCompressor inMemoryCompressor = new InMemoryQuadCompressor();
    public static final VertexFormat VERTEX_FORMAT = new VertexFormat();
    protected final float[][][] rawVertData;
    static int[] OPTIFINE_WORKAROUND;

    public void pipe(IVertexConsumer consumer) {
        VertexFormat format = VERTEX_FORMAT;
        int[] eMap = LightUtil.mapFormats((VertexFormat)consumer.getVertexFormat(), (VertexFormat)format);
        consumer.setQuadTint(this.func_178211_c());
        consumer.setQuadOrientation(this.func_178210_d());
        consumer.setQuadColored();
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().func_177345_h(); ++e) {
                if (eMap[e] != format.func_177345_h()) {
                    consumer.put(e, this.rawVertData[v][eMap[e]]);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public int[] func_178209_a() {
        VertexFormat format = DefaultVertexFormats.field_176599_b;
        int[] tmpData = new int[format.func_177338_f()];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < format.func_177345_h(); ++e) {
                LightUtil.pack((float[])this.rawVertData[v][e], (int[])tmpData, (VertexFormat)format, (int)v, (int)e);
            }
        }
        return tmpData;
    }

    public ChiselsAndBitsBakedQuad(float[][][] unpackedData, int tint, EnumFacing orientation) {
        super(OPTIFINE_WORKAROUND, tint, orientation);
        this.rawVertData = inMemoryCompressor.compress(unpackedData);
    }

    static {
        for (VertexFormatElement element : DefaultVertexFormats.field_176599_b.func_177343_g()) {
            VERTEX_FORMAT.func_181721_a(element);
        }
        VERTEX_FORMAT.func_181721_a(DefaultVertexFormats.field_181716_p);
        OPTIFINE_WORKAROUND = new int[1];
    }

    public static class Builder
    implements IVertexConsumer,
    IFaceBuilder {
        private float[][][] unpackedData;
        private int tint = -1;
        private EnumFacing orientation;
        private boolean isColored = false;
        private int vertices = 0;
        private int elements = 0;

        public VertexFormat getVertexFormat() {
            return VERTEX_FORMAT;
        }

        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.orientation = orientation;
        }

        public void setQuadColored() {
            this.isColored = true;
        }

        @Override
        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.getVertexFormat().func_177345_h()) {
                ++this.vertices;
                this.elements = 0;
            }
        }

        @Override
        public void begin(VertexFormat format) {
            if (format != this.getVertexFormat()) {
                throw new RuntimeException("Bad format, can only be CNB.");
            }
            this.unpackedData = new float[4][this.getVertexFormat().func_177345_h()][4];
            this.tint = -1;
            this.orientation = null;
            this.vertices = 0;
            this.elements = 0;
        }

        @Override
        public BakedQuad create() {
            if (this.isColored) {
                return new Colored(this.unpackedData, this.tint, this.orientation);
            }
            return new ChiselsAndBitsBakedQuad(this.unpackedData, this.tint, this.orientation);
        }

        @Override
        public void setFace(EnumFacing myFace, int tintIndex) {
            this.setQuadColored();
            this.setQuadOrientation(myFace);
            this.setQuadTint(tintIndex);
        }
    }

    public static class Colored
    extends ChiselsAndBitsBakedQuad {
        public Colored(float[][][] unpackedData, int tint, EnumFacing orientation) {
            super(unpackedData, tint, orientation);
        }
    }
}

