/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock.tesr;

import java.util.List;
import mod.chiselsandbits.chiseledblock.EnumTESRRenderState;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.render.chiseledblock.tesr.TileLayerRenderCache;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.MinecraftForgeClient;

public abstract class TileRenderCache {
    private final TileLayerRenderCache solid = new TileLayerRenderCache();
    private final TileLayerRenderCache translucent = new TileLayerRenderCache();

    public TileLayerRenderCache getLayer(EnumWorldBlockLayer layer) {
        if (layer == EnumWorldBlockLayer.TRANSLUCENT) {
            return this.translucent;
        }
        return this.solid;
    }

    public abstract List<TileEntityBlockChiseledTESR> getTiles();

    public EnumTESRRenderState update(EnumWorldBlockLayer layer, int updateCost) {
        int lastRF = ClientSide.instance.getLastRenderedFrame();
        TileLayerRenderCache tlrc = this.getLayer(layer);
        if (layer != null && tlrc.lastRenderedFrame != lastRF) {
            tlrc.lastRenderedFrame = lastRF;
            return EnumTESRRenderState.RENDER;
        }
        return EnumTESRRenderState.SKIP;
    }

    public boolean hasRenderedThisFrame() {
        EnumWorldBlockLayer layer = MinecraftForgeClient.getRenderPass() == 0 ? EnumWorldBlockLayer.SOLID : EnumWorldBlockLayer.TRANSLUCENT;
        TileLayerRenderCache tlrc = this.getLayer(layer);
        int lastRF = ClientSide.instance.getLastRenderedFrame();
        return layer == null || tlrc.lastRenderedFrame == lastRF;
    }

    public void rebuild(boolean convert) {
        this.solid.rebuild = true;
        this.translucent.rebuild = true;
        if (convert) {
            this.solid.conversion = true;
            this.translucent.conversion = true;
        }
    }
}

