/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.render.helpers.ModelQuadLayer;
import mod.chiselsandbits.render.helpers.ModelUVAverager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.fluids.Fluid;

public class ModelUtil
implements ICacheClearable {
    private static final Random RANDOM = new Random();
    private static final HashMap<Integer, String>[] blockToTexture;
    private static HashMap<Integer, ModelQuadLayer[]> cache;
    private static ModelUtil instance;

    @Override
    public void clearCache() {
        for (int x = 0; x < blockToTexture.length; ++x) {
            blockToTexture[x].clear();
        }
        cache.clear();
    }

    public static ModelQuadLayer[] getCachedFace(int stateID, long weight, EnumFacing face, EnumWorldBlockLayer layer) {
        int cacheVal = stateID << 4 | face.ordinal();
        ModelQuadLayer[] mpc = cache.get(cacheVal);
        if (mpc != null) {
            return mpc;
        }
        IBlockState state = Block.func_176220_d((int)stateID);
        IBakedModel model = ModelUtil.solveModel(stateID, weight, Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state));
        Fluid fluid = BlockBitInfo.getFluidFromBlock(state.func_177230_c());
        if (fluid != null) {
            for (EnumFacing xf : EnumFacing.field_82609_l) {
                ModelQuadLayer[] mp = new ModelQuadLayer[]{new ModelQuadLayer()};
                mp[0].color = fluid.getColor();
                mp[0].light = state.func_177230_c().func_149750_m();
                float V = 0.5f;
                float Uf = 1.0f;
                float U = 0.5f;
                float Vf = 1.0f;
                if (xf.func_176740_k() == EnumFacing.Axis.Y) {
                    mp[0].sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
                    mp[0].uvs = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
                } else if (xf.func_176740_k() == EnumFacing.Axis.X) {
                    mp[0].sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFlowing().toString());
                    mp[0].uvs = new float[]{0.5f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f};
                } else {
                    mp[0].sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFlowing().toString());
                    mp[0].uvs = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.5f};
                }
                mp[0].tint = 0;
                int cacheV = stateID << 4 | xf.ordinal();
                cache.put(cacheV, mp);
            }
            return cache.get(cacheVal);
        }
        HashMap<EnumFacing, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>> tmp = new HashMap<EnumFacing, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>>();
        int color = BlockBitInfo.getColorFor(state, layer == EnumWorldBlockLayer.SOLID ? 0 : 1);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            tmp.put(f, new ArrayList());
        }
        if (model != null) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                List quads = model.func_177551_a(f);
                ModelUtil.processFaces(tmp, quads);
            }
            ModelUtil.processFaces(tmp, model.func_177550_a());
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            int cacheV = stateID << 4 | f.ordinal();
            ArrayList<ModelQuadLayer.ModelQuadLayerBuilder> x = tmp.get(f);
            ModelQuadLayer[] mp = new ModelQuadLayer[x.size()];
            for (int z = 0; z < x.size(); ++z) {
                mp[z] = x.get(z).build(stateID, color, state.func_177230_c().func_149750_m(), state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() instanceof BlockLeavesBase);
            }
            cache.put(cacheV, mp);
        }
        return cache.get(cacheVal);
    }

    private static void processFaces(HashMap<EnumFacing, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>> tmp, List<BakedQuad> quads) {
        for (BakedQuad q : quads) {
            EnumFacing face = q.func_178210_d();
            if (face == null) continue;
            try {
                TextureAtlasSprite sprite = ModelUtil.findQuadTexture(q);
                ArrayList<ModelQuadLayer.ModelQuadLayerBuilder> l = tmp.get(face);
                ModelQuadLayer.ModelQuadLayerBuilder b = null;
                for (ModelQuadLayer.ModelQuadLayerBuilder lx : l) {
                    if (lx.cache.sprite != sprite) continue;
                    b = lx;
                    break;
                }
                if (b == null) {
                    int uCoord = 0;
                    int vCoord = 2;
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            uCoord = 0;
                            vCoord = 1;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            uCoord = 1;
                            vCoord = 2;
                            break;
                        }
                    }
                    b = new ModelQuadLayer.ModelQuadLayerBuilder(sprite, uCoord, vCoord);
                    b.cache.tint = q.func_178211_c();
                    l.add(b);
                }
                q.pipe((IVertexConsumer)b.uvr);
                q.pipe((IVertexConsumer)b.lv);
            }
            catch (Exception exception) {}
        }
    }

    private ModelUtil() {
        ChiselsAndBits.getInstance().addClearable(this);
    }

    public static TextureAtlasSprite findQuadTexture(BakedQuad q) throws IllegalArgumentException, IllegalAccessException, NullPointerException {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        Map<String, TextureAtlasSprite> mapRegisteredSprites = ReflectionWrapper.instance.getRegSprite(map);
        if (mapRegisteredSprites == null) {
            throw new RuntimeException("Unable to lookup textures.");
        }
        ModelUVAverager av = new ModelUVAverager();
        q.pipe((IVertexConsumer)av);
        float U = av.getU();
        float V = av.getV();
        for (TextureAtlasSprite sprite : mapRegisteredSprites.values()) {
            if (!(sprite.func_94209_e() <= U) || !(U <= sprite.func_94212_f()) || !(sprite.func_94206_g() <= V) || !(V <= sprite.func_94210_h())) continue;
            return sprite;
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public static IBakedModel solveModel(int BlockRef, long weight, IBakedModel originalModel) {
        ItemStack stack;
        IBakedModel actingModel = originalModel;
        IBlockState state = Block.func_176220_d((int)BlockRef);
        try {
            if (actingModel != null && ChiselsAndBits.getConfig().allowBlockAlternatives && actingModel instanceof WeightedBakedModel) {
                actingModel = ((WeightedBakedModel)actingModel).func_177564_a(weight);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (actingModel instanceof ISmartBlockModel && (stack = ModUtil.getItemFromBlock(state)) != null) {
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        }
        return actingModel;
    }

    public static TextureAtlasSprite findTexture(int BlockRef, IBakedModel model, EnumFacing myFace, EnumWorldBlockLayer layer) {
        int blockToWork = layer.ordinal() * EnumFacing.field_82609_l.length + myFace.ordinal();
        if (blockToTexture[blockToWork].containsKey(BlockRef)) {
            String textureName = blockToTexture[blockToWork].get(BlockRef);
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(textureName);
        }
        TextureAtlasSprite texture = null;
        if (model != null) {
            try {
                texture = ModelUtil.findTexture(texture, model.func_177551_a(myFace), myFace);
                if (texture == null) {
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        texture = ModelUtil.findTexture(texture, model.func_177551_a(side), side);
                    }
                    texture = ModelUtil.findTexture(texture, model.func_177550_a(), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            try {
                if (texture == null) {
                    texture = model.func_177554_e();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        blockToTexture[blockToWork].put(BlockRef, texture.func_94215_i());
        return texture;
    }

    private static TextureAtlasSprite findTexture(TextureAtlasSprite texture, List<BakedQuad> faceQuads, EnumFacing myFace) throws IllegalArgumentException, IllegalAccessException, NullPointerException {
        for (BakedQuad q : faceQuads) {
            if (q.func_178210_d() != myFace) continue;
            texture = ModelUtil.findQuadTexture(q);
        }
        return texture;
    }

    public static boolean isOne(float v) {
        return (double)Math.abs(v) < 0.01;
    }

    public static boolean isZero(float v) {
        return (double)Math.abs(v - 1.0f) < 0.01;
    }

    static {
        cache = new HashMap();
        instance = new ModelUtil();
        blockToTexture = new HashMap[EnumFacing.field_82609_l.length * EnumWorldBlockLayer.values().length];
        for (int x = 0; x < blockToTexture.length; ++x) {
            ModelUtil.blockToTexture[x] = new HashMap();
        }
    }
}

