/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.Collection;
import java.util.Collections;
import mod.chiselsandbits.api.EventFullBlockRestoration;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.BoxType;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.data.VoxelNeighborRenderTracker;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.interfaces.IChiseledTileContainer;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockRenderChunkTESR;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBlockChiseled
extends TileEntity
implements IChiseledTileContainer {
    private IExtendedBlockState state;
    public IChiseledTileContainer occlusionState;
    boolean isNormalCube = false;
    int sideState = 0;
    int lightlevel = 0;
    private ItemStackGeneratedCache pickcache = null;

    public IChiseledTileContainer getTileContainer() {
        if (this.occlusionState != null) {
            return this.occlusionState;
        }
        return this;
    }

    @Override
    public boolean isBlobOccluded(VoxelBlob blob) {
        return false;
    }

    @Override
    public void saveData() {
        super.func_70296_d();
    }

    @Override
    public void sendUpdate() {
        ModUtil.sendUpdate(this.field_145850_b, this.field_174879_c);
    }

    public void copyFrom(TileEntityBlockChiseled src) {
        this.state = src.state;
        this.isNormalCube = src.isNormalCube;
        this.sideState = src.sideState;
        this.lightlevel = src.lightlevel;
    }

    public IExtendedBlockState getBasicState() {
        return this.getState(false, 0);
    }

    public IExtendedBlockState getRenderState() {
        return this.getState(true, 1);
    }

    protected IExtendedBlockState getState(boolean updateNeightbors, int updateCost) {
        if (this.state == null) {
            return (IExtendedBlockState)ChiselsAndBits.getBlocks().getChiseledDefaultState();
        }
        if (updateNeightbors) {
            boolean isDyanmic = this instanceof TileEntityBlockChiseledTESR;
            VoxelNeighborRenderTracker vns = (VoxelNeighborRenderTracker)this.state.getValue(BlockChiseled.UProperty_VoxelNeighborState);
            if (vns == null) {
                return this.state;
            }
            vns.update(isDyanmic, this.field_145850_b, this.field_174879_c);
            this.tesrUpdate(vns);
            final TileEntityBlockChiseled self = this;
            if (vns.isAboveLimit() && !isDyanmic) {
                ChisledBlockRenderChunkTESR.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (self.field_145850_b != null && self.field_174879_c != null) {
                            TileEntity current = self.field_145850_b.func_175625_s(self.field_174879_c);
                            if (current == self) {
                                TileEntityBlockChiseledTESR TESR = new TileEntityBlockChiseledTESR();
                                TESR.copyFrom(self);
                                self.field_145850_b.func_175690_a(self.field_174879_c, (TileEntity)TESR);
                                self.field_145850_b.func_175704_b(self.field_174879_c, self.field_174879_c);
                            } else {
                                MCMultipartProxy.proxyMCMultiPart.convertTo(current, new TileEntityBlockChiseledTESR());
                            }
                        }
                    }
                });
            } else if (!vns.isAboveLimit() && isDyanmic) {
                ChisledBlockRenderChunkTESR.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (self.field_145850_b != null && self.field_174879_c != null) {
                            TileEntity current = self.field_145850_b.func_175625_s(self.field_174879_c);
                            if (current == self) {
                                TileEntityBlockChiseled nonTesr = new TileEntityBlockChiseled();
                                nonTesr.copyFrom(self);
                                self.field_145850_b.func_175690_a(self.field_174879_c, (TileEntity)nonTesr);
                                self.field_145850_b.func_175704_b(self.field_174879_c, self.field_174879_c);
                            } else {
                                MCMultipartProxy.proxyMCMultiPart.convertTo(current, new TileEntityBlockChiseled());
                            }
                        }
                    }
                });
            }
        }
        return this.state;
    }

    protected void tesrUpdate(VoxelNeighborRenderTracker vns) {
    }

    public BlockBitInfo getBlockInfo(Block alternative) {
        return BlockBitInfo.getBlockInfo(this.getBlockState(alternative));
    }

    public IBlockState getBlockState(Block alternative) {
        IBlockState state;
        Integer stateID = (Integer)this.getBasicState().getValue(BlockChiseled.UProperty_Primary_BlockState);
        if (stateID != null && (state = Block.func_176220_d((int)stateID)) != null) {
            return state;
        }
        return alternative.func_176223_P();
    }

    public void setState(IExtendedBlockState state) {
        this.state = state;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeChisleData(nbttagcompound);
        if (nbttagcompound.func_82582_d()) {
            return null;
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 255, nbttagcompound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readChisleData(pkt.func_148857_g());
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public void readChisleData(NBTTagCompound tag) {
        new NBTBlobConverter(false, this).readChisleData(tag);
        VoxelNeighborRenderTracker vns = (VoxelNeighborRenderTracker)this.state.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        if (vns != null) {
            vns.triggerUpdate();
        }
    }

    public void writeChisleData(NBTTagCompound tag) {
        new NBTBlobConverter(false, this).writeChisleData(tag, false);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeChisleData(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readChisleData(compound);
    }

    public void fillWith(IBlockState blockType) {
        int ref = Block.func_176210_f((IBlockState)blockType);
        this.sideState = 255;
        this.lightlevel = DeprecationHelper.getLightValue(blockType);
        this.isNormalCube = ModUtil.isNormalCube(blockType);
        IExtendedBlockState state = this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(Block.func_176210_f((IBlockState)blockType), this.getPositionRandom(this.field_174879_c)));
        VoxelNeighborRenderTracker tracker = (VoxelNeighborRenderTracker)state.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        if (tracker == null) {
            state = state.withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker());
        } else {
            tracker.isDynamic();
        }
        if (ref != 0) {
            state = state.withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)ref);
        }
        this.setState(state);
        this.getTileContainer().saveData();
    }

    private long getPositionRandom(BlockPos pos) {
        if (pos != null && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return MathHelper.func_180186_a((Vec3i)pos);
        }
        return 0L;
    }

    public VoxelBlobStateReference getBlobStateReference() {
        return (VoxelBlobStateReference)this.getBasicState().getValue(BlockChiseled.UProperty_VoxelBlob);
    }

    public VoxelBlob getBlob() {
        VoxelBlob vb = null;
        VoxelBlobStateReference vbs = this.getBlobStateReference();
        if (vbs != null) {
            vb = vbs.getVoxelBlob();
            if (vb == null) {
                vb = new VoxelBlob();
                vb.fill(Block.func_176210_f((IBlockState)Blocks.field_150347_e.func_176223_P()));
            }
        } else {
            vb = new VoxelBlob();
        }
        return vb;
    }

    public IBlockState getPreferedBlock() {
        return ChiselsAndBits.getBlocks().getConversionWithDefault(this.getBlockState(Blocks.field_150348_b)).func_176223_P();
    }

    public void setBlob(VoxelBlob vb) {
        this.setBlob(vb, true);
    }

    public void updateBlob(NBTBlobConverter converter, boolean triggerUpdates) {
        int oldLV = this.getLightValue();
        boolean oldNC = this.isNormalCube();
        int oldSides = this.sideState;
        this.sideState = converter.getSideState();
        int b = converter.getPrimaryBlockStateID();
        this.lightlevel = converter.getLightValue();
        this.isNormalCube = converter.isNormalCube();
        VoxelBlobStateReference voxelRef = converter.getVoxelRef(VoxelBlob.VERSION_COMPACT, this.getPositionRandom(this.field_174879_c));
        IExtendedBlockState newstate = this.getBasicState().withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)b).withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)voxelRef);
        VoxelNeighborRenderTracker tracker = (VoxelNeighborRenderTracker)newstate.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        if (tracker == null) {
            newstate = newstate.withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker());
        } else {
            tracker.isDynamic();
        }
        this.setState(newstate);
        if (this.func_145830_o() && triggerUpdates) {
            if (oldLV != this.getLightValue() || oldNC != this.isNormalCube()) {
                this.field_145850_b.func_175664_x(this.field_174879_c);
            }
            if (oldSides != this.sideState) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
        }
    }

    public void setBlob(VoxelBlob vb, boolean triggerUpdates) {
        Integer olv = this.getLightValue();
        Boolean oldNC = this.isNormalCube();
        VoxelBlob.BlobStats common = vb.getVoxelStats();
        float light = common.blockLight;
        boolean nc = common.isNormalBlock;
        int lv = Math.max(0, Math.min(15, (int)(light * 15.0f)));
        int sideFlags = vb.getSideFlags(5, 11, 16);
        if (this.field_145850_b == null) {
            if (common.mostCommonState == 0) {
                common.mostCommonState = (Integer)this.getBasicState().getValue(BlockChiseled.UProperty_Primary_BlockState);
            }
            this.sideState = sideFlags;
            this.lightlevel = lv;
            this.isNormalCube = nc;
            IExtendedBlockState newState = this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(vb.blobToBytes(VoxelBlob.VERSION_COMPACT), this.getPositionRandom(this.field_174879_c))).withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker()).withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)common.mostCommonState);
            VoxelNeighborRenderTracker tracker = (VoxelNeighborRenderTracker)newState.getValue(BlockChiseled.UProperty_VoxelNeighborState);
            if (tracker == null) {
                newState = newState.withProperty(BlockChiseled.UProperty_VoxelNeighborState, (Object)new VoxelNeighborRenderTracker());
            } else {
                tracker.isDynamic();
            }
            this.setState(newState);
            return;
        }
        if (common.isFullBlock) {
            this.setState(this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(common.mostCommonState, this.getPositionRandom(this.field_174879_c))));
            IBlockState newState = Block.func_176220_d((int)common.mostCommonState);
            if (!MinecraftForge.EVENT_BUS.post((Event)new EventFullBlockRestoration(this.field_145850_b, this.field_174879_c, newState))) {
                this.field_145850_b.func_180501_a(this.field_174879_c, newState, triggerUpdates ? 3 : 0);
            }
        } else if (common.mostCommonState != 0) {
            this.sideState = sideFlags;
            this.lightlevel = lv;
            this.isNormalCube = nc;
            this.setState(this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(vb.blobToBytes(VoxelBlob.VERSION_COMPACT), this.getPositionRandom(this.field_174879_c))).withProperty(BlockChiseled.UProperty_Primary_BlockState, (Object)common.mostCommonState));
            this.getTileContainer().saveData();
            this.getTileContainer().sendUpdate();
            Block blk = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            MCMultipartProxy.proxyMCMultiPart.triggerPartChange(this.field_145850_b.func_175625_s(this.field_174879_c));
            this.field_145850_b.func_180496_d(this.field_174879_c, blk);
            if (triggerUpdates) {
                this.field_145850_b.func_175685_c(this.field_174879_c, blk);
            }
        } else {
            this.setState(this.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)new VoxelBlobStateReference(0, this.getPositionRandom(this.field_174879_c))));
            ModUtil.removeChisledBlock(this.field_145850_b, this.field_174879_c);
        }
        if (olv != lv || oldNC != nc) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    public ItemStack getItemStack(EntityPlayer player) {
        ItemStackGeneratedCache cache = this.pickcache;
        if (player != null) {
            EnumFacing enumfacing = ModUtil.getPlaceFace((EntityLivingBase)player);
            int rotations = ModUtil.getRotationIndex(enumfacing);
            if (cache != null && cache.rotations == rotations && cache.ref == this.getBlobStateReference() && cache.out != null) {
                return cache.out.func_77946_l();
            }
            VoxelBlob vb = this.getBlob();
            int countDown = rotations;
            while (countDown > 0) {
                --countDown;
                enumfacing = enumfacing.func_176735_f();
                vb = vb.spin(EnumFacing.Axis.Y);
            }
            BitAccess ba = new BitAccess(null, null, vb, VoxelBlob.NULL_BLOB);
            ItemStack itemstack = ba.getBitsAsItem(enumfacing, ItemType.CHISLED_BLOCK, false);
            this.pickcache = new ItemStackGeneratedCache(itemstack, this.getBlobStateReference(), rotations);
            return itemstack;
        }
        if (cache != null && cache.rotations == 0 && cache.ref == this.getBlobStateReference()) {
            return cache.out.func_77946_l();
        }
        BitAccess ba = new BitAccess(null, null, this.getBlob(), VoxelBlob.NULL_BLOB);
        ItemStack itemstack = ba.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
        this.pickcache = new ItemStackGeneratedCache(itemstack, this.getBlobStateReference(), 0);
        return itemstack;
    }

    public boolean isNormalCube() {
        return this.isNormalCube;
    }

    public boolean isSideSolid(EnumFacing side) {
        return (this.sideState & 1 << side.ordinal()) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSideOpaque(EnumFacing side) {
        Integer sideFlags = ChiseledBlockSmartModel.getSides(this);
        return (sideFlags & 1 << side.ordinal()) != 0;
    }

    public void completeEditOperation(VoxelBlob vb) {
        VoxelBlobStateReference before = this.getBlobStateReference();
        this.setBlob(vb);
        VoxelBlobStateReference after = this.getBlobStateReference();
        UndoTracker.getInstance().add(this.func_145831_w(), this.func_174877_v(), before, after);
    }

    public void rotateBlock(EnumFacing axis) {
        VoxelBlob occluded = new VoxelBlob();
        MCMultipartProxy.proxyMCMultiPart.addFiller(this.func_145831_w(), this.func_174877_v(), occluded);
        VoxelBlob postRotation = this.getBlob();
        int maxRotations = 4;
        while (--maxRotations > 0) {
            if (!occluded.canMerge(postRotation = postRotation.spin(axis.func_176740_k()))) continue;
            this.setBlob(postRotation);
            return;
        }
    }

    public boolean canMerge(VoxelBlob voxelBlob) {
        VoxelBlob vb = this.getBlob();
        IChiseledTileContainer occ = this.getTileContainer();
        return vb.canMerge(voxelBlob) && !occ.isBlobOccluded(voxelBlob);
    }

    public Collection<AxisAlignedBB> getBoxes(BoxType type) {
        VoxelBlobStateReference ref = this.getBlobStateReference();
        if (ref != null) {
            return ref.getBoxes(type);
        }
        return Collections.emptyList();
    }

    public void setNormalCube(boolean b) {
        this.isNormalCube = b;
    }

    public int getLightValue() {
        return this.lightlevel;
    }

    private static class ItemStackGeneratedCache {
        final ItemStack out;
        final VoxelBlobStateReference ref;
        final int rotations;

        public ItemStackGeneratedCache(ItemStack itemstack, VoxelBlobStateReference blobStateReference, int rotations2) {
            this.out = itemstack == null ? null : itemstack.func_77946_l();
            this.ref = blobStateReference;
            this.rotations = rotations2;
        }
    }
}

