/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import java.lang.ref.WeakReference;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.render.chiseledblock.ModelRenderState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class VoxelNeighborRenderTracker {
    private WeakReference<VoxelBlobStateReference> lastCenter;
    private ModelRenderState lrs = null;
    private boolean isDynamic;
    private boolean shouldUpdate = false;
    Integer[] faceCount = new Integer[4];
    private final ModelRenderState sides = new ModelRenderState(null);

    public VoxelNeighborRenderTracker() {
        this.faceCount = new Integer[BlockRenderLayer.values().length];
    }

    public boolean isAboveLimit() {
        int faces = 0;
        for (int x = 0; x < this.faceCount.length; ++x) {
            if (this.faceCount[x] == null) {
                return false;
            }
            faces += this.faceCount[x].intValue();
        }
        return faces >= ChiselsAndBits.getConfig().dynamicModelFaceCount;
    }

    public void setAbovelimit(BlockRenderLayer layer, int fc) {
        this.faceCount[layer.ordinal()] = fc;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void update(boolean isDynamic, World worldObj, BlockPos pos) {
        if (worldObj == null || pos == null) {
            return;
        }
        this.isDynamic = isDynamic;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileEntityBlockChiseled tebc = ModUtil.getChiseledTileEntity(worldObj, pos.func_177972_a(f), false);
            if (tebc != null) {
                this.update(f, (VoxelBlobStateReference)tebc.getBasicState().getValue(BlockChiseled.UProperty_VoxelBlob));
                continue;
            }
            this.update(f, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(EnumFacing f, VoxelBlobStateReference value) {
        if (this.sides.get(f) == value) {
            return;
        }
        VoxelNeighborRenderTracker voxelNeighborRenderTracker = this;
        synchronized (voxelNeighborRenderTracker) {
            this.sides.put(f, value);
            this.lrs = null;
        }
    }

    public ModelRenderState getRenderState(VoxelBlobStateReference data) {
        if (this.lrs == null || this.lastCenter == null) {
            this.lrs = new ModelRenderState(this.sides);
            this.updateCenter(data);
        } else if (this.lastCenter.get() != data) {
            this.updateCenter(data);
            this.lrs = new ModelRenderState(this.sides);
        }
        return this.lrs;
    }

    private void updateCenter(VoxelBlobStateReference data) {
        this.lastCenter = new WeakReference<VoxelBlobStateReference>(data);
    }

    public void triggerUpdate() {
        this.shouldUpdate = true;
    }

    public boolean isShouldUpdate() {
        boolean res = this.shouldUpdate;
        this.shouldUpdate = false;
        return res;
    }
}

