/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core.api;

import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.core.api.IMCHandlerIgnoreLogic;
import mod.chiselsandbits.core.api.IMCHandlerMaterialEquivilancy;
import mod.chiselsandbits.core.api.IMCMessageHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    private final Map<String, IMCMessageHandler> processors = new HashMap<String, IMCMessageHandler>();

    public IMCHandler() {
        this.processors.put("ignoreblocklogic", new IMCHandlerIgnoreLogic());
        this.processors.put("materialequivilancy", new IMCHandlerMaterialEquivilancy());
    }

    public void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            this.executeIMC(message);
        }
    }

    private void executeIMC(FMLInterModComms.IMCMessage message) {
        IMCMessageHandler handler = this.processors.get(message.key);
        if (handler != null) {
            handler.excuteIMC(message);
        } else {
            Log.logError("Invalid IMC: " + message.key + " from " + message.getSender(), new RuntimeException("Invalid IMC Type."));
        }
    }
}

