/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Blocks;

import PegBeard.DungeonTactics.Handlers.DTBlocks;
import PegBeard.DungeonTactics.Handlers.DTCreativeTab;
import PegBeard.DungeonTactics.Items.DTKnife;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DTFlower
extends BlockBush {
    public DTFlower(String name) {
        super(Material.field_151585_k);
        this.func_149663_c("dungeontactics:" + name);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.2f);
        this.func_149647_a(DTCreativeTab.DT_TAB);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int rate = 25;
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b())) {
            rate = 15;
        }
        if (rand.nextInt(rate) == 0) {
            int i = 5;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (world.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (world.func_175623_d(blockpos1) && this.func_180671_f(world, blockpos1, this.func_176223_P())) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (world.func_175623_d(blockpos1) && this.func_180671_f(world, blockpos1, this.func_176223_P())) {
                world.func_180501_a(blockpos1, this.func_176223_P(), 2);
            }
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == Blocks.field_150391_bh || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150344_f || block == Blocks.field_150347_e || block == Blocks.field_150341_Y || block == Blocks.field_150348_b || block == Blocks.field_150417_aV || block == Blocks.field_150351_n || block == Blocks.field_150354_m || block == Blocks.field_150322_A || block == Blocks.field_150435_aG || block == Blocks.field_150336_V || block == Blocks.field_150405_ch || block == Blocks.field_150406_ce || block == Blocks.field_150377_bs || block == Blocks.field_150407_cf || block == Blocks.field_150424_aL || block == Blocks.field_150385_bj || block == Blocks.field_150425_aM || block == Blocks.field_150365_q || block == Blocks.field_150366_p || block == Blocks.field_150352_o || block == Blocks.field_150482_ag || block == Blocks.field_150369_x || block == Blocks.field_150450_ax || block == Blocks.field_150449_bY;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        float particleX = (float)pos.func_177958_n() + rand.nextFloat();
        float particleY = (float)pos.func_177956_o() + rand.nextFloat();
        float particleZ = (float)pos.func_177952_p() + rand.nextFloat();
        float motionX = rand.nextFloat() - 0.5f;
        float motionY = rand.nextFloat() - 0.5f;
        float motionZ = rand.nextFloat() - 0.5f;
        if (rand.nextInt(9) == 0) {
            if (this == DTBlocks.flowerCinder) {
                world.func_175688_a(EnumParticleTypes.FLAME, (double)particleX, (double)particleY, (double)particleZ, 0.0, 0.0, 0.0, new int[0]);
            } else if (this == DTBlocks.flowerFade) {
                world.func_175688_a(EnumParticleTypes.PORTAL, (double)particleX, (double)particleY, (double)particleZ, (double)motionX, (double)motionY, (double)motionZ, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)particleX, (double)particleY, (double)particleZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        super.func_180649_a(world, pos, player);
        if (!world.field_72995_K) {
            if (this == DTBlocks.flowerXp) {
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150458_ak) {
                    this.doEffect(world, pos, (Entity)player);
                    this.doTrample(world, pos);
                }
            } else {
                this.doEffect(world, pos, (Entity)player);
            }
        }
        if (player.func_184614_ca() != null && (player.func_184614_ca().func_77973_b() instanceof ItemShears || player.func_184614_ca().func_77973_b() instanceof ItemSword || player.func_184614_ca().func_77973_b() instanceof DTKnife)) {
            this.func_149711_c(0.0f);
        } else {
            this.func_149711_c(0.2f);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
        if (!world.field_72995_K) {
            if (this == DTBlocks.flowerXp) {
                ItemStack stack;
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150458_ak) {
                    this.doEffect(world, pos, (Entity)player);
                    this.doTrample(world, pos);
                }
                if ((stack = player.func_184586_b(hand)).func_77973_b() == Items.field_151069_bo) {
                    if (!player.func_184812_l_()) {
                        --stack.field_77994_a;
                        if (stack.field_77994_a == 0) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                    player.func_70099_a(new ItemStack(Items.field_151062_by), 1.0f);
                }
            } else {
                this.doEffect(world, pos, (Entity)player);
            }
        }
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (world.field_72995_K) {
                this.doParticles(world, pos);
            }
            if (!world.field_72995_K) {
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak) {
                    if (this != DTBlocks.flowerXp) {
                        this.doEffect(world, pos, entity);
                    }
                } else {
                    this.doEffect(world, pos, entity);
                    this.doTrample(world, pos);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, BlockPos pos) {
        Random rand = world.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + rand.nextFloat();
            double d2 = (float)pos.func_177956_o() + rand.nextFloat();
            double d3 = (float)pos.func_177952_p() + rand.nextFloat();
            if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !world.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !world.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            if (this == DTBlocks.flowerCinder) {
                world.func_175688_a(EnumParticleTypes.FLAME, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                continue;
            }
            if (this == DTBlocks.flowerFade) {
                for (int p = 0; p < 20; ++p) {
                    world.func_175688_a(EnumParticleTypes.PORTAL, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian(), new int[0]);
                }
                continue;
            }
            world.func_175688_a(EnumParticleTypes.CRIT_MAGIC, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void doEffect(World world, BlockPos pos, Entity entity) {
        EntityLivingBase entityL = (EntityLivingBase)entity;
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerSanguine) {
            entityL.func_70691_i(0.5f);
            entityL.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 0));
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerXp) {
            int j;
            for (int i = 3 + world.field_73012_v.nextInt(5) + world.field_73012_v.nextInt(5); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), j));
            }
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerBramble) {
            entityL.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerBark) {
            entityL.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, 0));
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerCinder) {
            entityL.func_70015_d(6);
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerTangle) {
            entityL.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 2));
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerAilment) {
            entityL.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 0));
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerFade) {
            if (entity.func_184218_aH()) {
                entity.func_184210_p();
            }
            if (entity.func_184207_aI()) {
                entity.func_184226_ay();
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70634_a(entity.field_70165_t + world.field_73012_v.nextGaussian() * 10.0, entity.field_70163_u + world.field_73012_v.nextGaussian() * 10.0, entity.field_70161_v + world.field_73012_v.nextGaussian() * 10.0);
                if (entity.field_70163_u <= 1.0) {
                    ((EntityPlayer)entity).func_70634_a(entity.field_70165_t, 3.0, entity.field_70161_v);
                }
            } else {
                entity.func_70634_a(entity.field_70165_t + world.field_73012_v.nextGaussian() * 10.0, entity.field_70163_u + world.field_73012_v.nextGaussian() * 10.0, entity.field_70161_v + world.field_73012_v.nextGaussian() * 10.0);
            }
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 0.9f);
        }
        if (world.func_180495_p(pos).func_177230_c() == DTBlocks.flowerFeather) {
            entityL.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 100, 0));
        }
    }

    public void doTrample(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int trample = world.field_73012_v.nextInt(5);
        if (trample < 2) {
            return;
        }
        if (trample == 2) {
            world.func_175698_g(pos);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 0.9f);
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.5f), (double)((float)pos.func_177952_p() + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian(), new int[]{Block.func_176210_f((IBlockState)state)});
            this.func_176226_b(world, pos, this.func_176223_P(), 0);
            return;
        }
        world.func_175698_g(pos);
        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 0.9f);
        world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.5f), (double)((float)pos.func_177952_p() + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian(), new int[]{Block.func_176210_f((IBlockState)state)});
    }
}

