/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Entities;

import PegBeard.DungeonTactics.DungeonTactics;
import PegBeard.DungeonTactics.Handlers.DTConfigHandler;
import PegBeard.DungeonTactics.Handlers.DTItems;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTowerGuardian
extends EntitySkeleton {
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, 0).func_111168_a(false);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityTowerGuardian.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private boolean isBreakDoorsTaskSet;
    private float guardianWidth = -1.0f;
    private float guardianHeight;
    private int angerLevel;
    private int randomSoundDelay;
    private UUID angerTargetUUID;
    int homeX = 0;
    int homeY = 0;
    int homeZ = 0;

    public EntityTowerGuardian(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.99f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityTowerGuardian.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySpider.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByAggressor(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AITargetAggressor(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.isAngry()) {
            if (!this.func_70631_g_() && !iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
            if (this.angerLevel <= 0) {
                this.removeChallengeAI();
            }
        } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_184185_a(SoundEvents.field_187854_fc, this.func_70599_aP() * 2.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.func_70643_av() == null) {
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            this.field_70717_bb = entityplayer;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    protected void applyChallengeAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void removeChallengeAI() {
        this.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (!player.func_130014_f_().field_72995_K) {
            if (stack != null && stack.func_77973_b() == Items.field_151104_aV && this.func_110175_bO() && !this.func_110173_bK()) {
                this.func_70634_a(this.func_180486_cf().func_177958_n(), this.func_180486_cf().func_177956_o(), this.func_180486_cf().func_177952_p());
                return true;
            }
            if (!(this.isAngry() || stack != null && stack.func_77973_b() instanceof ItemSword)) {
                if (DungeonTactics.samhain && DTConfigHandler.configuration.get("1-Feature", "E-Seasonal Events", true).getBoolean(true)) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Tower Guardian: Greetings and happy Samhain, Adventurer."));
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + player.func_70005_c_() + ": Trick or Treat?"));
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Tower Guardian: Explosions are treats, right?"));
                    player.func_70099_a(new ItemStack(DTItems.trickortreatBag), 1.0f);
                    return true;
                }
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Ready your weapon, Adventurer."));
                return true;
            }
            if (!this.isAngry() && stack != null && stack.func_77973_b() instanceof ItemSword) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "I accept your challenge, Mortal."));
                this.func_70604_c((EntityLivingBase)player);
                this.angerLevel = 2400;
                this.applyChallengeAI();
                return true;
            }
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public boolean isBreakDoorsTaskSet() {
        return this.isBreakDoorsTaskSet;
    }

    public void setBreakDoorsAItask(boolean enabled) {
        if (this.isBreakDoorsTaskSet != enabled) {
            this.isBreakDoorsTaskSet = enabled;
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
            if (enabled) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            }
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return super.func_70693_a(player);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        float f;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.shouldBurnInDay() && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (itemstack != null) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, null);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            if (this.angerLevel <= 0 && !this.func_130014_f_().field_72995_K) {
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "On guard, honourless Naive."));
            }
            this.func_70604_c((EntityLivingBase)entity);
            this.angerLevel = 2400;
            this.applyChallengeAI();
            if (amount > this.func_110143_aJ()) {
                if (this.func_110143_aJ() > 2.0f) {
                    amount = 1.0f;
                    this.func_70606_j(2.0f);
                } else if (this.func_110175_bO()) {
                    this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0);
                    List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
                    if (!list.isEmpty()) {
                        for (EntityPlayer player : list) {
                            player.func_70634_a((double)((float)this.getHome().func_177958_n() + 0.5f), (double)((float)this.getHome().func_177956_o() + 1.5f), (double)((float)this.getHome().func_177952_p() + 0.5f));
                            this.field_70170_p.func_184148_a((EntityPlayer)null, (double)this.getHome().func_177958_n(), (double)this.getHome().func_177956_o(), (double)this.getHome().func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                        }
                    }
                    this.func_70634_a((float)this.getHome().func_177958_n() + 0.5f, (float)this.getHome().func_177956_o() + 1.5f, (float)this.getHome().func_177952_p() + 0.5f);
                    this.clearRoom(this.func_130014_f_(), this.getHome());
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float d = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entityIn.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL || entityIn.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
            entityIn.func_70097_a(DamageSource.field_76376_m, d / 3.0f);
            entityIn.field_70172_ad = 0;
        }
        if (flag = super.func_70652_k(entityIn)) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca() == null && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    private void becomeAngryAt(Entity attacker) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        this.randomSoundDelay = this.field_70146_Z.nextInt(40);
        if (attacker instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)attacker);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187868_fj;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186385_aj;
    }

    public void func_180481_a(DifficultyInstance difficulty) {
        int e = this.field_70146_Z.nextInt(4);
        int w = this.field_70146_Z.nextInt(3);
        int q = this.field_70146_Z.nextInt(2);
        if (e == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(DTItems.gildedHelmet));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(DTItems.gildedChestplate));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(DTItems.gildedLeggings));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(DTItems.gildedBoots));
            if (w == 0) {
                if (q == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.gildedSword));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.gildedCutlass));
                }
            } else if (w == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.gildedHammer));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.gildedKnife));
            }
        } else if (e == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(DTItems.jewelledHelmet));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(DTItems.jewelledChestplate));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(DTItems.jewelledLeggings));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(DTItems.jewelledBoots));
            if (w == 0) {
                if (q == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.jewelledSword));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.jewelledCutlass));
                }
            } else if (w == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.jewelledHammer));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.jewelledKnife));
            }
        } else {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151165_aa));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151167_ab));
            if (w == 0) {
                if (q == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.ironCutlass));
                }
            } else if (w == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.ironHammer));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.ironKnife));
            }
        }
    }

    public static void registerFixesZombie(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, (String)"towerguardian");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("CanBreakDoors", this.isBreakDoorsTaskSet());
        compound.func_74777_a("Anger", (short)this.angerLevel);
        compound.func_74768_a("homeX", this.homeX);
        compound.func_74768_a("homeY", this.homeY);
        compound.func_74768_a("homeZ", this.homeZ);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBreakDoorsAItask(compound.func_74767_n("CanBreakDoors"));
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        this.homeX = compound.func_74762_e("homeX");
        this.homeY = compound.func_74762_e("homeY");
        this.homeZ = compound.func_74762_e("homeZ");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
    }

    public float func_70047_e() {
        return 1.74f;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(stack);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.setBreakDoorsAItask(this.field_70146_Z.nextFloat() < f * 0.1f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.setBreakDoorsAItask(true);
        }
        return livingdata;
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.guardianWidth > 0.0f && this.guardianHeight > 0.0f;
        this.guardianWidth = width;
        this.guardianHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.guardianWidth * size, this.guardianHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    protected ItemStack getSkullDrop() {
        return new ItemStack(Items.field_151144_bL, 1, 0);
    }

    public void setHome(BlockPos pos) {
        this.homeX = pos.func_177958_n();
        this.homeY = pos.func_177956_o();
        this.homeZ = pos.func_177952_p();
    }

    public BlockPos getHome() {
        BlockPos pos = new BlockPos(this.homeX, this.homeY, this.homeZ);
        return pos;
    }

    public boolean func_110175_bO() {
        return this.getHome().func_177958_n() != 0 && this.getHome().func_177956_o() != 0 && this.getHome().func_177952_p() != 0;
    }

    public boolean clearRoom(World world, BlockPos pos) {
        if (this.func_110175_bO()) {
            float y = world.func_72800_K() - 10;
            BlockPos buildPos = new BlockPos((double)pos.func_177958_n(), (double)y, (double)pos.func_177952_p()).func_177982_a(-9, 0, -9);
            for (int horX = 0; horX < 19; ++horX) {
                for (int horZ = 0; horZ < 19; ++horZ) {
                    for (int vert = 0; vert < 9; ++vert) {
                        world.func_175698_g(buildPos.func_177981_b(vert).func_177970_e(horZ).func_177965_g(horX));
                    }
                }
            }
            return true;
        }
        return false;
    }

    static class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AITargetAggressor(EntityTowerGuardian entityTowerGuardian) {
            super((EntityCreature)entityTowerGuardian, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return ((EntityTowerGuardian)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(EntityTowerGuardian p_i45828_1_) {
            super((EntityCreature)p_i45828_1_, true, new Class[0]);
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            super.func_179446_a(creatureIn, entityLivingBaseIn);
            if (creatureIn instanceof EntityTowerGuardian) {
                ((EntityTowerGuardian)creatureIn).becomeAngryAt((Entity)entityLivingBaseIn);
            }
        }
    }
}

