/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Items;

import PegBeard.DungeonTactics.Handlers.DTEffects;
import PegBeard.DungeonTactics.Items.DTItemGeneric;
import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class DTBoomGlove
extends DTItemGeneric {
    protected final Item.ToolMaterial baseMaterial;
    protected float baseDamage;

    public DTBoomGlove(String name, Item.ToolMaterial material) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(192);
        this.baseMaterial = material;
        this.baseDamage = 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 1;
    }

    public Item.ToolMaterial getMaterial() {
        return this.baseMaterial;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.baseDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -1.0, 0));
        }
        return multimap;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.baseMaterial.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    private ItemStack hasAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected boolean isAmmo(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() == Items.field_151016_H;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int bigger = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.biggerBoom, (ItemStack)player.func_184586_b(hand));
        boolean sonic = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.sonicBoom, (ItemStack)player.func_184586_b(hand)) > 0;
        boolean flag = player.field_71075_bZ.field_75098_d;
        ItemStack ammo = this.hasAmmo(player);
        if (world.func_180495_p(pos) != null && !world.func_175623_d(pos) && (ammo != null || sonic || flag)) {
            if (ammo == null) {
                ammo = new ItemStack(Items.field_151016_H);
            }
            if (!flag) {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                if (!sonic) {
                    --ammo.field_77994_a;
                    if (ammo.field_77994_a == 0) {
                        player.field_71071_by.func_184437_d(ammo);
                    }
                }
            }
            if (!world.field_72995_K) {
                if (world.func_180495_p(pos).func_177230_c().getHarvestLevel(world.func_180495_p(pos)) < 3 && world.func_180495_p(pos).func_177230_c().getHarvestLevel(world.func_180495_p(pos)) > -1 && world.func_180495_p(pos).func_177230_c().func_149638_a((Entity)player) < 500.0f) {
                    world.func_180495_p(pos).func_177230_c().func_149752_b(2.0f);
                }
                float f = 2.0f + (float)bigger;
                world.func_72885_a(null, (double)((float)pos.func_177958_n() + 0.54f), (double)((float)pos.func_177956_o() + 0.54f), (double)((float)pos.func_177952_p() + 0.54f), f, false, true);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean sonic;
        super.func_77644_a(stack, target, attacker);
        boolean bigger = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.biggerBoom, (ItemStack)stack) > 0;
        boolean bl = sonic = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.sonicBoom, (ItemStack)stack) > 0;
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            boolean flag = player.field_71075_bZ.field_75098_d;
            if (player.field_71071_by.func_70431_c(new ItemStack(Items.field_151016_H)) || sonic || flag) {
                if (!flag) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (!sonic) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.func_184429_b(new ItemStack(Items.field_151016_H)), 1);
                    }
                }
                if (!attacker.func_130014_f_().field_72995_K) {
                    float f = 0.5f;
                    if (bigger) {
                        f = 1.0f;
                    }
                    attacker.func_130014_f_().func_72885_a((Entity)attacker, target.field_70165_t, target.field_70163_u + (double)0.54f, target.field_70161_v, f, false, false);
                }
            }
        }
        return true;
    }
}

