/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Entities;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityHuckling
extends EntityAnimal {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    private int cookiesDevoured;
    private int cakesDevoured;
    private int boomTime;
    private int timeUntilNextLoot = 6000;
    private int heal = 0;

    public EntityHuckling(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.7f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.cookiesDevoured = 0;
        this.cakesDevoured = 0;
        this.boomTime = this.field_70146_Z.nextInt(32);
        this.timeUntilNextLoot = this.field_70146_Z.nextInt(6000) + 6000;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (this.func_110143_aJ() < this.func_110138_aP() && ++this.heal > 40) {
            this.heal = 0;
            this.func_70691_i(1.0f);
        }
        if (!this.func_130014_f_().field_72995_K && --this.timeUntilNextLoot <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_70099_a(this.getRandomLoot(), 1.0f);
            this.timeUntilNextLoot = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186394_B;
    }

    public EntityChicken createChild(EntityAgeable ageable) {
        return new EntityChicken(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected int func_70693_a(EntityPlayer player) {
        return super.func_70693_a(player);
    }

    public static void registerFixesChicken(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityChicken.class);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.cookiesDevoured = compound.func_74762_e("cookiesDevoured");
        this.cakesDevoured = compound.func_74762_e("cakesDevoured");
        this.boomTime = compound.func_74762_e("boomTime");
        this.timeUntilNextLoot = compound.func_74762_e("lootTime");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("cookiesDevoured", this.cookiesDevoured);
        compound.func_74768_a("cakesDevoured", this.cakesDevoured);
        compound.func_74768_a("boomTime", this.boomTime);
        compound.func_74768_a("lootTime", this.timeUntilNextLoot);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_95999_t() {
        return "Huckling";
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack != null) {
            if (stack.func_77973_b() == Items.field_151106_aX) {
                this.dropCookiePresent(stack, this.func_130014_f_(), (Entity)this);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
            }
            if (stack.func_77973_b() == Items.field_151105_aU) {
                this.dropCakePresent(stack, this.func_130014_f_(), (Entity)this);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public ItemStack getCookiePresent() {
        switch (this.field_70146_Z.nextInt(8)) {
            case 0: {
                return new ItemStack(Items.field_151034_e);
            }
            case 1: {
                return new ItemStack(Items.field_151044_h);
            }
            case 2: {
                return new ItemStack(Items.field_151103_aS);
            }
            case 3: {
                return new ItemStack(Items.field_151121_aF);
            }
            case 4: {
                return new ItemStack(Items.field_151116_aA);
            }
            case 5: {
                return new ItemStack(Items.field_151008_G);
            }
            case 6: {
                return new ItemStack(Items.field_151119_aD);
            }
            case 7: {
                return new ItemStack(Items.field_151110_aK);
            }
        }
        return null;
    }

    public void dropCookiePresent(ItemStack stack, World world, Entity entity) {
        if (++this.cookiesDevoured >= 16 && !world.field_72995_K) {
            if (this.doBoom(world, (EntityLivingBase)this)) {
                boolean flag = world.func_82736_K().func_82766_b("mobGriefing");
                world.func_72885_a(entity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false, flag);
                this.boomTime = this.field_70146_Z.nextInt(32);
            } else {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                entity.func_70099_a(this.getCookiePresent(), 1.0f);
                this.cookiesDevoured = this.field_70146_Z.nextInt(16) - 1;
            }
        }
    }

    public ItemStack getCakePresents() {
        switch (this.field_70146_Z.nextInt(9)) {
            case 0: {
                return new ItemStack(Items.field_151042_j);
            }
            case 1: {
                return new ItemStack(Items.field_151043_k);
            }
            case 2: {
                return new ItemStack(Items.field_151045_i);
            }
            case 3: {
                return new ItemStack(Items.field_151137_ax);
            }
            case 4: {
                return new ItemStack(Items.field_151123_aH);
            }
            case 5: {
                return new ItemStack(Items.field_151016_H);
            }
            case 6: {
                return new ItemStack(Items.field_151100_aR, 1, 4);
            }
            case 7: {
                return new ItemStack(Items.field_151065_br);
            }
            case 8: {
                return new ItemStack(Items.field_151166_bC);
            }
        }
        return null;
    }

    public void dropCakePresent(ItemStack stack, World world, Entity entity) {
        if (++this.cakesDevoured >= 12 && !world.field_72995_K) {
            if (this.doBoom(world, (EntityLivingBase)this)) {
                boolean flag = entity.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
                world.func_72885_a(entity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false, flag);
                this.boomTime = this.field_70146_Z.nextInt(32);
            } else {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                entity.func_70099_a(this.getCakePresents(), 1.0f);
                this.cakesDevoured = this.field_70146_Z.nextInt(12) - 1;
            }
        }
    }

    public boolean doBoom(World world, EntityLivingBase par2Entity) {
        return --this.boomTime <= 0;
    }

    public static void spawnHuckling(EntityChicken target) {
        target.func_70606_j(0.0f);
        target.func_70106_y();
        EntityHuckling huckling = new EntityHuckling(target.func_130014_f_());
        boolean flag = huckling.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
        huckling.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
        huckling.func_130014_f_().func_72838_d((Entity)huckling);
        huckling.func_130014_f_().func_72885_a((Entity)huckling, huckling.field_70165_t, huckling.field_70163_u, huckling.field_70161_v, 1.0f, false, flag);
    }

    public ItemStack getRandomLoot() {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                return new ItemStack(Items.field_151034_e);
            }
            case 1: {
                return new ItemStack(Items.field_151008_G);
            }
            case 2: {
                return new ItemStack(Items.field_151110_aK);
            }
        }
        return null;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.func_130014_f_().field_72995_K) {
            boolean flag = this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
            this.func_130014_f_().func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 1.0f, false, flag);
        }
        super.func_70645_a(cause);
    }
}

