/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import PegBeard.DungeonTactics.Blocks.DTFlower;
import PegBeard.DungeonTactics.Blocks.TileEntities.DTCushionEntity;
import PegBeard.DungeonTactics.DungeonTactics;
import PegBeard.DungeonTactics.Entities.EntityHuckling;
import PegBeard.DungeonTactics.Entities.EntityTowerGuardian;
import PegBeard.DungeonTactics.Handlers.DTBlocks;
import PegBeard.DungeonTactics.Handlers.DTConfigHandler;
import PegBeard.DungeonTactics.Handlers.DTEffects;
import PegBeard.DungeonTactics.Handlers.DTItems;
import PegBeard.DungeonTactics.Items.DTArmourAdventure;
import PegBeard.DungeonTactics.Items.DTAxe;
import PegBeard.DungeonTactics.Items.DTHammer;
import PegBeard.DungeonTactics.Reference.Material;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class DTEventHandler {
    protected static Random eventRand;

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        Block block;
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        if (DTConfigHandler.configuration.get("1-Feature", "RP-Sitting", true).getBoolean(true) && (block = event.getWorld().func_180495_p(pos).func_177230_c()) != null && player.func_184614_ca().func_190926_b() && event.getWorld().func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
            DTCushionEntity cushion;
            if (block instanceof BlockCarpet || block instanceof BlockBasePressurePlate) {
                cushion = new DTCushionEntity(event.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.1);
                event.getWorld().func_72838_d((Entity)cushion);
                player.func_184220_m((Entity)cushion);
            }
            if ((block instanceof BlockSlab || block instanceof BlockStairs) && !block.isSideSolid(block.func_176223_P(), (IBlockAccess)event.getWorld(), pos, EnumFacing.UP)) {
                cushion = new DTCushionEntity(event.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.5);
                event.getWorld().func_72838_d((Entity)cushion);
                player.func_184220_m((Entity)cushion);
            }
        }
        if (DTConfigHandler.configuration.get("1-Feature", "7-Ore Clusters", true).getBoolean(true) && (state = event.getWorld().func_180495_p(pos)).func_177230_c() != null && state.func_177230_c() instanceof BlockCauldron) {
            BlockCauldron cauldron = (BlockCauldron)state.func_177230_c();
            if (player.func_184614_ca() != null && player.func_184592_cb() != null) {
                ItemStack stack1 = player.func_184614_ca();
                ItemStack stack2 = player.func_184592_cb();
                if (stack1.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150354_m) && stack2.func_77973_b() == Items.field_151123_aH || stack1.func_77973_b() == Items.field_151123_aH && stack2.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150354_m)) {
                    event.setCanceled(true);
                    if (event.getHand() == EnumHand.OFF_HAND) {
                        return;
                    }
                    if ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) > 0 && !player.func_130014_f_().field_72995_K) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            cauldron.func_176590_a(player.func_130014_f_(), pos, state, (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) - 1);
                            stack1.func_190918_g(1);
                            if (stack1.func_190926_b()) {
                                player.field_71071_by.func_184437_d(stack1);
                            }
                            stack2.func_190918_g(1);
                            if (stack2.func_190926_b()) {
                                player.field_71071_by.func_184437_d(stack2);
                            }
                        }
                        EntityItem clay = new EntityItem(player.func_130014_f_(), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack(Items.field_151119_aD, 4));
                        clay.func_174869_p();
                        player.func_130014_f_().func_72838_d((Entity)clay);
                        player.func_130014_f_().func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.3f, 1.0f + (eventRand.nextFloat() - eventRand.nextFloat()) * 0.4f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        ItemStack stack = player.func_184614_ca();
        if (target instanceof EntityChicken && stack != null && stack.func_77973_b() == Items.field_151057_cb) {
            EntityChicken chicken = (EntityChicken)target;
            if (!chicken.field_70128_L && !chicken.func_70631_g_() && "Huckling".equals(stack.func_82833_r())) {
                EntityHuckling.spawnHuckling(chicken);
            }
        }
        if (!(target instanceof EntityItemFrame) || stack == null || stack.func_77973_b() == DTItems.diploma) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_70644_a(MobEffects.field_76441_p) && DTConfigHandler.configuration.get("1-Feature", "1-Invisiblity Removes Armour", true).getBoolean(true) && !player.func_130014_f_().field_72995_K) {
            block0: for (int a = 0; a < 4; ++a) {
                ItemStack armour = null;
                if (a == 0 && !player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.HEAD);
                }
                if (a == 1 && !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.CHEST);
                }
                if (a == 2 && !player.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.LEGS);
                }
                if (a == 3 && !player.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.FEET);
                }
                if (armour == null) continue;
                for (int s = 0; s < player.field_71071_by.field_70462_a.size(); ++s) {
                    if (player.field_71071_by.func_70301_a(s) != null) continue;
                    player.field_71071_by.func_70441_a(armour.func_77946_l());
                    player.field_71071_by.func_184437_d(armour);
                    continue block0;
                }
            }
        }
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack pants;
        if (event.getEntityLiving() != null && event.getEntityLiving() instanceof EntityPlayer && (pants = (player = (EntityPlayer)event.getEntityLiving()).func_184582_a(EntityEquipmentSlot.LEGS)) != null && pants.func_77973_b() == DTItems.rexoLeggings && player.field_70172_ad <= 0) {
            DTArmourAdventure.burst(player.func_130014_f_(), player, pants);
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        if (event.getEntityLiving() != null) {
            ItemStack boots = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
            if (boots != null && boots.func_77973_b() == DTItems.rexoBoots && event.getDistance() >= 1.5f) {
                DTArmourAdventure.bounce(event.getEntityLiving().func_130014_f_(), event.getEntityLiving(), boots, event.getDistance());
                if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
                    boolean featherfall;
                    boolean bl = featherfall = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)boots) > 1;
                    if (featherfall) {
                        event.setDistance(0.0f);
                    } else {
                        event.setDistance(event.getDistance() / 2.5f);
                    }
                }
            }
            if (event.getEntityLiving() instanceof EntityPlayer && (event.getEntityLiving().func_184614_ca() != null && event.getEntityLiving().func_184614_ca().func_77973_b() == DTItems.peg_hammer || event.getEntityLiving().func_184592_cb() != null && event.getEntityLiving().func_184592_cb().func_77973_b() == DTItems.peg_hammer)) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() != null) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
                if (player.func_184582_a(EntityEquipmentSlot.CHEST) != null && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == DTItems.rexoHarness && eventRand.nextInt(5) == 0) {
                    event.setAmount(0.0f);
                }
                if (event.getSource() != DamageSource.field_76380_i) {
                    ItemStack phylactery;
                    int k;
                    float a = event.getAmount();
                    float damage = CombatRules.func_189427_a((float)a, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                    if (player.func_70644_a(MobEffects.field_76429_m)) {
                        int i = (player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
                        int j = 25 - i;
                        float f = damage * (float)j;
                        damage = f / 25.0f;
                    }
                    if (damage > 0.0f && (k = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)event.getSource())) > 0) {
                        damage = CombatRules.func_188401_b((float)damage, (float)k);
                    }
                    if (damage >= event.getEntityLiving().func_110143_aJ() && player.field_71071_by.func_70431_c(phylactery = new ItemStack(DTItems.phylactery)) && player.field_71068_ca >= 5) {
                        event.setAmount(0.0f);
                        player.func_82242_a(-5);
                        player.func_70691_i(player.func_110138_aP());
                        player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 60, 0));
                        player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187855_gD, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                            if (itemstack == null || itemstack.func_77973_b() != DTItems.phylactery) continue;
                            player.field_71071_by.func_70304_b(i);
                            break;
                        }
                    }
                    if (stack != null && stack.func_77973_b() == DTItems.peg_hammer && event.getSource().func_94541_c()) {
                        event.setCanceled(true);
                    }
                }
            }
            if (event.getSource().func_76364_f() != null && event.getSource().func_76364_f() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
                if (event.getSource().func_76364_f() == attacker && attacker.func_184586_b(EnumHand.MAIN_HAND) != null) {
                    boolean smelting;
                    boolean berserker = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.berserk, (ItemStack)attacker.func_184586_b(EnumHand.MAIN_HAND)) > 0;
                    int lifestealer = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.lifesteal, (ItemStack)attacker.func_184586_b(EnumHand.MAIN_HAND));
                    int runed = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.runed, (ItemStack)attacker.func_184586_b(EnumHand.MAIN_HAND));
                    boolean bl = smelting = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.smelting, (ItemStack)attacker.func_184586_b(EnumHand.MAIN_HAND)) > 0;
                    if (berserker) {
                        float d = 6.0f;
                        float ac = attacker.func_70658_aO();
                        if (ac > 0.0f) {
                            int i = 0;
                            while ((float)i < ac) {
                                d -= 0.5f;
                                ++i;
                            }
                            if (d < -1.0f) {
                                d = -1.0f;
                            }
                        }
                        if (d >= -1.0f) {
                            d = event.getAmount() + d;
                        }
                        event.setAmount(d);
                    }
                    if (lifestealer > 0) {
                        int i = 4 - lifestealer;
                        attacker.func_70691_i(event.getAmount() / (float)i);
                    }
                    if (runed > 0) {
                        float ed = event.getAmount();
                        float pd = 0.0f;
                        float md = 0.0f;
                        int r = 4;
                        if (runed == 2) {
                            r = 2;
                        }
                        if (runed == 3) {
                            pd = ed / (float)r;
                            md = ed - pd;
                        } else {
                            md = ed / (float)r;
                            pd = ed - md;
                        }
                        event.setAmount(pd);
                        event.getEntityLiving().func_70097_a(DamageSource.field_76376_m, md);
                    }
                    if (smelting && !event.getEntityLiving().func_70027_ad()) {
                        event.getEntityLiving().func_70015_d(6);
                    }
                }
            }
            if (event.getEntityLiving().func_70660_b(DTEffects.cryo) != null) {
                float amp = event.getEntityLiving().func_70660_b(DTEffects.cryo).func_76458_c();
                float damage = event.getAmount();
                if (amp > 0.0f && damage > 0.0f && (damage *= 1.0f + amp / 2.0f) > 0.0f) {
                    event.setAmount(damage);
                }
            }
        }
    }

    @SubscribeEvent
    public void repairAtAnvil(AnvilRepairEvent event) {
        if (event.getItemInput() != null && event.getItemInput().func_77942_o() && event.getItemInput().func_77978_p().func_74762_e("ducttaped") > 0 && event.getItemResult() != null && event.getItemResult().func_77978_p().func_74762_e("ducttaped") > 0) {
            event.getItemResult().func_77978_p().func_82580_o("ducttaped");
        }
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent event) {
        if (event.getItem().func_92059_d().func_77973_b() == DTItems.heartDrop) {
            EntityPlayer player = event.getEntityPlayer();
            event.getItem().func_70106_y();
            event.setCanceled(true);
            player.func_130014_f_().func_184133_a((EntityPlayer)null, player.func_180425_c(), SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.2f, 1.0f / (eventRand.nextFloat() * 0.4f + 1.2f));
            if (!player.func_130014_f_().field_72995_K && player.field_71071_by.func_70431_c(new ItemStack(Items.field_151069_bo))) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                    if (itemstack == null || itemstack.func_77973_b() != Items.field_151069_bo) continue;
                    player.field_71071_by.func_70298_a(i, 1);
                    player.func_70099_a(new ItemStack(DTItems.heartJar), 1.0f);
                    break;
                }
            } else {
                event.getEntityPlayer().func_70691_i(2.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPickupXpEvent(PlayerPickupXpEvent event) {
        int xp;
        if (event.getEntityPlayer().func_184582_a(EntityEquipmentSlot.HEAD) != null && event.getEntityPlayer().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == DTItems.engineerDoorag && (xp = event.getOrb().field_70530_e) > 0) {
            int xpFinal = xp;
            if (eventRand.nextInt(3) == 0) {
                Potion effectType;
                xpFinal = xp * 2;
                if (event.getEntityPlayer().func_70651_bq().isEmpty() && (effectType = (Potion)Potion.field_188414_b.func_186801_a(eventRand)).func_188408_i() && effectType != MobEffects.field_76432_h && effectType != MobEffects.field_76433_i) {
                    event.getEntityPlayer().func_70690_d(new PotionEffect(effectType, 200, 0, true, false));
                }
            }
            event.getEntityPlayer().func_71023_q(xpFinal);
            event.getOrb().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack item;
        if ((!event.getEntityLiving().func_130014_f_().func_82736_K().func_82766_b("naturalRegeneration") || event.getEntityLiving().func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) && (item = event.getItem()).func_77973_b() instanceof ItemFood) {
            float h = 0.3f * (float)((ItemFood)item.func_77973_b()).func_150905_g(event.getItem());
            event.getEntityLiving().func_70691_i(h);
        }
    }

    @SubscribeEvent
    public void onUseBonemeal(BonemealEvent event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150341_Y) {
            if (!event.getWorld().field_72995_K) {
                for (int l = 0; l < 32; ++l) {
                    BlockPos newPos = event.getPos().func_177982_a(eventRand.nextInt(5) - eventRand.nextInt(5), eventRand.nextInt(3) - eventRand.nextInt(3), eventRand.nextInt(5) - eventRand.nextInt(5));
                    if (!event.getWorld().func_175623_d(newPos) || newPos.func_177956_o() >= 255 || !((DTFlower)this.getFlower()).func_180671_f(event.getWorld(), newPos, this.getFlower().func_176223_P())) continue;
                    event.getWorld().func_180501_a(newPos, this.getFlower().func_176223_P(), 2);
                }
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    public Block getFlower() {
        switch (eventRand.nextInt(9)) {
            case 0: {
                return DTBlocks.flowerSanguine;
            }
            case 1: {
                return DTBlocks.flowerBramble;
            }
            case 2: {
                return DTBlocks.flowerBark;
            }
            case 3: {
                return DTBlocks.flowerCinder;
            }
            case 4: {
                return DTBlocks.flowerTangle;
            }
            case 5: {
                return DTBlocks.flowerAilment;
            }
            case 6: {
                return DTBlocks.flowerFade;
            }
            case 7: {
                return DTBlocks.flowerFeather;
            }
            case 8: {
                return DTBlocks.flowerXp;
            }
        }
        return DTBlocks.flowerBramble;
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        EntityPigZombie pigman;
        AbstractSkeleton skeleton;
        EntityZombie zombie;
        eventRand = new Random();
        int i = eventRand.nextInt(100);
        if (event.getEntity() instanceof EntityZombie && !(event.getEntity() instanceof EntityTowerGuardian) && !(zombie = (EntityZombie)event.getEntity()).func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && zombie.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151040_l) {
            if (i < 30) {
                event.getEntity().func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.ironHammer));
            }
            if (i > 30 && i < 50) {
                event.getEntity().func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.ironCutlass));
            }
        }
        if (event.getEntity() instanceof AbstractSkeleton && !(skeleton = (AbstractSkeleton)event.getEntity()).func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
            if (skeleton instanceof EntitySkeleton || skeleton instanceof EntityStray) {
                if (i < 20) {
                    skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.ironKnife));
                }
                if (i > 20 && i < 30) {
                    skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.ironCutlass));
                }
            }
            if (skeleton instanceof EntityWitherSkeleton && i < 40) {
                skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.stoneHammer));
            }
        }
        if (event.getEntity() instanceof EntityPigZombie && !(event.getEntity() instanceof EntityTowerGuardian) && !(pigman = (EntityPigZombie)event.getEntity()).func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
            if (i < 25) {
                pigman.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.goldenHammer));
            }
            if (i > 25 && i < 40) {
                pigman.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.goldenCutlass));
            }
        }
    }

    public ItemStack getLootBag() {
        switch (eventRand.nextInt(6)) {
            case 0: {
                return new ItemStack(DTItems.foodBag);
            }
            case 1: {
                return new ItemStack(DTItems.oreBag);
            }
            case 2: {
                return new ItemStack(DTItems.toolBag);
            }
            case 3: {
                return new ItemStack(DTItems.bookBag);
            }
            case 4: {
                return new ItemStack(DTItems.potionBag);
            }
            case 5: {
                return new ItemStack(DTItems.recordBag);
            }
        }
        return null;
    }

    public ItemStack getBoneCharm() {
        switch (eventRand.nextInt(9)) {
            case 0: {
                return new ItemStack(DTItems.toxicCharm);
            }
            case 1: {
                return new ItemStack(DTItems.sappingCharm);
            }
            case 2: {
                return new ItemStack(DTItems.heavyCharm);
            }
            case 3: {
                return new ItemStack(DTItems.emaciatedCharm);
            }
            case 4: {
                return new ItemStack(DTItems.unintelligibleCharm);
            }
            case 5: {
                return new ItemStack(DTItems.darkenedCharm);
            }
            case 6: {
                return new ItemStack(DTItems.famineCharm);
            }
            case 7: {
                return new ItemStack(DTItems.barrenCharm);
            }
            case 8: {
                return new ItemStack(DTItems.searingCharm);
            }
        }
        return null;
    }

    public ItemStack getTome() {
        switch (eventRand.nextInt(6)) {
            case 0: {
                return new ItemStack(DTItems.tomeLeap);
            }
            case 1: {
                return new ItemStack(DTItems.tomeSmash);
            }
            case 2: {
                return new ItemStack(DTItems.tomeRiposte);
            }
            case 3: {
                return new ItemStack(DTItems.tomePierce);
            }
            case 4: {
                return new ItemStack(DTItems.tomeMultiStrike);
            }
            case 5: {
                return new ItemStack(DTItems.tomeSmokebomb);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EnumDifficulty difficulty = event.getEntityLiving().func_130014_f_().func_175659_aa();
        boolean canDrop = event.getEntityLiving().func_130014_f_().func_82736_K().func_82766_b("doMobLoot");
        int heartConfig = DTConfigHandler.configuration.get("1-Feature", "2-Heart Drops", 20).getInt(20);
        int lootbagsConfig = DTConfigHandler.configuration.get("1-Feature", "8-Loot Bag Drops", 10).getInt(10);
        int bonecharmsConfig = DTConfigHandler.configuration.get("1-Feature", "4-Bone Charm Drops", 10).getInt(10);
        eventRand = new Random();
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && canDrop && event.isRecentlyHit()) {
            if (event.getEntityLiving() instanceof EntityLivingBase) {
                if (eventRand.nextInt(100) < heartConfig / 2) {
                    if (difficulty != EnumDifficulty.EASY) {
                        event.getEntityLiving().func_70099_a(new ItemStack(DTItems.heartDrop), 1.0f);
                    }
                }
                if (DTConfigHandler.configuration.get("1-Feature", "E-Seasonal Events", true).getBoolean(true)) {
                    ItemStack bag = null;
                    if (DungeonTactics.samhain) {
                        bag = new ItemStack(DTItems.trickortreatBag);
                    }
                    if (DungeonTactics.solstice) {
                        bag = new ItemStack(DTItems.solsticeBag);
                    }
                    if (bag != null && eventRand.nextInt(100) < lootbagsConfig * 2) {
                        event.getEntityLiving().func_70099_a(bag, 1.0f);
                    }
                }
            }
            if (event.getEntityLiving() instanceof EntityMob) {
                if (eventRand.nextInt(100) < heartConfig) {
                    if (difficulty != EnumDifficulty.EASY) {
                        event.getEntityLiving().func_70099_a(new ItemStack(DTItems.heartDrop), (float)(eventRand.nextInt(1) + 1));
                    }
                }
                if (eventRand.nextInt(100) < lootbagsConfig) {
                    event.getEntityLiving().func_70099_a(this.getLootBag(), 1.0f);
                }
            }
            if (event.getEntityLiving() instanceof EntityTowerGuardian) {
                event.getDrops().clear();
                event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, new ItemStack(Items.field_151166_bC, 1 + eventRand.nextInt(2))));
                if (eventRand.nextInt(100) < bonecharmsConfig) {
                    event.getEntityLiving().func_70099_a(this.getBoneCharm(), 1.0f);
                }
                if (eventRand.nextInt(100) < bonecharmsConfig) {
                    event.getEntityLiving().func_70099_a(this.getTome(), 1.0f);
                }
            }
            if (event.getEntityLiving() instanceof EntityWither || event.getEntityLiving() instanceof EntityDragon || event.getEntityLiving() instanceof EntityGuardian) {
                if (heartConfig != 0) {
                    event.getEntityLiving().func_70099_a(new ItemStack(DTItems.heartDrop), (float)(3 + eventRand.nextInt(3)));
                    event.getEntityLiving().func_70099_a(new ItemStack(DTItems.heartJar), (float)eventRand.nextInt(3));
                    event.getEntityLiving().func_70099_a(new ItemStack(DTItems.heartGolden), (float)eventRand.nextInt(2));
                }
                if (eventRand.nextInt(100) < lootbagsConfig * 2) {
                    event.getEntityLiving().func_70099_a(this.getLootBag(), 1.0f);
                }
                if (eventRand.nextInt(100) < bonecharmsConfig) {
                    event.getEntityLiving().func_70099_a(this.getTome(), 1.0f);
                }
                if (event.getEntityLiving() instanceof EntityWither) {
                    if (eventRand.nextInt(100) < bonecharmsConfig) {
                        event.getEntityLiving().func_70099_a(this.getBoneCharm(), 1.0f);
                    }
                    if (eventRand.nextInt(100) < bonecharmsConfig) {
                        event.getEntityLiving().func_70099_a(new ItemStack(DTItems.phylactery), 1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        ItemStack tool;
        int count;
        if (event.isSilkTouching()) {
            return;
        }
        if (event.getDrops().isEmpty()) {
            return;
        }
        if (DTConfigHandler.configuration.get("1-Feature", "7-Ore Clusters", true).getBoolean(true)) {
            count = this.randomCount(event.getDrops().size(), event.getFortuneLevel(), event.getWorld());
            if (event.getState().func_177230_c().func_180660_a(event.getState().func_177230_c().func_176223_P(), eventRand, 0) == ItemBlock.func_150898_a((Block)event.getState().func_177230_c()) && !event.getDrops().isEmpty()) {
                ListIterator<ItemStack> dropList = event.getDrops().listIterator();
                while (dropList.hasNext()) {
                    int i;
                    ItemStack drop = (ItemStack)dropList.next();
                    if (drop == null) continue;
                    boolean swapped = false;
                    ItemStack cluster = drop;
                    NonNullList ironList = OreDictionary.getOres((String)"oreIron");
                    NonNullList goldList = OreDictionary.getOres((String)"oreGold");
                    NonNullList tinList = OreDictionary.getOres((String)"oreTin");
                    NonNullList copperList = OreDictionary.getOres((String)"oreCopper");
                    NonNullList leadList = OreDictionary.getOres((String)"oreLead");
                    NonNullList silverList = OreDictionary.getOres((String)"oreSilver");
                    if (!ironList.isEmpty() && !swapped) {
                        for (i = 0; i < ironList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)ironList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.ironCluster);
                            swapped = true;
                        }
                    }
                    if (!goldList.isEmpty() && !swapped) {
                        for (i = 0; i < goldList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)goldList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.goldCluster);
                            swapped = true;
                        }
                    }
                    if (!tinList.isEmpty() && !swapped) {
                        for (i = 0; i < tinList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)tinList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.tinCluster);
                            swapped = true;
                        }
                    }
                    if (!copperList.isEmpty() && !swapped) {
                        for (i = 0; i < copperList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)copperList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.copperCluster);
                            swapped = true;
                        }
                    }
                    if (!leadList.isEmpty() && !swapped) {
                        for (i = 0; i < leadList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)leadList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.leadCluster);
                            swapped = true;
                        }
                    }
                    if (!silverList.isEmpty() && !swapped) {
                        for (i = 0; i < silverList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)silverList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.silverCluster);
                            swapped = true;
                        }
                    }
                    if (cluster.func_77973_b().getRegistryName() == null || !swapped) continue;
                    cluster.func_190920_e(count);
                    dropList.set(cluster);
                }
            }
            if (event.getHarvester() != null && (tool = event.getHarvester().func_184614_ca()) != null && tool.func_77973_b() instanceof DTHammer) {
                if (event.getState().func_177230_c() == Blocks.field_150347_e) {
                    event.getDrops().clear();
                    event.getDrops().add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150351_n), 1));
                }
                if (event.getState().func_177230_c() == Blocks.field_150351_n) {
                    ItemStack stack = ItemStack.field_190927_a;
                    int chance = eventRand.nextInt(100);
                    int amount = this.randomCount(event.getDrops().size(), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)tool), event.getWorld());
                    if (chance < 50) {
                        stack = new ItemStack(Items.field_151145_ak, amount);
                    }
                    if (chance >= 50 && chance < 80) {
                        stack = new ItemStack(Items.field_151137_ax, amount);
                    }
                    if (chance >= 80) {
                        NonNullList oreList;
                        boolean smelting;
                        chance = eventRand.nextInt(3);
                        boolean bl = smelting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)tool) > 0;
                        if (chance == 0 && !(oreList = OreDictionary.getOres((String)"ingotTin")).isEmpty()) {
                            stack = smelting ? FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(DTItems.tinCluster, 1)) : new ItemStack(DTItems.tinCluster, amount);
                        }
                        if (chance == 1 && !(oreList = OreDictionary.getOres((String)"ingotCopper")).isEmpty()) {
                            stack = smelting ? FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(DTItems.copperCluster, 1)) : new ItemStack(DTItems.copperCluster, amount);
                        }
                        if (stack.func_190926_b()) {
                            stack = smelting ? FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(DTItems.ironCluster, 1)) : new ItemStack(DTItems.ironCluster, amount);
                        }
                    }
                    if (stack.func_190926_b()) {
                        stack = new ItemStack(Items.field_151145_ak, amount);
                    }
                    event.getDrops().clear();
                    event.getDrops().add(stack);
                    event.getDrops().add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 1));
                }
            }
        }
        if (event.getHarvester() != null) {
            count = this.randomCount(event.getDrops().size(), event.getFortuneLevel(), event.getWorld());
            tool = event.getHarvester().func_184614_ca();
            if (tool != null && (tool.func_77973_b() instanceof ItemPickaxe || tool.func_77973_b() instanceof ItemAxe || tool.func_77973_b() instanceof DTAxe || tool.func_77973_b() instanceof ItemSpade) && !event.getDrops().isEmpty()) {
                boolean smelting;
                boolean bl = smelting = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.smelting, (ItemStack)tool) > 0;
                if (smelting) {
                    ListIterator<ItemStack> dropList = event.getDrops().listIterator();
                    while (dropList.hasNext()) {
                        ItemStack drop = (ItemStack)dropList.next();
                        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                        if (smelted == null) continue;
                        smelted = smelted.func_77946_l();
                        smelted.func_190920_e(count);
                        dropList.set(smelted);
                        float baseExp = FurnaceRecipes.func_77602_a().func_151398_b(smelted);
                        float bonusExp = baseExp * (float)count;
                        if (bonusExp >= 1.0f) {
                            event.getState().func_177230_c().func_180637_b(event.getWorld(), event.getPos(), (int)bonusExp);
                        }
                        event.getHarvester().func_130014_f_().func_184133_a(null, event.getHarvester().func_180425_c(), SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (eventRand.nextFloat() * 0.4f + 1.2f));
                    }
                }
            }
        }
        if (event.getState().func_177230_c() == DTBlocks.bushBaring) {
            int ammount = 1 + eventRand.nextInt(3);
            for (int i = 0; i < ammount; ++i) {
                event.getDrops().add(new ItemStack(DTItems.cherryBomb, 1));
            }
        }
    }

    private int randomCount(int baseCount, int fortuneLevel, World world) {
        if (fortuneLevel > 0) {
            int j = eventRand.nextInt(fortuneLevel + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return baseCount * (j + 1);
        }
        return baseCount;
    }

    @SubscribeEvent
    public void oreRegisterEvent(OreDictionary.OreRegisterEvent event) {
        ItemStack ingot;
        if (DTConfigHandler.configuration.get("1-Feature", "7-Ore Clusters", true).getBoolean(true) && event.getName().contains("ingot")) {
            float xp;
            if (event.getName().contains("Tin") && FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(DTItems.tinCluster)) == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                xp = FurnaceRecipes.func_77602_a().func_151398_b(ingot);
                GameRegistry.addSmelting((Item)DTItems.tinCluster, (ItemStack)ingot, (float)xp);
            }
            if (event.getName().contains("Copper") && FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(DTItems.copperCluster)) == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                xp = FurnaceRecipes.func_77602_a().func_151398_b(ingot);
                GameRegistry.addSmelting((Item)DTItems.copperCluster, (ItemStack)ingot, (float)xp);
            }
            if (event.getName().contains("Lead") && FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(DTItems.leadCluster)) == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                xp = FurnaceRecipes.func_77602_a().func_151398_b(ingot);
                GameRegistry.addSmelting((Item)DTItems.leadCluster, (ItemStack)ingot, (float)xp);
            }
            if (event.getName().contains("Silver") && FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(DTItems.silverCluster)) == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                xp = FurnaceRecipes.func_77602_a().func_151398_b(ingot);
                GameRegistry.addSmelting((Item)DTItems.silverCluster, (ItemStack)ingot, (float)xp);
            }
        }
        if (event.getName().contains("ingot")) {
            if (event.getName().contains("Tin") && Material.Tools.TIN.getRepairItemStack() == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                Material.Tools.TIN.setRepairItem(ingot);
            }
            if (event.getName().contains("Copper") && Material.Tools.COPPER.getRepairItemStack() == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                Material.Tools.COPPER.setRepairItem(ingot);
            }
            if (event.getName().contains("Bronze") && Material.Tools.BRONZE.getRepairItemStack() == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                Material.Tools.BRONZE.setRepairItem(ingot);
            }
            if (event.getName().contains("Lead") && Material.Tools.LEAD.getRepairItemStack() == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                Material.Tools.LEAD.setRepairItem(ingot);
            }
            if (event.getName().contains("Steel") && Material.Tools.STEEL.getRepairItemStack() == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                Material.Tools.STEEL.setRepairItem(ingot);
            }
            if (event.getName().contains("Silver") && Material.Tools.SILVER.getRepairItemStack() == null && (ingot = new ItemStack(event.getOre().func_77973_b(), 1, event.getOre().func_77960_j())).func_77973_b() != null) {
                Material.Tools.SILVER.setRepairItem(ingot);
            }
        }
    }
}

