/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import PegBeard.DungeonTactics.Handlers.DTBlocks;
import PegBeard.DungeonTactics.Handlers.DTConfigHandler;
import PegBeard.DungeonTactics.Reference.Reference;
import PegBeard.DungeonTactics.WorldGen.DTDungeon;
import PegBeard.DungeonTactics.WorldGen.DTTemplates;
import PegBeard.DungeonTactics.WorldGen.DTTower;
import PegBeard.DungeonTactics.WorldGen.DTWorldDecorator;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IWorldGenerator;

public class DTWorldGen
implements IWorldGenerator {
    int flowers = DTConfigHandler.configuration.get("5-World", "2-Flower Generation", 32).getInt(32);
    boolean treasures = DTConfigHandler.configuration.get("5-World", "3-Treasure Boxes", true).getBoolean(true);
    boolean netherGold = DTConfigHandler.configuration.get("5-World", "1-Nether Gold", true).getBoolean(true);
    boolean structures = DTConfigHandler.configuration.get("5-World", "4-Dungeon Generation", true).getBoolean(true);
    int dungeonDistance = DTConfigHandler.configuration.get("5-World", "6-Dungeon Spacing", 1000).getInt(1000);
    int shipDistance = DTConfigHandler.configuration.get("5-World", "5-Ship Spacing", 500).getInt(500);

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private static int floordiv(int start, int distance) {
        if (start % distance != 0) {
            // empty if block
        }
        return start / distance - (start < 0 ^ distance < 0 ? 1 : 0);
    }

    private boolean chunkContainsASpawnPosition(int coord, int spacing) {
        int chunksize = 16;
        int lowerEdge = DTWorldGen.floordiv(coord - 1, spacing);
        int upperEdge = DTWorldGen.floordiv(coord + chunksize - 1, spacing);
        return upperEdge - lowerEdge == 1;
    }

    private void generateNether(World world, Random rand, int chunkX, int chunkZ) {
        if (this.netherGold) {
            for (int k = 0; k < 6; ++k) {
                int XCoord = chunkX + rand.nextInt(16);
                int YCoord = 5 + rand.nextInt(118);
                int ZCoord = chunkZ + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.netherGold.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.structures && world.func_72912_H().func_76089_r() && this.chunkContainsASpawnPosition(chunkX, this.dungeonDistance) && this.chunkContainsASpawnPosition(chunkZ, this.dungeonDistance)) {
            BlockPos pos;
            int finalY;
            int finalX = chunkX + rand.nextInt(50) - rand.nextInt(50);
            int finalZ = chunkZ + rand.nextInt(50) - rand.nextInt(50);
            for (finalY = world.func_181545_F() / 2 + (rand.nextInt(25) - rand.nextInt(25)); world.func_180495_p(new BlockPos(finalX, finalY, finalZ)).func_177230_c() != Blocks.field_150424_aL && finalY > 1; --finalY) {
            }
            if (finalY < 1) {
                finalY = 1;
            }
            if (!world.func_175623_d((pos = new BlockPos(finalX, finalY, finalZ)).func_177977_b()) && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150353_l) {
                int chance = rand.nextInt(2);
                if (chance == 0 && pos.func_177956_o() >= 20) {
                    new DTDungeon().func_180709_b(world, rand, pos);
                } else {
                    new DTTower().func_180709_b(world, rand, pos);
                }
            }
        }
    }

    private void generateOverworld(World world, Random rand, int chunkXStart, int chunkZStart) {
        int i;
        int chunkX = chunkXStart + 8;
        int chunkZ = chunkZStart + 8;
        BlockPos pos = new BlockPos(chunkX, world.func_72940_L(), chunkZ);
        Biome biome = world.field_73011_w.getBiomeForCoords(pos);
        Property configBiomes = DTConfigHandler.configuration.get("6-WorldGen", "1-Flower Biomes", Reference.FLOWERBIOMESDEFAULT);
        ArrayList<String> biomeList = new ArrayList<String>(Arrays.asList(configBiomes.getStringList()));
        if (biomeList.contains(biome.getRegistryName().toString())) {
            for (i = 0; i < this.flowers; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                new DTWorldDecorator().generateFlower(world, rand, pos);
            }
        }
        for (i = 0; i < this.flowers; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateFlower(world, rand, pos);
        }
        for (i = 0; i < this.flowers / 2; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos);
        }
        if (this.treasures && world.func_72912_H().func_76089_r() && world.func_175623_d(pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(100), chunkZ + rand.nextInt(16))) && world.func_175677_d(pos.func_177977_b(), false) && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150362_t && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150361_u) {
            new DTWorldDecorator().func_180709_b(world, rand, pos);
        }
        if (this.structures && world.func_72912_H().func_76089_r()) {
            int finalY;
            int finalZ;
            int finalX;
            if (this.chunkContainsASpawnPosition(chunkX, this.dungeonDistance) && this.chunkContainsASpawnPosition(chunkZ, this.dungeonDistance)) {
                finalX = chunkX + rand.nextInt(100) - rand.nextInt(100);
                finalZ = chunkZ + rand.nextInt(100) - rand.nextInt(100);
                int voidY = 63 + rand.nextInt(10) - rand.nextInt(10);
                for (finalY = world.func_72940_L(); world.func_175623_d(new BlockPos(finalX, finalY, finalZ)) && finalY > 1; --finalY) {
                }
                if (world.func_175623_d(new BlockPos(finalX, 0, finalZ))) {
                    finalY = voidY;
                }
                if (finalY < 1) {
                    finalY = 1;
                }
                if (world.func_180495_p((pos = new BlockPos(finalX, finalY, finalZ)).func_177977_b()).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150353_l) {
                    int chance = rand.nextInt(2);
                    if (chance == 0 && pos.func_177956_o() >= 20) {
                        new DTDungeon().settle(world, rand, pos);
                    } else {
                        new DTTower().settle(world, rand, pos);
                    }
                }
            }
            if (this.chunkContainsASpawnPosition(chunkX, this.shipDistance) && this.chunkContainsASpawnPosition(chunkZ, this.shipDistance)) {
                finalY = world.func_181545_F();
                finalX = chunkX + rand.nextInt(100) - rand.nextInt(100);
                finalZ = chunkZ + rand.nextInt(100) - rand.nextInt(100);
                pos = new BlockPos(finalX, finalY, finalZ);
                if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l) {
                    new DTTemplates().func_180709_b(world, rand, pos);
                }
            }
        }
    }

    private void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
    }
}

