/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Items;

import PegBeard.DungeonTactics.Entities.Projectiles.EntityCherryBomb;
import PegBeard.DungeonTactics.Entities.Projectiles.EntityFlint;
import PegBeard.DungeonTactics.Entities.Projectiles.EntitySeedMelon;
import PegBeard.DungeonTactics.Entities.Projectiles.EntitySeedNetherWart;
import PegBeard.DungeonTactics.Entities.Projectiles.EntitySeedPumpkin;
import PegBeard.DungeonTactics.Entities.Projectiles.EntitySeedWheat;
import PegBeard.DungeonTactics.Handlers.DTCreativeTab;
import PegBeard.DungeonTactics.Handlers.DTItems;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DTSlingShot
extends ItemBow {
    private static final List<Item> applicableAmmo = Lists.newArrayList();

    public DTSlingShot(String name) {
        applicableAmmo.add(Items.field_151014_N);
        applicableAmmo.add(Items.field_151080_bb);
        applicableAmmo.add(Items.field_151081_bc);
        applicableAmmo.add(Items.field_151075_bm);
        applicableAmmo.add(Items.field_151145_ak);
        applicableAmmo.add(DTItems.cherryBomb);
        this.func_77655_b("dungeontactics:" + name);
        this.func_77637_a(DTCreativeTab.DT_TAB);
        this.func_77625_d(1);
        this.func_77656_e(192);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entity.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == DTItems.slingshot ? (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean flag1 = this.hasAmmo(player) != null;
        boolean flag2 = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)player.func_184586_b(hand)) > 0;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)player.func_184586_b(hand), (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag1);
        if (ret != null) {
            return ret;
        }
        if (!flag2 && !flag1) {
            return !flag1 ? new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand)) : new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private ItemStack hasAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected boolean isAmmo(@Nullable ItemStack stack) {
        return stack != null && applicableAmmo.contains(stack.func_77973_b());
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 10.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack ammoType = this.hasAmmo(player);
            boolean flag = player.field_71075_bZ.field_75098_d;
            boolean infinity = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            boolean fire = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0;
            int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            int kick = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (ammoType != null || flag || infinity ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (ammoType != null || flag || infinity) {
                float f;
                if (ammoType == null && flag) {
                    ammoType = new ItemStack(DTItems.cherryBomb);
                }
                if (ammoType == null && infinity) {
                    ammoType = new ItemStack(Items.field_151145_ak);
                }
                if ((double)(f = DTSlingShot.getProjectileVelocity(i)) >= 0.2) {
                    if (!world.field_72995_K) {
                        EntitySeedWheat entitywheat = new EntitySeedWheat(world, (EntityLivingBase)player);
                        EntitySeedPumpkin entitypumpkin = new EntitySeedPumpkin(world, (EntityLivingBase)player);
                        EntitySeedMelon entitymelon = new EntitySeedMelon(world, (EntityLivingBase)player);
                        EntitySeedNetherWart entitynetherwart = new EntitySeedNetherWart(world, (EntityLivingBase)player);
                        EntityFlint entityflint = new EntityFlint(world, (EntityLivingBase)player);
                        EntityCherryBomb entitycherrybomb = new EntityCherryBomb(world, (EntityLivingBase)player);
                        if (!flag) {
                            stack.func_77972_a(1, (EntityLivingBase)player);
                        }
                        float v = f * 1.5f;
                        if (ammoType.func_77973_b() == DTItems.cherryBomb) {
                            entitycherrybomb.field_190534_ay = fire;
                            entitycherrybomb.damage = power;
                            entitycherrybomb.knockbackStrength = kick;
                            entitycherrybomb.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entitycherrybomb);
                        }
                        if (ammoType.func_77973_b() == Items.field_151145_ak) {
                            entityflint.field_190534_ay = fire;
                            entityflint.damage = power;
                            entityflint.knockbackStrength = kick;
                            if (flag || infinity) {
                                entityflint.infinite = true;
                            }
                            entityflint.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityflint);
                        }
                        if (ammoType.func_77973_b() == Items.field_151075_bm) {
                            entitynetherwart.field_190534_ay = fire;
                            entitynetherwart.damage = power;
                            entitynetherwart.knockbackStrength = kick;
                            entitynetherwart.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entitynetherwart);
                        }
                        if (ammoType.func_77973_b() == Items.field_151014_N) {
                            entitywheat.field_190534_ay = fire;
                            entitywheat.damage = power;
                            entitywheat.knockbackStrength = kick;
                            entitywheat.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entitywheat);
                        }
                        if (ammoType.func_77973_b() == Items.field_151080_bb) {
                            entitypumpkin.field_190534_ay = fire;
                            entitypumpkin.damage = power;
                            entitypumpkin.knockbackStrength = kick;
                            entitypumpkin.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entitypumpkin);
                        }
                        if (ammoType.func_77973_b() == Items.field_151081_bc) {
                            entitymelon.field_190534_ay = fire;
                            entitymelon.damage = power;
                            entitymelon.knockbackStrength = kick;
                            entitymelon.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entitymelon);
                        }
                    }
                    world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag && !infinity) {
                        ammoType.func_190918_g(1);
                        if (ammoType.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammoType);
                        }
                    }
                }
            }
        }
    }
}

