/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.WorldGen;

import PegBeard.DungeonTactics.Handlers.DTBlocks;
import PegBeard.DungeonTactics.Handlers.DTConfigHandler;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.DungeonHooks;

public class DTDungeon
extends WorldGenerator {
    private boolean netherDungeon = false;
    private int netherChance = DTConfigHandler.configuration.get("5-World", "9-Nether Variant Chance", 9).getInt(9);
    private int trap = 3;
    private boolean isVoid = false;
    private Biome biome = Biomes.field_185440_P;
    private int split = 4;
    private static final List<Block> trapVarient = Lists.newArrayList();

    public DTDungeon() {
        trapVarient.add(Blocks.field_150350_a);
        trapVarient.add(DTBlocks.trapBoom);
        trapVarient.add(DTBlocks.trapFire);
        trapVarient.add(DTBlocks.trapSlime);
        trapVarient.add(DTBlocks.trapFoul);
        trapVarient.add(DTBlocks.trapAilment);
        trapVarient.add(DTBlocks.trapPort);
        trapVarient.add(DTBlocks.trapSpectral);
    }

    public void settle(World world, Random rand, BlockPos start) {
        int level;
        if (world.func_175623_d(new BlockPos(start.func_177958_n(), 0, start.func_177952_p()))) {
            this.isVoid = true;
        }
        BlockPos ne = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() + 4);
        BlockPos se = new BlockPos(start.func_177958_n() + 4, start.func_177956_o(), start.func_177952_p() + 4);
        BlockPos sw = new BlockPos(start.func_177958_n() + 4, start.func_177956_o(), start.func_177952_p() - 4);
        BlockPos nw = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() - 4);
        int count = 0;
        if (!this.isVoid) {
            for (level = start.func_177956_o(); level > 20 && (!world.func_175677_d(ne.func_177979_c(count), false) && world.func_180495_p(ne.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(ne.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(ne.func_177979_c(count)) || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u || !world.func_175677_d(se.func_177979_c(count), false) && world.func_180495_p(se.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(se.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(se.func_177979_c(count)) || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u || !world.func_175677_d(sw.func_177979_c(count), false) && world.func_180495_p(sw.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(sw.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(sw.func_177979_c(count)) || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u || !world.func_175677_d(nw.func_177979_c(count), false) && world.func_180495_p(nw.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(nw.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(nw.func_177979_c(count)) || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u); --level) {
                ++count;
            }
        }
        if (level < 20) {
            level = 20;
        }
        BlockPos pos = new BlockPos(start.func_177958_n(), level, start.func_177952_p());
        this.func_180709_b(world, rand, pos);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos start) {
        int vert;
        int hor;
        int vert2;
        int hor2;
        this.biome = world.func_180494_b(start);
        if (rand.nextInt(100) < this.netherChance) {
            this.netherDungeon = true;
        }
        BlockPos pos = new BlockPos(start.func_177958_n(), start.func_177956_o(), start.func_177952_p());
        BlockPos cs = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() - 4);
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 9; ++z) {
                for (int y = 0; y < 6; ++y) {
                    world.func_175698_g(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z));
                }
            }
        }
        for (hor2 = 0; hor2 < 9; ++hor2) {
            for (vert2 = 0; vert2 < 6; ++vert2) {
                world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(hor2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(hor2).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor2 = 0; hor2 < 9; ++hor2) {
            for (vert2 = 0; vert2 < 6; ++vert2) {
                world.func_180501_a(cs.func_177981_b(vert2).func_177965_g(hor2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(cs.func_177981_b(vert2).func_177965_g(hor2).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor2 = 0; hor2 < 9; ++hor2) {
            for (vert2 = 0; vert2 < 9; ++vert2) {
                world.func_180501_a(cs.func_177970_e(vert2).func_177965_g(hor2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(cs.func_177970_e(vert2).func_177965_g(hor2).func_177981_b(5), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        world.func_180501_a(cs.func_177981_b(2).func_177965_g(2), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(2).func_177965_g(6), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177965_g(2), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177965_g(6), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(2).func_177965_g(2).func_177970_e(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(2).func_177965_g(6).func_177970_e(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177965_g(2).func_177970_e(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177965_g(6).func_177970_e(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(2).func_177970_e(2), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(2).func_177970_e(6), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177970_e(2), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177970_e(6), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(2).func_177970_e(2).func_177965_g(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(2).func_177970_e(6).func_177965_g(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177970_e(2).func_177965_g(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(cs.func_177981_b(3).func_177970_e(6).func_177965_g(8), DTBlocks.dungeonGlass.func_176223_P(), 2);
        world.func_180501_a(pos.func_177984_a().func_177978_c().func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177968_d().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d(), this.useStair(world, pos).func_176203_a(1), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(4).func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177974_f());
        world.func_175698_g(pos.func_177981_b(5).func_177968_d());
        world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177976_e());
        world.func_175698_g(pos.func_177981_b(5).func_177976_e());
        world.func_180501_a(pos.func_177984_a(), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177984_a());
        if (mobspawner instanceof TileEntityMobSpawner) {
            mobspawner.func_145881_a().func_190894_a(this.pickMobSpawner(rand));
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 1 + ", " + pos.func_177952_p() + ")");
        }
        for (vert2 = 1; vert2 < 6; ++vert2) {
            world.func_180501_a(cs.func_177981_b(vert2), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(8), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177965_g(8), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(8).func_177965_g(8), this.useLog(world, pos), 2);
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 2; ++vert) {
                world.func_180501_a(cs.func_177981_b(5).func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(cs.func_177981_b(5).func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 2; ++vert) {
                world.func_180501_a(cs.func_177981_b(5).func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(cs.func_177981_b(5).func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; hor += 2) {
            world.func_180501_a(cs.func_177981_b(7).func_177970_e(hor), this.useSlab(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(7).func_177970_e(hor).func_177965_g(8), this.useSlab(world, pos), 2);
        }
        for (hor = 2; hor < 7; hor += 2) {
            world.func_180501_a(cs.func_177981_b(7).func_177965_g(hor), this.useSlab(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(7).func_177965_g(hor).func_177970_e(8), this.useSlab(world, pos), 2);
        }
        EntityIronGolem golem = new EntityIronGolem(world);
        golem.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
        world.func_72838_d((Entity)golem);
        this.generateDown(world, rand, pos.func_177982_a(0, -5, 0));
        return true;
    }

    public boolean generateDown(World world, Random rand, BlockPos pos) {
        TileEntity chest;
        int vert;
        int hor;
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 4; ++y) {
                    world.func_175698_g(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 9; ++vert) {
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        world.func_180501_a(pos.func_177984_a().func_177978_c().func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177968_d().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d(), this.useStair(world, pos).func_176203_a(1), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(4).func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177974_f());
        world.func_175698_g(pos.func_177981_b(5).func_177968_d());
        world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177976_e());
        world.func_175698_g(pos.func_177981_b(5).func_177976_e());
        if (rand.nextInt(2) == 0) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176458_f(world, pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P()), 2);
        }
        if ((chest = world.func_175625_s(pos.func_177984_a())) instanceof TileEntityChest) {
            if (this.netherDungeon && rand.nextInt(2) == 0) {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
            } else {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
            }
        }
        world.func_180501_a(pos.func_177981_b(2), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177981_b(2));
        if (mobspawner instanceof TileEntityMobSpawner) {
            mobspawner.func_145881_a().func_190894_a(this.pickMobSpawner(rand));
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 2 + ", " + pos.func_177952_p() + ")");
        }
        int next = rand.nextInt(6);
        if (pos.func_177956_o() > 50) {
            this.generateDown(world, rand, pos.func_177982_a(0, -5, 0));
        } else if (next == 0 && pos.func_177956_o() > 10) {
            this.generateDown(world, rand, pos.func_177982_a(0, -5, 0));
        } else if (next == 2) {
            this.generateNorth(world, rand, pos.func_177982_a(0, 0, -8));
            if (rand.nextInt(this.split) == 0) {
                this.generateSouth(world, rand, pos.func_177982_a(0, 0, 8));
            }
        } else if (next == 3) {
            this.generateSouth(world, rand, pos.func_177982_a(0, 0, 8));
            if (rand.nextInt(this.split) == 0) {
                this.generateNorth(world, rand, pos.func_177982_a(0, 0, -8));
            }
        } else if (next == 4) {
            this.generateEast(world, rand, pos.func_177982_a(8, 0, 0));
            if (rand.nextInt(this.split) == 0) {
                this.generateWest(world, rand, pos.func_177982_a(-8, 0, 0));
            }
        } else if (next == 5) {
            this.generateWest(world, rand, pos.func_177982_a(-8, 0, 0));
            if (rand.nextInt(this.split) == 0) {
                this.generateEast(world, rand, pos.func_177982_a(8, 0, 0));
            }
        }
        return true;
    }

    public boolean generateNorth(World world, Random rand, BlockPos pos) {
        int next;
        TileEntity chest;
        int vert;
        int hor;
        int space = rand.nextInt(20);
        int distance = 19 - space;
        pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - distance);
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 4; ++y) {
                    world.func_175698_g(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 9; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        if (rand.nextInt(2) == 0) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176458_f(world, pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P()), 2);
        }
        if ((chest = world.func_175625_s(pos.func_177984_a())) instanceof TileEntityChest) {
            if (this.netherDungeon && rand.nextInt(2) == 0) {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
            } else {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
            }
        }
        world.func_180501_a(pos.func_177981_b(2), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177981_b(2));
        if (mobspawner instanceof TileEntityMobSpawner) {
            mobspawner.func_145881_a().func_190894_a(this.pickMobSpawner(rand));
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 2 + ", " + pos.func_177952_p() + ")");
        }
        for (int n = space; n < 20; ++n) {
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177970_e(4).func_177970_e(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177970_e(4).func_177970_e(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177970_e(4).func_177970_e(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177974_f().func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177974_f().func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177974_f().func_177970_e(4).func_177970_e(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177974_f().func_177970_e(4).func_177970_e(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177974_f().func_177970_e(4).func_177970_e(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177976_e().func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177976_e().func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177976_e().func_177970_e(4).func_177970_e(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177976_e().func_177970_e(4).func_177970_e(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177976_e().func_177970_e(4).func_177970_e(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177974_f().func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177974_f().func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177976_e().func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177976_e().func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177965_g(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177965_g(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177985_f(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177985_f(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177965_g(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177965_g(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177985_f(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177985_f(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177965_g(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177965_g(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177985_f(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177985_f(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177965_g(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177965_g(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177985_f(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177985_f(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(2).func_177965_g(2).func_177970_e(4).func_177970_e(n - space))) {
                world.func_180501_a(pos.func_177981_b(2).func_177965_g(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, pos.func_177981_b(2).func_177985_f(2).func_177970_e(4).func_177970_e(n - space))) continue;
            world.func_180501_a(pos.func_177981_b(2).func_177985_f(2).func_177970_e(4).func_177970_e(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (rand.nextInt(this.trap) == 0) {
            if (rand.nextInt(2) == 0) {
                this.buildDartTrap(world, pos.func_177970_e(3).func_177984_a(), rand, "north");
            } else {
                int r = space / 2;
                if (r < 1) {
                    r = 1;
                }
                this.placeTrapPlate(world, pos.func_177970_e(3 + rand.nextInt(r)).func_177984_a(), rand);
            }
        }
        if ((next = rand.nextInt(5)) == 0 && pos.func_177956_o() > 10) {
            this.generateDown(world, rand, pos.func_177982_a(0, -5, 0));
        } else if (next == 2) {
            this.generateNorth(world, rand, pos.func_177982_a(0, 0, -8));
        } else if (next == 3) {
            this.generateEast(world, rand, pos.func_177982_a(8, 0, 0));
            if (rand.nextInt(this.split) == 0) {
                this.generateWest(world, rand, pos.func_177982_a(-8, 0, 0));
            }
        } else if (next == 4) {
            this.generateWest(world, rand, pos.func_177982_a(-8, 0, 0));
            if (rand.nextInt(this.split) == 0) {
                this.generateEast(world, rand, pos.func_177982_a(8, 0, 0));
            }
        }
        return true;
    }

    public boolean generateSouth(World world, Random rand, BlockPos pos) {
        int next;
        TileEntity chest;
        int vert;
        int hor;
        int space = rand.nextInt(20);
        int distance = 19 - space;
        pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + distance);
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 4; ++y) {
                    world.func_175698_g(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 9; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        if (rand.nextInt(2) == 0) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176458_f(world, pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P()), 2);
        }
        if ((chest = world.func_175625_s(pos.func_177984_a())) instanceof TileEntityChest) {
            if (this.netherDungeon && rand.nextInt(2) == 0) {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
            } else {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
            }
        }
        world.func_180501_a(pos.func_177981_b(2), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177981_b(2));
        if (mobspawner instanceof TileEntityMobSpawner) {
            mobspawner.func_145881_a().func_190894_a(this.pickMobSpawner(rand));
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 2 + ", " + pos.func_177952_p() + ")");
        }
        for (int n = space; n < 20; ++n) {
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177964_d(4).func_177964_d(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177964_d(4).func_177964_d(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177964_d(4).func_177964_d(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177974_f().func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177974_f().func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177974_f().func_177964_d(4).func_177964_d(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177974_f().func_177964_d(4).func_177964_d(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177974_f().func_177964_d(4).func_177964_d(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177976_e().func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177976_e().func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177976_e().func_177964_d(4).func_177964_d(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177976_e().func_177964_d(4).func_177964_d(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177976_e().func_177964_d(4).func_177964_d(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177974_f().func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177974_f().func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177976_e().func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177976_e().func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177965_g(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177965_g(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177985_f(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177985_f(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177965_g(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177965_g(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177985_f(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177985_f(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177965_g(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177965_g(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177985_f(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177985_f(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177965_g(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177965_g(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177985_f(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177985_f(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(2).func_177965_g(2).func_177964_d(4).func_177964_d(n - space))) {
                world.func_180501_a(pos.func_177981_b(2).func_177965_g(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, pos.func_177981_b(2).func_177985_f(2).func_177964_d(4).func_177964_d(n - space))) continue;
            world.func_180501_a(pos.func_177981_b(2).func_177985_f(2).func_177964_d(4).func_177964_d(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (rand.nextInt(this.trap) == 0) {
            if (rand.nextInt(2) == 0) {
                this.buildDartTrap(world, pos.func_177964_d(3).func_177984_a(), rand, "south");
            } else {
                int r = space / 2;
                if (r < 1) {
                    r = 1;
                }
                this.placeTrapPlate(world, pos.func_177964_d(3 + rand.nextInt(r)).func_177984_a(), rand);
            }
        }
        if ((next = rand.nextInt(5)) == 0 && pos.func_177956_o() > 10) {
            this.generateDown(world, rand, pos.func_177982_a(0, -5, 0));
        } else if (next == 2) {
            this.generateSouth(world, rand, pos.func_177982_a(0, 0, 8));
        } else if (next == 3) {
            this.generateEast(world, rand, pos.func_177982_a(8, 0, 0));
            if (rand.nextInt(this.split) == 0) {
                this.generateWest(world, rand, pos.func_177982_a(-8, 0, 0));
            }
        } else if (next == 4) {
            this.generateWest(world, rand, pos.func_177982_a(-8, 0, 0));
            if (rand.nextInt(this.split) == 0) {
                this.generateEast(world, rand, pos.func_177982_a(8, 0, 0));
            }
        }
        return true;
    }

    public boolean generateEast(World world, Random rand, BlockPos pos) {
        int next;
        TileEntity chest;
        int vert;
        int hor;
        int space = rand.nextInt(20);
        int distance = 19 - space;
        pos = new BlockPos(pos.func_177958_n() + distance, pos.func_177956_o(), pos.func_177952_p());
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 4; ++y) {
                    world.func_175698_g(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 9; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        if (rand.nextInt(2) == 0) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176458_f(world, pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P()), 2);
        }
        if ((chest = world.func_175625_s(pos.func_177984_a())) instanceof TileEntityChest) {
            if (this.netherDungeon && rand.nextInt(2) == 0) {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
            } else {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
            }
        }
        world.func_180501_a(pos.func_177981_b(2), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177981_b(2));
        if (mobspawner instanceof TileEntityMobSpawner) {
            mobspawner.func_145881_a().func_190894_a(this.pickMobSpawner(rand));
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 2 + ", " + pos.func_177952_p() + ")");
        }
        for (int n = space; n < 20; ++n) {
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177985_f(4).func_177985_f(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177985_f(4).func_177985_f(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177985_f(4).func_177985_f(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177978_c().func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177978_c().func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177978_c().func_177985_f(4).func_177985_f(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177978_c().func_177985_f(4).func_177985_f(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177978_c().func_177985_f(4).func_177985_f(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177968_d().func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177968_d().func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177968_d().func_177985_f(4).func_177985_f(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177968_d().func_177985_f(4).func_177985_f(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177968_d().func_177985_f(4).func_177985_f(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177978_c().func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177978_c().func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177968_d().func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177968_d().func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177964_d(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177964_d(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177970_e(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177970_e(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177964_d(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177964_d(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177970_e(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177970_e(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177964_d(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177964_d(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177970_e(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177970_e(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177964_d(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177964_d(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177970_e(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177970_e(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(2).func_177964_d(2).func_177985_f(4).func_177985_f(n - space))) {
                world.func_180501_a(pos.func_177981_b(2).func_177964_d(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, pos.func_177981_b(2).func_177970_e(2).func_177985_f(4).func_177985_f(n - space))) continue;
            world.func_180501_a(pos.func_177981_b(2).func_177970_e(2).func_177985_f(4).func_177985_f(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (rand.nextInt(this.trap) == 0) {
            if (rand.nextInt(2) == 0) {
                this.buildDartTrap(world, pos.func_177985_f(3).func_177984_a(), rand, "east");
            } else {
                int r = space / 2;
                if (r < 1) {
                    r = 1;
                }
                this.placeTrapPlate(world, pos.func_177985_f(3 + rand.nextInt(r)).func_177984_a(), rand);
            }
        }
        if ((next = rand.nextInt(5)) == 0 && pos.func_177956_o() > 10) {
            this.generateDown(world, rand, pos.func_177982_a(0, -5, 0));
        } else if (next == 2) {
            this.generateNorth(world, rand, pos.func_177982_a(0, 0, -8));
            if (rand.nextInt(this.split) == 0) {
                this.generateSouth(world, rand, pos.func_177982_a(0, 0, 8));
            }
        } else if (next == 3) {
            this.generateSouth(world, rand, pos.func_177982_a(0, 0, 8));
            if (rand.nextInt(this.split) == 0) {
                this.generateNorth(world, rand, pos.func_177982_a(0, 0, -8));
            }
        } else if (next == 4) {
            this.generateEast(world, rand, pos.func_177982_a(8, 0, 0));
        }
        return true;
    }

    public boolean generateWest(World world, Random rand, BlockPos pos) {
        int next;
        TileEntity chest;
        int vert;
        int hor;
        int space = rand.nextInt(20);
        int distance = 19 - space;
        pos = new BlockPos(pos.func_177958_n() - distance, pos.func_177956_o(), pos.func_177952_p());
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 4; ++y) {
                    world.func_175698_g(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 9; ++vert) {
                if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        if (rand.nextInt(2) == 0) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176458_f(world, pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P()), 2);
        }
        if ((chest = world.func_175625_s(pos.func_177984_a())) instanceof TileEntityChest) {
            if (this.netherDungeon && rand.nextInt(2) == 0) {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
            } else {
                ((TileEntityChest)chest).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
            }
        }
        world.func_180501_a(pos.func_177981_b(2), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177981_b(2));
        if (mobspawner instanceof TileEntityMobSpawner) {
            mobspawner.func_145881_a().func_190894_a(this.pickMobSpawner(rand));
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 2 + ", " + pos.func_177952_p() + ")");
        }
        for (int n = space; n < 20; ++n) {
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177965_g(4).func_177965_g(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177965_g(4).func_177965_g(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177965_g(4).func_177965_g(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177978_c().func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177978_c().func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177978_c().func_177965_g(4).func_177965_g(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177978_c().func_177965_g(4).func_177965_g(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177978_c().func_177965_g(4).func_177965_g(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177968_d().func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177968_d().func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_175698_g(pos.func_177984_a().func_177968_d().func_177965_g(4).func_177965_g(n - space));
            world.func_175698_g(pos.func_177981_b(2).func_177968_d().func_177965_g(4).func_177965_g(n - space));
            world.func_175698_g(pos.func_177981_b(3).func_177968_d().func_177965_g(4).func_177965_g(n - space));
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177978_c().func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177978_c().func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177968_d().func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177968_d().func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177964_d(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177964_d(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177970_e(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177970_e(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177964_d(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177964_d(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(4).func_177970_e(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(4).func_177970_e(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177964_d(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177964_d(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177984_a().func_177970_e(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177984_a().func_177970_e(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177964_d(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177964_d(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(3).func_177970_e(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(3).func_177970_e(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.isVoid || this.biome == Biomes.field_76778_j || this.terrainHelper(world, pos.func_177981_b(2).func_177964_d(2).func_177965_g(4).func_177965_g(n - space))) {
                world.func_180501_a(pos.func_177981_b(2).func_177964_d(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (!this.isVoid && this.biome != Biomes.field_76778_j && !this.terrainHelper(world, pos.func_177981_b(2).func_177970_e(2).func_177965_g(4).func_177965_g(n - space))) continue;
            world.func_180501_a(pos.func_177981_b(2).func_177970_e(2).func_177965_g(4).func_177965_g(n - space), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (rand.nextInt(this.trap) == 0) {
            if (rand.nextInt(2) == 0) {
                this.buildDartTrap(world, pos.func_177965_g(3).func_177984_a(), rand, "west");
            } else {
                int r = space / 2;
                if (r < 1) {
                    r = 1;
                }
                this.placeTrapPlate(world, pos.func_177965_g(3 + rand.nextInt(r)).func_177984_a(), rand);
            }
        }
        if ((next = rand.nextInt(5)) == 0 && pos.func_177956_o() > 10) {
            this.generateDown(world, rand, pos.func_177982_a(0, -5, 0));
        } else if (next == 2) {
            this.generateNorth(world, rand, pos.func_177982_a(0, 0, -8));
            if (rand.nextInt(this.split) == 0) {
                this.generateSouth(world, rand, pos.func_177982_a(0, 0, 8));
            }
        } else if (next == 3) {
            this.generateSouth(world, rand, pos.func_177982_a(0, 0, 8));
            if (rand.nextInt(this.split) == 0) {
                this.generateNorth(world, rand, pos.func_177982_a(0, 0, -8));
            }
        } else if (next == 4) {
            this.generateWest(world, rand, pos.func_177982_a(-8, 0, 0));
        }
        return true;
    }

    private boolean buildDartTrap(World world, BlockPos pos, Random rand, String dir) {
        TileEntity dispenser;
        if (dir == "north" || dir == "south") {
            world.func_180501_a(pos.func_177965_g(4).func_177984_a(), Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)EnumFacing.WEST), 2);
            dispenser = world.func_175625_s(pos.func_177965_g(4).func_177984_a());
            if (dispenser instanceof TileEntityDispenser) {
                ((TileEntityDispenser)dispenser).func_189404_a(LootTableList.field_189420_m, rand.nextLong());
            }
            if (world.func_175623_d(pos.func_177965_g(4))) {
                world.func_180501_a(pos.func_177965_g(4), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_180501_a(pos.func_177965_g(3), Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 2);
            if (world.func_175623_d(pos.func_177985_f(4))) {
                world.func_180501_a(pos.func_177985_f(4), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_180501_a(pos.func_177985_f(3), Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177965_g(2), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177985_f(2), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177974_f(), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177976_e(), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (dir == "east" || dir == "west") {
            world.func_180501_a(pos.func_177970_e(4).func_177984_a(), Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)EnumFacing.NORTH), 2);
            dispenser = world.func_175625_s(pos.func_177970_e(4).func_177984_a());
            if (dispenser instanceof TileEntityDispenser) {
                ((TileEntityDispenser)dispenser).func_189404_a(LootTableList.field_189420_m, rand.nextLong());
            }
            if (world.func_175623_d(pos.func_177964_d(4))) {
                world.func_180501_a(pos.func_177964_d(4), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_180501_a(pos.func_177964_d(3), Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 2);
            if (world.func_175623_d(pos.func_177970_e(4))) {
                world.func_180501_a(pos.func_177970_e(4), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            world.func_180501_a(pos.func_177970_e(3), Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177964_d(2), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177970_e(2), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177978_c(), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos.func_177968_d(), Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(pos, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2);
        }
        return true;
    }

    public boolean placeTrapPlate(World world, BlockPos pos, Random rand) {
        Block varient = trapVarient.get(rand.nextInt(trapVarient.size()));
        BlockPos loc = new BlockPos(pos.func_177958_n() + rand.nextInt(2) - rand.nextInt(2), pos.func_177956_o(), pos.func_177952_p() + rand.nextInt(2) - rand.nextInt(2));
        if (world.func_175623_d(loc) && varient.func_176196_c(world, loc)) {
            world.func_180501_a(loc, varient.func_176223_P(), 2);
        }
        return true;
    }

    private ResourceLocation pickMobSpawner(Random rand) {
        if (this.netherDungeon) {
            switch (rand.nextInt(3)) {
                case 0: {
                    return new ResourceLocation("blaze");
                }
                case 1: {
                    return new ResourceLocation("pigzombie");
                }
                case 2: {
                    return new ResourceLocation("skeleton");
                }
            }
            return new ResourceLocation("blaze");
        }
        return DungeonHooks.getRandomDungeonMob((Random)rand);
    }

    private boolean terrainHelper(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block != Blocks.field_150350_a;
    }

    private Block useBlock(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherDungeon) {
            return Blocks.field_150385_bj;
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s) {
            return Blocks.field_150322_A;
        }
        if (this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_180395_cM;
        }
        int block = world.field_73012_v.nextInt(9);
        Block result = block == 0 ? Blocks.field_150418_aU : Blocks.field_150417_aV;
        return result;
    }

    private Block useStair(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherDungeon) {
            return Blocks.field_150387_bl;
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s) {
            return Blocks.field_150372_bz;
        }
        if (this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_180396_cN;
        }
        return Blocks.field_150390_bg;
    }

    private IBlockState useLog(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherDungeon) {
            return DTBlocks.obsidianBrick.func_176223_P();
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s || this.biome == Biomes.field_150588_X || this.biome == Biomes.field_150587_Y || this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_150363_s.func_176223_P();
        }
        return Blocks.field_150364_r.func_176203_a(1);
    }

    private IBlockState useSlab(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherDungeon) {
            return Blocks.field_150333_U.func_176203_a(6);
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s) {
            return Blocks.field_150333_U.func_176203_a(1);
        }
        if (this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_180389_cP.func_176203_a(0);
        }
        return Blocks.field_150333_U.func_176203_a(0);
    }
}

