/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Blocks;

import PegBeard.DungeonTactics.Handlers.DTBlocks;
import PegBeard.DungeonTactics.Handlers.DTCreativeTab;
import PegBeard.DungeonTactics.Items.DTKnife;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class DTFlower
extends BlockBush {
    public DTFlower(int meta) {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149672_a(Block.field_149779_h);
        this.func_149711_c(0.2f);
        this.func_149647_a(DTCreativeTab.DT_TAB);
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", "DungeonTactics".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        this.field_149761_L = icon.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(".") + 1));
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K && rand.nextInt(25) == 0) {
            int k1;
            int j1;
            int i1;
            int b0 = 4;
            int l = 5;
            for (i1 = x - b0; i1 <= x + b0; ++i1) {
                for (j1 = z - b0; j1 <= z + b0; ++j1) {
                    for (k1 = y - 1; k1 <= y + 1; ++k1) {
                        if (world.func_147439_a(i1, k1, j1) != this || --l > 0) continue;
                        return;
                    }
                }
            }
            i1 = x + rand.nextInt(3) - 1;
            j1 = y + rand.nextInt(2) - rand.nextInt(2);
            k1 = z + rand.nextInt(3) - 1;
            for (int l1 = 0; l1 < 4; ++l1) {
                if (world.func_147437_c(i1, j1, k1) && this.func_149718_j(world, i1, j1, k1)) {
                    x = i1;
                    y = j1;
                    z = k1;
                }
                i1 = x + rand.nextInt(3) - 1;
                j1 = y + rand.nextInt(2) - rand.nextInt(2);
                k1 = z + rand.nextInt(3) - 1;
            }
            if (world.func_147437_c(i1, j1, k1) && this.func_149718_j(world, i1, j1, k1)) {
                world.func_147465_d(i1, j1, k1, (Block)this, 0, 2);
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    protected boolean func_149854_a(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == Blocks.field_150391_bh || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150344_f || block == Blocks.field_150347_e || block == Blocks.field_150341_Y || block == Blocks.field_150348_b || block == Blocks.field_150417_aV || block == Blocks.field_150351_n || block == Blocks.field_150354_m || block == Blocks.field_150322_A || block == Blocks.field_150435_aG || block == Blocks.field_150336_V || block == Blocks.field_150405_ch || block == Blocks.field_150406_ce || block == Blocks.field_150377_bs || block == Blocks.field_150407_cf || block == Blocks.field_150424_aL || block == Blocks.field_150385_bj || block == Blocks.field_150425_aM || block == Blocks.field_150365_q || block == Blocks.field_150366_p || block == Blocks.field_150352_o || block == Blocks.field_150482_ag || block == Blocks.field_150369_x || block == Blocks.field_150450_ax || block == Blocks.field_150449_bY;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        super.func_149699_a(world, x, y, z, player);
        this.doEffect(world, (Entity)player, x, y, z);
        if (player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemShears || player.func_71045_bC().func_77973_b() instanceof ItemSword)) {
            this.func_149711_c(0.0f);
        } else {
            this.func_149711_c(0.2f);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int i, EntityPlayer player) {
        if (player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemShears || player.func_71045_bC().func_77973_b() instanceof DTKnife)) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, new ItemStack((Block)this));
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        } else {
            int drop = world.field_73012_v.nextInt(3);
            if (drop == 0) {
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, new ItemStack((Block)this));
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public Item func_149650_a(int i, Random rand, int j) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        float particleX = (float)x + rand.nextFloat();
        float particleY = (float)y + rand.nextFloat();
        float particleZ = (float)z + rand.nextFloat();
        float motionX = rand.nextFloat() - 0.5f;
        float motionY = rand.nextFloat() - 0.5f;
        float motionZ = rand.nextFloat() - 0.5f;
        if (this == DTBlocks.flowerCinder) {
            world.func_72869_a("flame", (double)particleX, (double)particleY, (double)particleZ, 0.0, 0.0, 0.0);
        } else if (this == DTBlocks.flowerFade) {
            world.func_72869_a("portal", (double)particleX, (double)particleY, (double)particleZ, (double)motionX, (double)motionY, (double)motionZ);
        } else {
            world.func_72869_a("magicCrit", (double)particleX, (double)particleY, (double)particleZ, 0.0, 0.0, 0.0);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (world.field_72995_K) {
                this.doParticles(world, x, y, z);
            }
            if (!world.field_72995_K) {
                this.doEffect(world, entity, x, y, z);
                this.doTrample(world, x, y, z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        Random random = world.field_73012_v;
        double d0 = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)x + random.nextFloat();
            double d2 = (float)y + random.nextFloat();
            double d3 = (float)z + random.nextFloat();
            if (l == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                d2 = (double)(y + 1) + d0;
            }
            if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                d2 = (double)(y + 0) - d0;
            }
            if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                d3 = (double)(z + 1) + d0;
            }
            if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                d3 = (double)(z + 0) - d0;
            }
            if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                d1 = (double)(x + 1) + d0;
            }
            if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                d1 = (double)(x + 0) - d0;
            }
            if (!(d1 < (double)x || d1 > (double)(x + 1) || d2 < (double)y || d2 > (double)(y + 1) || d3 < (double)z) && !(d3 > (double)(z + 1))) continue;
            if (this == DTBlocks.flowerCinder) {
                world.func_72869_a("flame", d1, d2, d3, 0.0, 0.0, 0.0);
                continue;
            }
            if (this == DTBlocks.flowerFade) {
                for (int i = 0; i < 20; ++i) {
                    world.func_72869_a("portal", (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian());
                }
                continue;
            }
            world.func_72869_a("magicCrit", d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    private void doEffect(World world, Entity entity, int x, int y, int z) {
        EntityLivingBase entityL = (EntityLivingBase)entity;
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerSanguine) {
            entityL.func_70691_i(0.5f);
        }
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerXp && !world.field_72995_K) {
            int j;
            for (int i = 3 + world.field_73012_v.nextInt(5) + world.field_73012_v.nextInt(5); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)x, (double)y, (double)z, j));
            }
        }
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerBramble) {
            entityL.func_70097_a(DamageSource.field_76377_j, 0.5f);
        }
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerBark) {
            entityL.func_70690_d(new PotionEffect(Potion.field_76429_m.func_76396_c(), 100, 0));
        }
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerCinder) {
            entityL.func_70015_d(6);
        }
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerTangle) {
            entityL.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 100, 2));
        }
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerAilment) {
            entityL.func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 100, 0));
        }
        if (world.func_147439_a(x, y, z) == DTBlocks.flowerFade) {
            entityL.func_70107_b(entity.field_70165_t + world.field_73012_v.nextGaussian() * 10.0, entity.field_70163_u + world.field_73012_v.nextGaussian() * 10.0, entity.field_70161_v + world.field_73012_v.nextGaussian() * 10.0);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70634_a(entity.field_70165_t + world.field_73012_v.nextGaussian(), entity.field_70163_u + world.field_73012_v.nextGaussian(), entity.field_70161_v + world.field_73012_v.nextGaussian());
                if (entity.field_70163_u <= 1.0) {
                    ((EntityPlayer)entity).func_70634_a(entity.field_70165_t, 3.0, entity.field_70161_v);
                }
            }
            world.func_72908_a((double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "mob.endermen.portal", 0.3f, 0.5f);
        }
    }

    public void doTrample(World world, int x, int y, int z) {
        int trample = world.field_73012_v.nextInt(5);
        if (trample < 2) {
            return;
        }
        if (trample == 2) {
            world.func_147468_f(x, y, z);
            world.func_72908_a((double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "dig.grass", 1.0f, 0.9f);
            world.func_72869_a("blockcrack_" + Block.func_149682_b((Block)world.func_147439_a(x, y, z)) + "_" + world.func_72805_g(x, y, z), (double)((float)x + 0.5f), (double)((float)y + 1.5f), (double)((float)z + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian());
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, new ItemStack((Block)this));
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
            return;
        }
        world.func_147468_f(x, y, z);
        world.func_72908_a((double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "dig.grass", 1.0f, 0.9f);
        world.func_72869_a("blockcrack_" + Block.func_149682_b((Block)world.func_147439_a(x, y, z)) + "_" + world.func_72805_g(x, y - 1, z), (double)((float)x + 0.5f), (double)((float)y + 1.5f), (double)((float)z + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian());
    }
}

