/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import PegBeard.DungeonTactics.Entities.EntityHuckling;
import PegBeard.DungeonTactics.Handlers.DTEntityData;
import PegBeard.DungeonTactics.Handlers.DTItems;
import PegBeard.DungeonTactics.Items.DTArmour;
import PegBeard.DungeonTactics.Items.DTHammer;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.BlockEvent;

public class DTEventHandler {
    protected static Random eventRand;
    protected static int doDrop;
    protected int coolDown = 100;
    private static final List<Item> applicableSwords;

    public DTEventHandler() {
        applicableSwords.add(Items.field_151041_m);
        applicableSwords.add(Items.field_151052_q);
        applicableSwords.add(Items.field_151040_l);
        applicableSwords.add(Items.field_151010_B);
        applicableSwords.add(Items.field_151048_u);
        applicableSwords.add(DTItems.gildedSword);
        applicableSwords.add(DTItems.jewelledSword);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && DTEntityData.getPlayerDT((EntityPlayer)event.entity) == null) {
            DTEntityData.registerPlayerDT((EntityPlayer)event.entity);
        }
        if (event.entity instanceof EntityMob && DTEntityData.getMobDT((EntityMob)event.entity) == null) {
            DTEntityData.registerMobDT((EntityMob)event.entity);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DTEntityData.getPlayerDT((EntityPlayer)event.entity).onUpdate();
        }
        if (event.entity instanceof EntityMob) {
            DTEntityData.getMobDT((EntityMob)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entity.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        Entity target = event.target;
        ItemStack stack = player.func_71045_bC();
        if (target.getClass() == EntityChicken.class && stack != null && stack.func_77973_b() == Items.field_151057_cb) {
            EntityChicken chicken = (EntityChicken)target;
            if (!chicken.field_70128_L && !chicken.func_70631_g_() && "Huckling".equals(stack.func_82833_r())) {
                EntityHuckling.spawnHuckling(chicken);
            }
        }
        if (target.getClass() == EntityHuckling.class && stack != null && !event.entity.field_70170_p.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            if (stack.func_77973_b() == Items.field_151106_aX) {
                ((EntityHuckling)target).dropCookiePresent(stack, event.entity.field_70170_p, target);
            }
            if (stack.func_77973_b() == Items.field_151105_aU) {
                ((EntityHuckling)target).dropCakePresent(stack, event.entity.field_70170_p, target);
            }
        }
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack armor;
        if (event.entityLiving instanceof EntityPlayer && (armor = (player = (EntityPlayer)event.entityLiving).func_82169_q(1)) != null && armor.func_77973_b() == DTItems.rexoLeggings) {
            DTArmour.burst(player.field_70170_p, player, armor);
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.func_82169_q(0) != null && player.func_82169_q(0).func_77973_b() == DTItems.rexoBoots && event.distance >= 1.5f) {
                DTArmour.bounce(player.field_70170_p, player, player.func_82169_q(0), event.distance);
                if (!player.field_70170_p.field_72995_K) {
                    event.distance /= 2.0f;
                }
            }
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == DTItems.pbh) {
                event.distance = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        EntityMob mob;
        if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityMob && (mob = (EntityMob)event.source.func_76346_g()).func_71124_b(0) != null && mob.func_71124_b(0).func_77973_b() instanceof DTHammer && DTEntityData.getMobDT(mob).getStamina() > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        EntityMob mob;
        ItemStack stack;
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer) {
            player = (EntityPlayer)event.entityLiving;
            stack = player.func_71045_bC();
            if (event.ammount >= event.entityLiving.func_110143_aJ() && player.field_71071_by.func_146028_b(DTItems.phylactery) && player.field_71068_ca >= 5) {
                player.func_70691_i(player.func_110138_aP());
                player.func_82242_a(-5);
                player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 40, 2));
                player.field_71071_by.func_146026_a(DTItems.phylactery);
                player.field_70170_p.func_72956_a((Entity)player, "mob.wither.spawn", 1.0f, 1.0f);
                event.setCanceled(true);
            }
            if (stack != null && applicableSwords.contains(stack.func_77973_b())) {
                DTEntityData props = DTEntityData.getPlayerDT(player);
                if (player.func_70632_aY() && applicableSwords.contains(stack.func_77973_b()) && (props.getStamina() <= 0 || player.field_71075_bZ.field_75098_d)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        props.consumeStamina(60);
                    }
                    player.func_71059_n(event.source.func_76346_g());
                    player.field_70172_ad += 20;
                }
            }
            if (stack != null && stack.func_77973_b() == DTItems.pbh && event.source.func_94541_c()) {
                event.setCanceled(true);
            }
        }
        if (event.entityLiving instanceof EntityMob && event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77973_b() instanceof DTHammer && player.field_70724_aR > 0) {
            event.setCanceled(true);
        }
        if (event.entityLiving instanceof EntityHuckling && event.ammount >= event.entityLiving.func_110143_aJ()) {
            boolean flag = event.entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            event.entityLiving.field_70170_p.func_72876_a(event.entity, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 1.0f, flag);
        }
        if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityMob && (mob = (EntityMob)event.source.func_76346_g()).func_71124_b(0) != null && mob.func_71124_b(0).func_77973_b() instanceof DTHammer) {
            DTEntityData.getMobDT(mob).consumeStamina(20);
        }
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent event) {
        if (event.item.func_92059_d().func_77973_b() == DTItems.heartDrop) {
            event.item.func_70106_y();
            event.setCanceled(true);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.successful_hit", 0.2f, 1.0f / (event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f));
            if (event.entityPlayer.field_71071_by.func_146028_b(Items.field_151069_bo) && event.entityPlayer.func_110143_aJ() == event.entityPlayer.func_110138_aP()) {
                if (!event.entityPlayer.field_70170_p.field_72995_K) {
                    event.entityPlayer.field_71071_by.func_146026_a(Items.field_151069_bo);
                    event.entityPlayer.field_71071_by.func_70441_a(new ItemStack(DTItems.heartJar));
                }
            } else {
                event.entityPlayer.func_70691_i(2.0f);
                DTEntityData.getPlayerDT(event.entityPlayer).replenishStamina();
            }
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        EntityPigZombie pigman;
        EntitySkeleton skeleton;
        EntityZombie zombie;
        eventRand = new Random();
        int i = eventRand.nextInt(100);
        if (event.entity instanceof EntityZombie && (zombie = (EntityZombie)event.entity).func_71124_b(0) != null && zombie.func_71124_b(0).func_77973_b() == Items.field_151040_l) {
            if (i < 50) {
                event.entity.func_70062_b(0, new ItemStack(DTItems.ironHammer));
            } else {
                return;
            }
        }
        if (event.entity instanceof EntitySkeleton && (skeleton = (EntitySkeleton)event.entity).func_71124_b(0) != null) {
            if (skeleton.func_82202_m() == 0) {
                if (i < 20) {
                    skeleton.func_70062_b(0, new ItemStack(DTItems.ironKnife));
                } else {
                    return;
                }
            }
            if (skeleton.func_82202_m() == 1) {
                if (i < 40) {
                    skeleton.func_70062_b(0, new ItemStack(DTItems.stoneHammer));
                } else {
                    return;
                }
            }
        }
        if (event.entity instanceof EntityPigZombie && (pigman = (EntityPigZombie)event.entity).func_71124_b(0) != null) {
            if (i < 40) {
                event.entity.func_70062_b(0, new ItemStack(DTItems.goldenHammer));
            } else {
                return;
            }
        }
    }

    public ItemStack getLootBag() {
        switch (eventRand.nextInt(6)) {
            case 0: {
                return new ItemStack(DTItems.foodBag);
            }
            case 1: {
                return new ItemStack(DTItems.oreBag);
            }
            case 2: {
                return new ItemStack(DTItems.toolBag);
            }
            case 3: {
                return new ItemStack(DTItems.bookBag);
            }
            case 4: {
                return new ItemStack(DTItems.recordBag);
            }
            case 5: {
                return new ItemStack(DTItems.recordBag);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        eventRand = new Random();
        doDrop = eventRand.nextInt(100);
        if (!event.entityLiving.field_70170_p.field_72995_K && event.recentlyHit) {
            if (event.entityLiving instanceof EntityAnimal && doDrop <= 5) {
                event.entityLiving.func_70099_a(new ItemStack(DTItems.heartDrop), 1.0f);
            }
            if (event.entityLiving instanceof EntityMob) {
                if (doDrop <= 10) {
                    event.entityLiving.func_70099_a(new ItemStack(DTItems.heartDrop), (float)(eventRand.nextInt(1) + 1));
                }
                if (doDrop >= 5 && doDrop <= 15) {
                    event.entityLiving.func_70099_a(this.getLootBag(), 1.0f);
                }
            }
            if (event.entityLiving instanceof EntityWither || event.entityLiving instanceof EntityDragon) {
                event.entityLiving.func_70099_a(new ItemStack(DTItems.heartDrop), (float)(3 + eventRand.nextInt(3)));
                event.entityLiving.func_70099_a(new ItemStack(DTItems.heartJar), (float)eventRand.nextInt(3));
                event.entityLiving.func_70099_a(new ItemStack(DTItems.heartGolden), (float)eventRand.nextInt(2));
                if (doDrop <= 20) {
                    event.entityLiving.func_70099_a(this.getLootBag(), 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        int i;
        if (event.isSilkTouching) {
            return;
        }
        if (event.drops.isEmpty()) {
            return;
        }
        int count = this.randomCount(event.drops.size(), event.fortuneLevel, event.world);
        if (event.block == Blocks.field_150366_p) {
            event.drops.clear();
            for (i = 0; i < count; ++i) {
                event.drops.add(new ItemStack(DTItems.ironCluster, 1));
            }
        }
        if (event.block == Blocks.field_150352_o) {
            event.drops.clear();
            for (i = 0; i < count; ++i) {
                event.drops.add(new ItemStack(DTItems.goldCluster, 1));
            }
        }
    }

    private int randomCount(int baseCount, int fortuneLevel, World world) {
        if (fortuneLevel > 0) {
            int j = world.field_73012_v.nextInt(fortuneLevel + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return baseCount * (j + 1);
        }
        return baseCount;
    }

    static {
        applicableSwords = Lists.newArrayList();
    }
}

