/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Entities;

import PegBeard.DungeonTactics.Handlers.DTItems;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityTowerGuardian
extends EntityPigZombie {
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, 0).func_111168_a(false);
    private int angerLevel;
    private UUID angerTargetUUID;
    private int randomSoundDelay;

    public EntityTowerGuardian(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_85156_a((EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true));
        this.field_70178_ae = false;
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityZombie.class, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntitySkeleton.class, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntitySpider.class, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySpider.class, true));
    }

    protected void applyChallengeAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void removeChallengeAI() {
        this.field_70714_bg.func_85156_a((EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70715_bh.func_85156_a((EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            if (!(this.func_175457_ck() || player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemSword)) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + "Ready your weapon, Adventurer."));
            }
            if (!this.func_175457_ck() && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemSword) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "I accept your challenge, Mortal."));
                this.func_70604_c((EntityLivingBase)player);
                this.angerLevel = 2400;
                this.applyChallengeAI();
            }
        }
        return super.func_70085_c(player);
    }

    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.func_175457_ck()) {
            if (!this.func_70631_g_() && !iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
            if (this.angerLevel <= 0) {
                this.removeChallengeAI();
            }
        } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_85030_a("mob.skeleton.say", this.func_70599_aP() * 2.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.func_70643_av() == null) {
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            this.field_70717_bb = entityplayer;
            this.field_70718_bc = this.func_142015_aE();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            if (this.angerLevel <= 0 && !this.field_70170_p.field_72995_K) {
                ((EntityPlayer)source.func_76346_g()).func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "On guard, honourless Naive."));
            }
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
            this.angerLevel = 2400;
            this.applyChallengeAI();
        }
        return super.func_70097_a(source, amount);
    }

    public void func_180481_a(DifficultyInstance difficulty) {
        int e = this.field_70146_Z.nextInt(4);
        int w = this.field_70146_Z.nextInt(3);
        if (e == 0) {
            this.func_70062_b(4, new ItemStack(DTItems.gildedHelmet));
            this.func_70062_b(3, new ItemStack(DTItems.gildedChestplate));
            this.func_70062_b(2, new ItemStack(DTItems.gildedLeggings));
            this.func_70062_b(1, new ItemStack(DTItems.gildedBoots));
            if (w == 0) {
                this.func_70062_b(0, new ItemStack(DTItems.gildedSword));
            } else if (w == 1) {
                this.func_70062_b(0, new ItemStack(DTItems.gildedHammer));
            } else {
                this.func_70062_b(0, new ItemStack(DTItems.gildedKnife));
            }
        } else if (e == 1) {
            this.func_70062_b(4, new ItemStack(DTItems.jewelledHelmet));
            this.func_70062_b(3, new ItemStack(DTItems.jewelledChestplate));
            this.func_70062_b(2, new ItemStack(DTItems.jewelledLeggings));
            this.func_70062_b(1, new ItemStack(DTItems.jewelledBoots));
            if (w == 0) {
                this.func_70062_b(0, new ItemStack(DTItems.jewelledSword));
            } else if (w == 1) {
                this.func_70062_b(0, new ItemStack(DTItems.jewelledHammer));
            } else {
                this.func_70062_b(0, new ItemStack(DTItems.jewelledKnife));
            }
        } else {
            this.func_70062_b(4, new ItemStack((Item)Items.field_151028_Y));
            this.func_70062_b(3, new ItemStack((Item)Items.field_151030_Z));
            this.func_70062_b(2, new ItemStack((Item)Items.field_151165_aa));
            this.func_70062_b(1, new ItemStack((Item)Items.field_151167_ab));
            if (w == 0) {
                this.func_70062_b(0, new ItemStack(Items.field_151040_l));
            } else if (w == 1) {
                this.func_70062_b(0, new ItemStack(DTItems.ironHammer));
            } else {
                this.func_70062_b(0, new ItemStack(DTItems.ironKnife));
            }
        }
    }

    public static void spawnGuardian(EntitySkeleton target) {
        target.func_70606_j(0.0f);
        target.func_70106_y();
        EntityTowerGuardian guardian = new EntityTowerGuardian(target.field_70170_p);
        boolean flag = guardian.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        guardian.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
        guardian.func_180481_a(guardian.field_70170_p.func_175649_E(target.func_180425_c()));
        guardian.field_70170_p.func_72838_d((Entity)guardian);
        guardian.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(target.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v));
        guardian.field_70170_p.func_72885_a((Entity)guardian, guardian.field_70165_t, guardian.field_70163_u, guardian.field_70161_v, 1.0f, false, flag);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    protected String func_70639_aQ() {
        return "mob.skeleton.say";
    }

    protected String func_70621_aR() {
        return "mob.skeleton.hurt";
    }

    protected String func_70673_aS() {
        return "mob.skeleton.death";
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_85030_a("mob.skeleton.step", 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70631_g_() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

