/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DTConfigHandler {
    public static Configuration configuration;
    public static boolean sitting;
    public static boolean weaponEffects;
    public static int hearts;
    public static int lootbags;
    public static int boneCharms;
    public static boolean oreClusters;
    public static int flowers;
    public static boolean treasures;
    public static boolean netherGold;
    public static int dungeonSpacing;
    public static int netherDungeonChance;
    public static int dungeonMinHeight;
    public static int dungeonMaxHeight;
    public static boolean dungeons;
    public static int enchantIDS;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            DTConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        weaponEffects = configuration.getBoolean("WeaponAbilities", "feature", true, "Set 'false' to disable the right-click effectss of melee weapons.");
        sitting = configuration.getBoolean("Sitting", "feature", true, "Set 'false' to disable sitting.");
        hearts = configuration.getInt("HeartDrops", "feature", 20, 0, 100, "Percentage chance for Heart Drops. Set to 100 for guarenteed drops, 0 to disable.");
        oreClusters = configuration.getBoolean("OreClusters", "feature", true, "Set 'false' to disable Iron and Gold (and Nether Gold) fortunable ore drops.");
        lootbags = configuration.getInt("LootBagDrops", "feature", 10, 0, 100, "Percentage chance for Loot Bags. Set to 100 for guarenteed drops, 0 to disable.");
        boneCharms = configuration.getInt("BoneCharmDrops", "feature", 10, 0, 100, "Percentage chance for Bone Charms. Set to 100 for guarenteed drops, 0 to disable.");
        flowers = configuration.getInt("FlowerGeneration", "world", 32, 0, 100, "Set higher for more Dungeon Tactics Flowers.");
        treasures = configuration.getBoolean("TreasureBoxes", "world", true, "Set 'false' to disable Dungeon Tactics tresure boxes.");
        netherGold = configuration.getBoolean("NetherGold", "world", true, "Set 'false' to disable Nether Gold from being generated.");
        netherDungeonChance = configuration.getInt("DungeonNetherChance", "world", 9, 0, 100, "Percentage chance for Towers/Dungeons to be 'Nether themed'. Set to 100 for guarenteed chance, 0 to disable.");
        dungeonSpacing = configuration.getInt("DungeonSpacing", "world", 1000, 50, 5000, "Rough distance between Towers/Dungeons.");
        dungeonMinHeight = configuration.getInt("DungeonMinHeight", "world", 2, 0, 20, "Minimum floors for towers to generate (actual number is +1).");
        dungeonMaxHeight = configuration.getInt("DungeonMaxHeight", "world", 10, 0, 20, "Maximum floors for towers to generate (actual number is +1 - Set equal to/lower than min height to restrict randomisation to this number).");
        dungeons = configuration.getBoolean("DungeonGeneration", "world", true, "Set 'false' to disable Dungeon Tactics structures.");
        enchantIDS = configuration.getInt("EnchantIDS", "feature", 80, 80, 200, "This will set the start number for DT Enchantment IDS.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("DungeonTactics")) {
            DTConfigHandler.loadConfiguration();
        }
    }

    static {
        sitting = true;
        weaponEffects = true;
        hearts = 20;
        lootbags = 10;
        boneCharms = 10;
        oreClusters = true;
        flowers = 32;
        treasures = true;
        netherGold = true;
        dungeonSpacing = 1000;
        netherDungeonChance = 9;
        dungeonMinHeight = 2;
        dungeonMaxHeight = 10;
        dungeons = true;
        enchantIDS = 80;
    }
}

