/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class DTEntityData
implements IExtendedEntityProperties {
    public static final String propertiesName = "DTEntityData";
    private final EntityPlayer player;
    private final EntityMob mob;
    private int currentStamina;
    private int attackTime;

    public DTEntityData(EntityPlayer player) {
        this.player = player;
        this.mob = null;
        this.currentStamina = 0;
        this.attackTime = 0;
    }

    public DTEntityData(EntityMob mob) {
        this.player = null;
        this.mob = mob;
        this.attackTime = 0;
    }

    public static final void registerPlayerDT(EntityPlayer player) {
        player.registerExtendedProperties(propertiesName, (IExtendedEntityProperties)new DTEntityData(player));
    }

    public static final DTEntityData getPlayerDT(EntityPlayer player) {
        return (DTEntityData)player.getExtendedProperties(propertiesName);
    }

    public static final void registerMobDT(EntityMob mob) {
        mob.registerExtendedProperties(propertiesName, (IExtendedEntityProperties)new DTEntityData(mob));
    }

    public static final DTEntityData getMobDT(EntityMob mob) {
        return (DTEntityData)mob.getExtendedProperties(propertiesName);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("DTCurrentStamina", this.currentStamina);
        properties.func_74768_a("DTAttackTime", this.attackTime);
        compound.func_74782_a(propertiesName, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(propertiesName);
        this.currentStamina = properties.func_74762_e("DTCurrentStamina");
        this.attackTime = properties.func_74762_e("DTAttackTime");
    }

    public void init(Entity entity, World world) {
    }

    public boolean consumeStamina(int amount) {
        this.currentStamina += amount;
        return true;
    }

    public boolean increaseAttackTime(int amount) {
        this.attackTime += amount;
        return true;
    }

    public void onUpdate() {
        if (this.currentStamina > 0) {
            --this.currentStamina;
            if (this.player != null) {
                this.player.func_71020_j(0.1f);
            }
        }
        if (this.attackTime > 0) {
            --this.attackTime;
        }
    }

    public void replenishStamina() {
        this.currentStamina = 0;
    }

    public int getStamina() {
        return this.currentStamina;
    }

    public int getAttackTime() {
        return this.attackTime;
    }
}

