/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import PegBeard.DungeonTactics.Blocks.TileEntities.DTCushionEntity;
import PegBeard.DungeonTactics.Entities.EntityHuckling;
import PegBeard.DungeonTactics.Entities.EntityTowerGuardian;
import PegBeard.DungeonTactics.Handlers.DTBlocks;
import PegBeard.DungeonTactics.Handlers.DTConfigHandler;
import PegBeard.DungeonTactics.Handlers.DTEntityData;
import PegBeard.DungeonTactics.Handlers.DTItems;
import PegBeard.DungeonTactics.Items.DTArmourAdventure;
import PegBeard.DungeonTactics.Items.DTHammer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DTEventHandler {
    protected static Random eventRand;
    private static final List<Item> applicableSwords;

    public DTEventHandler() {
        applicableSwords.add(Items.field_151041_m);
        applicableSwords.add(Items.field_151052_q);
        applicableSwords.add(Items.field_151040_l);
        applicableSwords.add(Items.field_151010_B);
        applicableSwords.add(Items.field_151048_u);
        applicableSwords.add(DTItems.gildedSword);
        applicableSwords.add(DTItems.jewelledSword);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && DTEntityData.getPlayerDT((EntityPlayer)event.entity) == null) {
            DTEntityData.registerPlayerDT((EntityPlayer)event.entity);
        }
        if (event.entity instanceof EntityMob && DTEntityData.getMobDT((EntityMob)event.entity) == null) {
            DTEntityData.registerMobDT((EntityMob)event.entity);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DTEntityData.getPlayerDT((EntityPlayer)event.entity).onUpdate();
        }
        if (event.entity instanceof EntityMob) {
            DTEntityData.getMobDT((EntityMob)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onUseItem(PlayerUseItemEvent.Finish event) {
        if (event.item.func_77973_b() instanceof ItemFood) {
            float h = 0.3f * (float)((ItemFood)event.item.func_77973_b()).func_150905_g(event.item);
            event.entityPlayer.func_70691_i(h);
            if (h >= 2.0f) {
                DTEntityData.getPlayerDT(event.entityPlayer).replenishStamina();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean sitting = DTConfigHandler.configuration.get("feature", "Sitting", true).getBoolean(true);
        if (sitting && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            EntityPlayer player = event.entityPlayer;
            BlockPos pos = event.pos;
            Block block = event.world.func_180495_p(pos).func_177230_c();
            if (block != null && player.func_71045_bC() == null && event.world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                DTCushionEntity cushion;
                if (block instanceof BlockCarpet || block instanceof BlockBasePressurePlate) {
                    cushion = new DTCushionEntity(event.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.1);
                    event.world.func_72838_d((Entity)cushion);
                    player.func_70078_a((Entity)cushion);
                }
                if ((block instanceof BlockSlab || block instanceof BlockStairs) && !block.isSideSolid((IBlockAccess)event.world, pos, EnumFacing.UP)) {
                    cushion = new DTCushionEntity(event.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.5);
                    event.world.func_72838_d((Entity)cushion);
                    player.func_70078_a((Entity)cushion);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entity.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        Entity target = event.target;
        ItemStack stack = player.func_71045_bC();
        if (target.getClass() == EntityChicken.class && stack != null && stack.func_77973_b() == Items.field_151057_cb) {
            EntityChicken chicken = (EntityChicken)target;
            if (!chicken.field_70128_L && !chicken.func_70631_g_() && "Huckling".equals(stack.func_82833_r())) {
                EntityHuckling.spawnHuckling(chicken);
            }
        }
        if (target.getClass() == EntitySkeleton.class && stack != null && stack.func_77973_b() == Items.field_151156_bN) {
            EntitySkeleton skeleton = (EntitySkeleton)target;
            if (!skeleton.field_70128_L && !skeleton.func_70631_g_() && skeleton.func_71124_b(3) != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                EntityTowerGuardian.spawnGuardian(skeleton);
            }
        }
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack armor;
        if (event.entityLiving instanceof EntityPlayer && (armor = (player = (EntityPlayer)event.entityLiving).func_82169_q(1)) != null && armor.func_77973_b() == DTItems.rexoLeggings && player.field_70172_ad <= 0 && (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(Items.field_151016_H))) {
            DTArmourAdventure.burst(player.field_70170_p, player, armor);
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.func_82169_q(0) != null && player.func_82169_q(0).func_77973_b() == DTItems.rexoBoots && event.distance >= 1.5f) {
                DTArmourAdventure.bounce(player.field_70170_p, player, player.func_82169_q(0), event.distance);
                if (!player.field_70170_p.field_72995_K) {
                    event.distance /= 2.0f;
                }
            }
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == DTItems.pbh) {
                event.distance = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        EntityMob mob;
        if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityMob && (mob = (EntityMob)event.source.func_76346_g()).func_71124_b(0) != null && mob.func_71124_b(0).func_77973_b() instanceof DTHammer && DTEntityData.getMobDT(mob).getAttackTime() > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        ItemStack stack;
        DTEntityData props;
        EntityPlayer player;
        if (event.entityLiving != null) {
            if (event.entityLiving instanceof EntityPlayer) {
                player = (EntityPlayer)event.entityLiving;
                props = DTEntityData.getPlayerDT(player);
                stack = player.func_71045_bC();
                if (player.func_82169_q(2) != null && player.func_82169_q(2).func_77973_b() == DTItems.rexoHarness && eventRand.nextInt(5) == 0) {
                    props.replenishStamina();
                    event.ammount = 0.0f;
                }
                if (event.ammount >= event.entityLiving.func_110143_aJ() && player.field_71071_by.func_146028_b(DTItems.phylactery)) {
                    player.func_70691_i(player.func_110138_aP());
                    player.func_70690_d(new PotionEffect(Potion.field_76429_m.func_76396_c(), 60, 0));
                    player.field_71071_by.func_146026_a(DTItems.phylactery);
                    player.field_70170_p.func_72956_a((Entity)player, "mob.wither.spawn", 1.0f, 1.0f);
                    event.setCanceled(true);
                }
                if (DTConfigHandler.configuration.get("feature", "WeaponAbilities", true).getBoolean(true) && stack != null && applicableSwords.contains(stack.func_77973_b()) && player.func_70632_aY() && applicableSwords.contains(stack.func_77973_b()) && (props.getStamina() <= 0 || player.field_71075_bZ.field_75098_d)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        props.consumeStamina(60);
                    }
                    player.func_71059_n(event.source.func_76346_g());
                    player.field_70172_ad += 20;
                }
                if (stack != null && stack.func_77973_b() == DTItems.pbh && event.source.func_94541_c()) {
                    event.setCanceled(true);
                }
            }
            if (event.entityLiving instanceof EntityHuckling && event.ammount >= event.entityLiving.func_110143_aJ()) {
                boolean flag = event.entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                event.entityLiving.field_70170_p.func_72876_a(event.entity, event.entity.field_70165_t, event.entity.field_70163_u + 0.5, event.entity.field_70161_v, 1.0f, flag);
            }
        }
        if (event.source.func_76346_g() != null) {
            EntityMob mob;
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                player = (EntityPlayer)event.source.func_76346_g();
                props = DTEntityData.getPlayerDT(player);
                stack = player.func_71045_bC();
                if (stack != null && stack.func_77973_b() instanceof DTHammer) {
                    if (props.getAttackTime() > 0) {
                        event.setCanceled(true);
                    } else {
                        props.increaseAttackTime(20);
                    }
                }
            }
            if (event.source.func_76346_g() instanceof EntityMob && (mob = (EntityMob)event.source.func_76346_g()).func_71124_b(0) != null && mob.func_71124_b(0).func_77973_b() instanceof DTHammer) {
                DTEntityData.getMobDT(mob).increaseAttackTime(20);
            }
        }
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent event) {
        if (event.item.func_92059_d().func_77973_b() == DTItems.heartDrop) {
            event.item.func_70106_y();
            event.setCanceled(true);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.successful_hit", 0.2f, 1.0f / (eventRand.nextFloat() * 0.4f + 1.2f));
            if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer.field_71071_by.func_146028_b(Items.field_151069_bo)) {
                event.entityPlayer.field_71071_by.func_146026_a(Items.field_151069_bo);
                event.entityPlayer.func_70099_a(new ItemStack(DTItems.heartJar), 1.0f);
            } else {
                event.entityPlayer.func_70691_i(2.0f);
                DTEntityData.getPlayerDT(event.entityPlayer).replenishStamina();
            }
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        EntityPigZombie pigman;
        EntitySkeleton skeleton;
        EntityZombie zombie;
        eventRand = new Random();
        int i = eventRand.nextInt(100);
        if (event.entity instanceof EntityZombie && !(event.entity instanceof EntityTowerGuardian) && (zombie = (EntityZombie)event.entity).func_71124_b(0) != null && zombie.func_71124_b(0).func_77973_b() == Items.field_151040_l) {
            if (i < 50) {
                event.entity.func_70062_b(0, new ItemStack(DTItems.ironHammer));
            } else {
                return;
            }
        }
        if (event.entity instanceof EntitySkeleton && (skeleton = (EntitySkeleton)event.entity).func_71124_b(0) != null) {
            if (skeleton.func_82202_m() == 0) {
                if (i < 20) {
                    skeleton.func_70062_b(0, new ItemStack(DTItems.ironKnife));
                } else {
                    return;
                }
            }
            if (skeleton.func_82202_m() == 1) {
                if (i < 40) {
                    skeleton.func_70062_b(0, new ItemStack(DTItems.stoneHammer));
                } else {
                    return;
                }
            }
        }
        if (event.entity instanceof EntityPigZombie && !(event.entity instanceof EntityTowerGuardian) && (pigman = (EntityPigZombie)event.entity).func_71124_b(0) != null) {
            if (i < 40) {
                event.entity.func_70062_b(0, new ItemStack(DTItems.goldenHammer));
            } else {
                return;
            }
        }
    }

    public ItemStack getLootBag() {
        switch (eventRand.nextInt(6)) {
            case 0: {
                return new ItemStack(DTItems.foodBag);
            }
            case 1: {
                return new ItemStack(DTItems.oreBag);
            }
            case 2: {
                return new ItemStack(DTItems.toolBag);
            }
            case 3: {
                return new ItemStack(DTItems.bookBag);
            }
            case 4: {
                return new ItemStack(DTItems.recordBag);
            }
            case 5: {
                return new ItemStack(DTItems.recordBag);
            }
        }
        return null;
    }

    public ItemStack getBoneCharm() {
        switch (eventRand.nextInt(9)) {
            case 0: {
                return new ItemStack(DTItems.toxicCharm);
            }
            case 1: {
                return new ItemStack(DTItems.sappingCharm);
            }
            case 2: {
                return new ItemStack(DTItems.heavyCharm);
            }
            case 3: {
                return new ItemStack(DTItems.emaciatedCharm);
            }
            case 4: {
                return new ItemStack(DTItems.unintelligibleCharm);
            }
            case 5: {
                return new ItemStack(DTItems.darkenedCharm);
            }
            case 6: {
                return new ItemStack(DTItems.famineCharm);
            }
            case 7: {
                return new ItemStack(DTItems.barrenCharm);
            }
            case 8: {
                return new ItemStack(DTItems.searingCharm);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EnumDifficulty difficulty = event.entityLiving.field_70170_p.func_175659_aa();
        boolean canDrop = event.entityLiving.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
        int heartConfig = DTConfigHandler.configuration.get("feature", "HeartDrops", 20).getInt(20);
        int lootbagsConfig = DTConfigHandler.configuration.get("feature", "LootBagDrops", 10).getInt(10);
        int bonecharmsConfig = DTConfigHandler.configuration.get("feature", "BoneCharmDrops", 10).getInt(10);
        eventRand = new Random();
        if (!event.entityLiving.field_70170_p.field_72995_K && canDrop && event.recentlyHit) {
            if (event.entityLiving instanceof EntityLiving && eventRand.nextInt(100) < heartConfig / 2) {
                if (difficulty != EnumDifficulty.EASY) {
                    event.entityLiving.func_70099_a(new ItemStack(DTItems.heartDrop), 1.0f);
                }
            }
            if (event.entityLiving instanceof EntityMob) {
                if (eventRand.nextInt(100) < heartConfig) {
                    if (difficulty != EnumDifficulty.EASY) {
                        event.entityLiving.func_70099_a(new ItemStack(DTItems.heartDrop), (float)(eventRand.nextInt(1) + 1));
                    }
                }
                if (eventRand.nextInt(100) < lootbagsConfig) {
                    event.entityLiving.func_70099_a(this.getLootBag(), 1.0f);
                }
            }
            if (event.entityLiving instanceof EntityTowerGuardian) {
                event.drops.clear();
                event.drops.add(new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, new ItemStack(Items.field_151166_bC, 1 + eventRand.nextInt(2))));
                if (eventRand.nextInt(100) < bonecharmsConfig) {
                    event.entityLiving.func_70099_a(this.getBoneCharm(), 1.0f);
                }
            }
            if (event.entityLiving instanceof EntityWither || event.entityLiving instanceof EntityDragon || event.entityLiving instanceof EntityGuardian) {
                if (heartConfig != 0) {
                    event.entityLiving.func_70099_a(new ItemStack(DTItems.heartDrop), (float)(3 + eventRand.nextInt(3)));
                    event.entityLiving.func_70099_a(new ItemStack(DTItems.heartJar), (float)eventRand.nextInt(3));
                    event.entityLiving.func_70099_a(new ItemStack(DTItems.heartGolden), (float)eventRand.nextInt(2));
                }
                if (eventRand.nextInt(100) < lootbagsConfig * 2) {
                    event.entityLiving.func_70099_a(this.getLootBag(), 1.0f);
                }
                if (event.entityLiving instanceof EntityWither && eventRand.nextInt(100) < bonecharmsConfig) {
                    event.entityLiving.func_70099_a(new ItemStack(DTItems.phylactery), 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        int i;
        boolean oresConfig = DTConfigHandler.configuration.get("feature", "OreClusters", true).getBoolean(true);
        if (event.isSilkTouching) {
            return;
        }
        if (event.drops.isEmpty()) {
            return;
        }
        if (oresConfig) {
            ItemStack tool;
            int count = this.randomCount(event.drops.size(), event.fortuneLevel, event.world);
            if (event.state.func_177230_c() == Blocks.field_150366_p) {
                event.drops.clear();
                for (i = 0; i < count; ++i) {
                    event.drops.add(new ItemStack(DTItems.ironCluster, 1));
                }
            }
            if (event.state.func_177230_c() == Blocks.field_150352_o) {
                event.drops.clear();
                for (i = 0; i < count; ++i) {
                    event.drops.add(new ItemStack(DTItems.goldCluster, 1));
                }
            }
            if (event.harvester != null && (tool = event.harvester.func_71045_bC()) != null && tool.func_77973_b() instanceof DTHammer) {
                if (event.state.func_177230_c() == Blocks.field_150347_e) {
                    event.drops.clear();
                    event.drops.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150351_n), 1));
                }
                if (event.state.func_177230_c() == Blocks.field_150351_n) {
                    event.drops.clear();
                    event.drops.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 1));
                    int chance = eventRand.nextInt(3);
                    for (int i2 = 0; i2 < chance; ++i2) {
                        int h = eventRand.nextInt(3);
                        switch (i2) {
                            case 0: {
                                event.drops.add(new ItemStack(DTItems.ironCluster, 1));
                            }
                            case 1: {
                                event.drops.add(new ItemStack(Items.field_151137_ax, 1));
                            }
                            case 2: {
                                event.drops.add(new ItemStack(Items.field_151145_ak, 1));
                            }
                        }
                    }
                }
            }
        }
        if (event.state.func_177230_c() == DTBlocks.bushBaring) {
            int ammount = 1 + eventRand.nextInt(3);
            for (i = 0; i < ammount; ++i) {
                event.drops.add(new ItemStack(DTItems.cherryBomb, 1));
            }
        }
    }

    private int randomCount(int baseCount, int fortuneLevel, World world) {
        if (fortuneLevel > 0) {
            int j = eventRand.nextInt(fortuneLevel + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return baseCount * (j + 1);
        }
        return baseCount;
    }

    static {
        applicableSwords = Lists.newArrayList();
    }
}

