/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import PegBeard.DungeonTactics.Handlers.DTBlocks;
import PegBeard.DungeonTactics.Handlers.DTConfigHandler;
import PegBeard.DungeonTactics.WorldGen.DTDungeon;
import PegBeard.DungeonTactics.WorldGen.DTTower;
import PegBeard.DungeonTactics.WorldGen.DTWorldDecorator;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class DTWorldGen
implements IWorldGenerator {
    int flowers = DTConfigHandler.configuration.get("world", "FlowerGeneration", 32).getInt(32);
    boolean treasures = DTConfigHandler.configuration.get("world", "TreasureBoxes", true).getBoolean(true);
    boolean netherGold = DTConfigHandler.configuration.get("world", "NetherGold", true).getBoolean(true);
    boolean structures = DTConfigHandler.configuration.get("world", "DungeonGeneration", true).getBoolean(true);
    int structureDistance = DTConfigHandler.configuration.get("world", "DungeonSpacing", 1000).getInt(1000);
    private static final List<String> flowerBiomes = Lists.newArrayList();

    public DTWorldGen() {
        flowerBiomes.add("Forest");
        flowerBiomes.add("Swampland");
        flowerBiomes.add("Roofed Forest");
        flowerBiomes.add("Jungle");
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case -1: {
                this.generateNether(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private static int floordiv(int start, int distance) {
        if (start % distance != 0) {
            // empty if block
        }
        return start / distance - (start < 0 ^ distance < 0 ? 1 : 0);
    }

    private boolean chunkContainsASpawnPosition(int coord, int spacing) {
        int chunksize = 16;
        int lowerEdge = DTWorldGen.floordiv(coord - 1, spacing);
        int upperEdge = DTWorldGen.floordiv(coord + 16 - 1, spacing);
        return upperEdge - lowerEdge == 1;
    }

    private void generateNether(World world, Random rand, int chunkX, int chunkZ) {
        if (this.netherGold) {
            for (int k = 0; k < 6; ++k) {
                int XCoord = chunkX + rand.nextInt(16);
                int YCoord = 5 + rand.nextInt(118);
                int ZCoord = chunkZ + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.netherGold.func_176223_P(), 6, (Predicate)BlockHelper.func_177642_a((Block)Blocks.field_150424_aL)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.structures && world.func_72912_H().func_76089_r() && this.chunkContainsASpawnPosition(chunkX, this.structureDistance) && this.chunkContainsASpawnPosition(chunkZ, this.structureDistance)) {
            int finalY = 10 + rand.nextInt(108);
            int finalX = chunkX + rand.nextInt(100) - rand.nextInt(100);
            int finalZ = chunkZ + rand.nextInt(100) - rand.nextInt(100);
            while (world.func_180495_p(new BlockPos(finalX, finalY, finalZ)).func_177230_c() != Blocks.field_150424_aL) {
                --finalY;
            }
            new DTWorldDecorator().generateMobBox(world, rand, new BlockPos(finalX, finalY, finalZ));
        }
    }

    private void generateOverworld(World world, Random rand, int chunkX, int chunkZ) {
        int i;
        BlockPos pos = new BlockPos(chunkX, world.func_72800_K(), chunkZ);
        BiomeGenBase biome = world.field_73011_w.getBiomeGenForCoords(pos);
        if (flowerBiomes.contains(biome.field_76791_y)) {
            for (i = 0; i < this.flowers; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                new DTWorldDecorator().generateFlower(world, rand, pos);
            }
        }
        for (i = 0; i < this.flowers; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateFlower(world, rand, pos);
        }
        for (i = 0; i < this.flowers / 2; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos);
        }
        if (this.treasures && world.func_72912_H().func_76089_r()) {
            for (i = 0; i < 1; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(100), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150361_u) continue;
                new DTWorldDecorator().func_180709_b(world, rand, pos);
            }
        }
        if (this.structures && world.func_72912_H().func_76089_r() && this.chunkContainsASpawnPosition(chunkX, this.structureDistance) && this.chunkContainsASpawnPosition(chunkZ, this.structureDistance)) {
            int finalY = world.func_72800_K();
            int finalX = chunkX + rand.nextInt(100) - rand.nextInt(100);
            int finalZ = chunkZ + rand.nextInt(100) - rand.nextInt(100);
            while (world.func_175623_d(new BlockPos(finalX, finalY, finalZ))) {
                --finalY;
            }
            pos = new BlockPos(finalX, finalY, finalZ);
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150353_l) {
                int chance = rand.nextInt(2);
                if (chance == 0 && pos.func_177956_o() >= 20) {
                    new DTDungeon().func_180709_b(world, rand, pos);
                } else {
                    new DTTower().func_180709_b(world, rand, pos);
                }
            }
        }
    }

    private void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
    }
}

