/*
 * Decompiled with CFR 0.152.
 */
package erebus;

import erebus.ModBlocks;
import erebus.blocks.BlockDoubleHeightPlant;
import erebus.blocks.BlockSmallPlant;
import erebus.blocks.BlockSwampVent;
import erebus.blocks.BlockWitherWeb;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;

public class ModColourManager {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public static void registerColourHandlers() {
        BlockColors blockColors = MINECRAFT.func_184125_al();
        ItemColors itemColors = MINECRAFT.getItemColors();
        ModColourManager.registerBlockColourHandlers(blockColors);
        ModColourManager.registerItemColourHandlers(blockColors, itemColors);
    }

    private static void registerBlockColourHandlers(BlockColors blockColors) {
        IBlockColor grassColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        IBlockColor witheWebColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return new Color(0, 0, 0).getRGB() & 0xFFFFFF;
            }
            return new Color(0, 0, 0).getRGB() & 0xFFFFFF;
        };
        IBlockColor tallFernColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null && state.func_177230_c() instanceof BlockDoubleHeightPlant && state.func_177229_b(BlockDoubleHeightPlant.VARIANT) == BlockDoubleHeightPlant.EnumPlantType.TALL_FERN) {
                return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            if (state.func_177230_c() instanceof BlockDoubleHeightPlant && state.func_177229_b(BlockDoubleHeightPlant.VARIANT) == BlockDoubleHeightPlant.EnumPlantType.TALL_FERN) {
                return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
            return -1;
        };
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.SMALL_PLANT});
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.SWAMP_VENT});
        blockColors.func_186722_a(witheWebColourHandler, new Block[]{ModBlocks.WITHER_WEB});
        blockColors.func_186722_a(tallFernColourHandler, new Block[]{ModBlocks.DOUBLE_PLANT});
    }

    private static void registerItemColourHandlers(BlockColors blockColors, ItemColors itemColors) {
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            if (state.func_177230_c() instanceof BlockSmallPlant && (state.func_177229_b(BlockSmallPlant.PLANT_TYPE) == BlockSmallPlant.EnumSmallPlantType.FIDDLE_HEAD || state.func_177229_b(BlockSmallPlant.PLANT_TYPE) == BlockSmallPlant.EnumSmallPlantType.FERN)) {
                return blockColors.func_186724_a(state, null, null, tintIndex);
            }
            if (state.func_177230_c() instanceof BlockSwampVent) {
                return blockColors.func_186724_a(state, null, null, tintIndex);
            }
            if (state.func_177230_c() instanceof BlockWitherWeb) {
                return blockColors.func_186724_a(state, null, null, tintIndex);
            }
            if (state.func_177230_c() instanceof BlockDoubleHeightPlant && state.func_177229_b(BlockDoubleHeightPlant.VARIANT) == BlockDoubleHeightPlant.EnumPlantType.TALL_FERN) {
                return blockColors.func_186724_a(state, null, null, tintIndex);
            }
            return -1;
        };
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.SMALL_PLANT});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.SWAMP_VENT});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.WITHER_WEB});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.DOUBLE_PLANT});
    }
}

